/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.grammar.label.LabelProducer;
import com.ibm.vis.engine.internal.legend.nonsimple.LegendDataCreator;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.FontHelper;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.LegendSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class SwatchLabel {
    private final LegendSpec legendSpec;
    private final LegendDataCreator dataCreator;
    private final boolean multiline;
    private final Font font;
    private final Vis vis;
    private Dim labelSize;
    private int maxLines = 0;
    private double maxLinesSetForWidth = 0.0;

    protected SwatchLabel(LegendSpec legendSpec, LegendDataCreator legendDataCreator, Vis vis) {
        this.legendSpec = legendSpec;
        this.dataCreator = legendDataCreator;
        this.vis = vis;
        this.multiline = legendSpec.multiline != null && legendSpec.multiline.equals("consistent");
        FontSpec fontSpec = legendSpec.labelStyle == null ? null : legendSpec.labelStyle.font;
        this.font = FontHelper.makeFromSpec(fontSpec, vis.getVisContext().getMinimumFontSize(), vis.getVisContext().usesFractionalMetrics());
    }

    protected Dim measureLabelSize(boolean bl) {
        double d = this.maxLabelLength(this.font);
        if (bl && this.dataCreator.hasLegendEntries() && this.dataCreator.isNumeric()) {
            int n = this.dataCreator.getDesiredTickCount();
            this.dataCreator.setDesiredTickCount(2);
            d = Math.max(d, this.maxLabelLength(this.font));
            this.dataCreator.setDesiredTickCount(50);
            d = Math.max(d, this.maxLabelLength(this.font));
            if (this.legendSpec.rows != null || this.legendSpec.columns != null) {
                int n2;
                int n3;
                int n4;
                int n5 = n4 = this.legendSpec.rows != null ? this.legendSpec.rows.intValue() : 1;
                if (n4 <= 0) {
                    n4 = 1;
                }
                int n6 = n3 = this.legendSpec.columns != null ? this.legendSpec.columns.intValue() : 1;
                if (n3 <= 0) {
                    n3 = 1;
                }
                if ((n2 = n4 * n3) > 2) {
                    this.dataCreator.setDesiredTickCount(n2);
                    d = Math.max(d, this.maxLabelLength(this.font));
                }
            }
            d += this.font.measureString(".");
            this.dataCreator.setDesiredTickCount(n);
        }
        return new Dim(Math.ceil(d) + 1.0, this.font.getHeight() * (double)this.getMaxNumberOfLines(null));
    }

    private int getMaxNumberOfLines(Double d) {
        if (!this.multiline) {
            return 1;
        }
        int n = 1;
        if (this.dataCreator.hasLegendEntries()) {
            for (String string : this.dataCreator.getLegendLabels()) {
                if (string == null) continue;
                int n2 = 0;
                int n3 = string.indexOf(10);
                String string2 = n3 > 0 ? string.substring(0, n3) : string;
                n2 += this.getLines(string2, d);
                while (n3 > 0) {
                    string2 = (n3 = (string = string.substring(n3 + 1)).indexOf(10)) > 0 ? string.substring(0, n3) : string;
                    n2 += this.getLines(string2, d);
                }
                n = Math.max(n, n2);
            }
        }
        return n;
    }

    private int getLines(String string, Double d) {
        if (d == null) {
            return 1;
        }
        Shape shape = ShapeFactory2.CreateRect(0.0, 0.0, d, Double.MAX_VALUE);
        String string2 = this.legendSpec.labelStyle != null ? this.legendSpec.labelStyle.align : "middle";
        String string3 = this.legendSpec.labelStyle != null ? this.legendSpec.labelStyle.valign : "middle";
        LabelProducer labelProducer = LabelProducer.makeSimpleInside(this.vis, this.legendSpec.labelStyle, string2, string3, null);
        Text text = labelProducer.makeLabel(new String[]{string}, shape);
        return text == null ? 1 : text.getNumLines();
    }

    private double maxLabelLength(Font font) {
        double d = 0.0;
        if (this.dataCreator.hasLegendEntries()) {
            for (String string : this.dataCreator.getLegendLabels()) {
                if (string == null) continue;
                int n = string.indexOf(10);
                while (n > 0) {
                    if (this.multiline) {
                        String string2 = string.substring(0, n);
                        d = Math.max(d, font.measureString(string2));
                        string = string.substring(n + 1);
                        n = string.indexOf(10);
                        continue;
                    }
                    string = string.substring(0, n) + "\u2026";
                    n = -1;
                }
                d = Math.max(d, font.measureString(string));
            }
        }
        return d;
    }

    final Dim getLabelSize() {
        if (this.labelSize == null) {
            this.labelSize = this.measureLabelSize(true);
        }
        return this.labelSize;
    }

    protected void resetLabelSize() {
        this.labelSize = null;
    }

    final boolean isMultiline() {
        return this.multiline;
    }

    boolean setAvailableWidth(Double d) {
        boolean bl;
        double d2;
        if (d == null) {
            return false;
        }
        if (this.labelSize == null || d.doubleValue() != this.labelSize.getWidth()) {
            double d3 = this.dataCreator.isNumeric() ? this.font.getSize() : 2.0 * this.font.getSize();
            d2 = Math.max(d, d3);
        } else {
            d2 = d;
        }
        int n = this.maxLines;
        if (this.maxLinesSetForWidth != d2) {
            this.maxLinesSetForWidth = d2;
            this.maxLines = this.getMaxNumberOfLines(d2);
        }
        double d4 = (double)this.maxLines * this.font.getHeight();
        if (this.labelSize == null) {
            this.labelSize = new Dim(d2, d4);
            bl = true;
        } else {
            bl = n != this.maxLines || this.labelSize.getWidth() != d2 || this.labelSize.getHeight() != d4;
            this.labelSize.setWidth(d2);
            this.labelSize.setHeight(d4);
        }
        return bl;
    }

    final int getMaxLines() {
        return this.maxLines;
    }

    void setMaxLines(int n) {
        this.labelSize.setHeight((double)n * this.font.getHeight());
        this.maxLines = n;
    }

    final Dim getMinimumSize() {
        double d = this.dataCreator.isNumeric() ? this.font.getSize() : 2.0 * this.font.getSize();
        return new Dim(d, this.font.getHeight());
    }
}

