/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.Bounds;
import com.ibm.vis.engine.internal.FormatWrapper;
import com.ibm.vis.engine.internal.LegendPosition;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.label.LabelProducer;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.layout.SizeInfo;
import com.ibm.vis.engine.internal.layout.length.Size;
import com.ibm.vis.engine.internal.legend.SwatchType;
import com.ibm.vis.engine.internal.legend.nonsimple.BaseLegend;
import com.ibm.vis.engine.internal.legend.nonsimple.ElementSwatch;
import com.ibm.vis.engine.internal.legend.nonsimple.LegendDataCreator;
import com.ibm.vis.engine.internal.legend.nonsimple.SceneToLegendConverter;
import com.ibm.vis.engine.internal.legend.nonsimple.SwatchAestheticCreator;
import com.ibm.vis.engine.internal.legend.nonsimple.SwatchLabel;
import com.ibm.vis.engine.internal.legend.nonsimple.SwatchLegendEntry;
import com.ibm.vis.engine.internal.legend.nonsimple.SwatchSizer;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.VisState;
import com.ibm.vis.engine.internal.scene.CustomGlyphBuilder;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneTree;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.CoordinatesSpec;
import com.ibm.vis.spec.internal.DataSpec;
import com.ibm.vis.spec.internal.ElementLabelSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FieldSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.GrammarSpec;
import com.ibm.vis.spec.internal.LayoutSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.MappingSpec;
import com.ibm.vis.spec.internal.ModifiesSpec;
import com.ibm.vis.spec.internal.PackParametersSpec;
import com.ibm.vis.spec.internal.SizeSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.SymbolSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2015\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class SwatchLegend
extends BaseLegend {
    private static final String SIZE_VALUE = "legendSizeValue";
    private static final String CLIP_COLOR = "legendClipColor";
    private static final int MINIMUM_NUMERIC_TICKS = 2;
    private static final int MAXIMUM_NUMERIC_TICKS = 21;
    private static final int EXTRA_PADDING = 2;
    private static final double TOLERANCE = 0.001;
    private final boolean isHorizontal;
    private final Element element;
    private final LabelProducer labelProducer;
    private final SwatchType swatchType;
    private final LegendDataCreator dataCreator;
    private final SwatchLegendEntry legendEntry;
    private boolean addFieldInfo;
    private final SwatchSizer sizer;
    private Double lastWidth;
    private Double lastHeight;
    private SizeInfo lastSizeInfo;
    private int numRows;
    private int numColumns;
    private final double VIS_BORDER = 2.0;
    private final double TEXT_CORRECTION = 5.0;
    public static final String LEGEND_META_VALUE = "value";

    protected SwatchLegend(Vis vis, LegendSpec legendSpec, int n, List<Aesthetic> list, boolean bl) {
        super(vis, legendSpec, n, list);
        this.setDefaultTitlePadding(0.0);
        SwatchLegend.validateLegendSpec(legendSpec);
        this.sizer = new SwatchSizer(this.aesthetics, vis.getVisContext(), legendSpec);
        LegendPosition legendPosition = vis.getLegendPosition(legendSpec);
        this.isHorizontal = legendSpec.orientation != null ? "horizontal".equals(legendSpec.orientation) : (this.sizer.isOrientationSpecialCase() ? this.sizer.isSpecialCaseHorizontal() : legendPosition == LegendPosition.TOP || legendPosition == LegendPosition.BOTTOM);
        this.swatchType = bl ? SwatchType.makeForFallback() : SwatchType.makeForAesthetics(this.aesthetics, legendSpec);
        this.addFieldInfo = true;
        if (this.swatchType.hasMixedSources()) {
            this.aesthetics.clear();
            this.aesthetics.add(this.firstAesthetic);
        }
        this.dataCreator = new LegendDataCreator(legendSpec, this.aesthetics, !this.isHorizontal);
        this.element = this.firstAesthetic.element;
        this.labelProducer = this.firstAesthetic.labelProducer;
        ElementSwatch elementSwatch = new ElementSwatch(this.swatchType, this.element, this.labelProducer, false, SwatchLegend.hasDashing(this.aesthetics), this.sizer);
        SwatchLabel swatchLabel = new SwatchLabel(legendSpec, this.dataCreator, this.parentVis);
        this.legendEntry = new SwatchLegendEntry(vis.getVisContext(), legendSpec, elementSwatch, swatchLabel, this.sizer);
        this.numRows = 0;
        this.numColumns = 0;
        this.lastWidth = null;
        this.lastHeight = null;
        this.lastSizeInfo = null;
        if (legendSpec.location != null && legendSpec.location instanceof BoundsSpec) {
            BoundsSpec boundsSpec = (BoundsSpec)legendSpec.location;
            Bounds bounds = new Bounds(boundsSpec, vis.getVisContext().getLogger());
            this.setSpecifiedBounds(bounds);
        }
    }

    void setFieldInfo(boolean bl) {
        this.addFieldInfo = bl;
    }

    private static void validateLegendSpec(LegendSpec legendSpec) {
        if (legendSpec != null && legendSpec.scale != null && legendSpec.scale.spans != null && legendSpec.scale.spans.length > 0 && legendSpec.scale.spans[0].categories != null) {
            Number[] numberArray = legendSpec.scale.spans[0].categories;
            HashSet<Number> hashSet = new HashSet<Number>();
            for (Number number : numberArray) {
                if (hashSet.contains(number)) {
                    throw new SpecException("In legend specifications, scale.spans[0].categories may not contain duplicates (" + number + " appears more than once)", ErrorCode.SPEC_INVALID_PARAMETERS, null);
                }
                hashSet.add(number);
            }
        }
    }

    private static boolean hasDashing(List<Aesthetic> list) {
        for (Aesthetic aesthetic : list) {
            if (!"dashing".equals(aesthetic.type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SizeInfo getContentSizeInfo(Double d, Double d2) {
        if (this.lastSizeInfo != null && SwatchLegend.doubleEquals(d, this.lastWidth) && SwatchLegend.doubleEquals(d2, this.lastHeight)) {
            return this.lastSizeInfo;
        }
        this.lastWidth = d;
        this.lastHeight = d2;
        if (this.legendEntry != null) {
            this.legendEntry.reset();
            this.legendEntry.layout();
        }
        if (this.sizer.isSizeChanging()) {
            try {
                Vis vis = this.parentVis.getLegendVis();
                VisState visState = this.setLegendVisSpec(d, d2, false);
                visState = vis.makeSceneTree(null, visState);
                SceneTree sceneTree = visState.getSceneTree();
                Dim dim = sceneTree.getSize();
                Size size = Size.makeFixed(dim.getWidth(), dim.getHeight());
                this.lastSizeInfo = new SizeInfo(size, Size.ZERO, size);
            }
            catch (Exception exception) {
                Dim dim = this.getTitleSize(d, d2);
                Size size = Size.makeFixed(dim.getWidth(), dim.getHeight());
                this.lastSizeInfo = new SizeInfo(size, Size.ZERO, size);
            }
        } else {
            Dim dim = this.getVisSize(d, d2, null);
            Size size = Size.makeFixed(dim.getWidth(), dim.getHeight());
            this.lastSizeInfo = new SizeInfo(size, Size.ZERO, size);
        }
        return this.lastSizeInfo;
    }

    private Dim getVisSize(Double d, Double d2, Dim dim) {
        Dim dim2 = this.getTitleSize(d, d2);
        if (!this.dataCreator.hasLegendEntries()) {
            return dim2;
        }
        this.calculateGeometry(d, d2, dim2);
        StyleSpec styleSpec = this.legendEntry.makeStyleSpec();
        double d3 = ((Number)styleSpec.width).doubleValue();
        double d4 = ((Number)styleSpec.height).doubleValue();
        CustomGlyphBuilder customGlyphBuilder = new CustomGlyphBuilder((SymbolSpec)styleSpec.symbol, new Dim(d3, d4), this.parentVis.getVisContext());
        Rect rect = customGlyphBuilder.makeCustomShape(0.0, 0.0, d3, d4, styleSpec).getBounds();
        double d5 = rect.getWidth();
        double d6 = rect.getHeight();
        if (this.swatchType.getType() == 11) {
            d6 += 5.0;
        }
        d3 = Math.max(d3, d5);
        d4 = Math.max(d4, d6);
        double d7 = Math.max(dim2.getWidth(), d3 * (double)this.numColumns) + 2.0;
        double d8 = dim2.getHeight() + d4 * (double)this.numRows + 2.0;
        if (d != null) {
            d7 = d;
        }
        if (d2 != null) {
            d8 = d2;
        }
        return new Dim(d7, d8);
    }

    private static boolean doubleEquals(Double d, Double d2) {
        if (d == null && d2 == null) {
            return true;
        }
        if (d == null || d2 == null) {
            return false;
        }
        return d.doubleValue() == d2.doubleValue();
    }

    @Override
    protected List<SceneNode> createContent() {
        Dim dim = this.getContentBounds().getExtent();
        ArrayList<SceneNode> arrayList = new ArrayList<SceneNode>();
        try {
            Dim dim2 = this.getTitleSize(dim.getWidth(), dim.getHeight());
            Dim dim3 = new Dim(dim.getWidth(), Math.max(dim2.getHeight(), dim.getHeight()));
            this.sizer.recalculateSizes();
            Vis vis = this.parentVis.getLegendVis();
            VisState visState = this.setLegendVisSpec(dim3.getWidth(), dim3.getHeight(), true);
            visState = vis.makeSceneTree(dim3, visState);
            SceneTree sceneTree = visState.getSceneTree();
            String string = this.dataCreator.getFieldName();
            SceneToLegendConverter sceneToLegendConverter = new SceneToLegendConverter((GroupSceneNode)sceneTree.getRoot(), this.legendIndex, string, "swatch");
            sceneToLegendConverter.setFieldInfo(this.addFieldInfo);
            GroupSceneNode groupSceneNode = sceneToLegendConverter.getLegend();
            Rect rect = new Rect(0.0, 0.0, dim.getWidth(), dim.getHeight());
            groupSceneNode.setClipBounds(rect);
            arrayList.add(groupSceneNode);
            return arrayList;
        }
        catch (Exception exception) {
            return arrayList;
        }
    }

    private VisState setLegendVisSpec(Double d, Double d2, boolean bl) {
        Vis vis = this.parentVis.getLegendVis();
        FormatWrapper formatWrapper = (FormatWrapper)vis.getVisContext().formatContext.integratorNumberFormatter;
        String string = this.dataCreator.getFieldName();
        if (formatWrapper != null) {
            formatWrapper.addMapping("legendField", string);
            formatWrapper.addMapping("legendValue", string);
        }
        return vis.setTypedSpecification(this.makeLegendSpec(d, d2, bl));
    }

    private void calculateRowsAndColumns(Double d, Double d2, Dim dim) {
        int n = this.dataCreator.getRowCount();
        if (n == 0) {
            this.numRows = 1;
            this.numColumns = 1;
            return;
        }
        this.numRows = 0;
        this.numColumns = 0;
        if (this.legendSpec.rows != null) {
            this.numRows = this.legendSpec.rows.intValue();
            if (this.numRows < 0) {
                this.numRows = 0;
            }
        }
        if (this.legendSpec.columns != null) {
            this.numColumns = this.legendSpec.columns.intValue();
            if (this.numColumns < 0) {
                this.numColumns = 0;
            }
        }
        if (this.numRows > 0 || this.numColumns > 0) {
            if (this.numColumns == 0) {
                this.numColumns = (int)Math.ceil((double)n / (double)this.numRows);
            }
            if (this.numRows == 0) {
                this.numRows = (int)Math.ceil((double)n / (double)this.numColumns);
            }
            return;
        }
        Dim dim2 = this.legendEntry.getSize();
        double d3 = n;
        if (d != null && d2 != null && this.dataCreator.isNumeric()) {
            d3 = 21.0;
        }
        if (d != null && (d2 != null || this.isHorizontal)) {
            this.numColumns = (int)Math.min(d3, Math.max(1.0, Math.floor((d - 2.0) / dim2.getWidth())));
        }
        if (!(d2 == null || d == null && this.isHorizontal)) {
            this.numRows = (int)Math.min(d3, Math.max(1.0, Math.floor((d2 - 2.0 - dim.getHeight()) / dim2.getHeight())));
        }
        if (this.numRows > 0 || this.numColumns > 0) {
            if (this.numColumns == 0) {
                this.numColumns = (int)Math.ceil((double)n / (double)this.numRows);
            }
            if (this.numRows == 0) {
                this.numRows = (int)Math.ceil((double)n / (double)this.numColumns);
            }
            return;
        }
        if (this.isHorizontal) {
            this.numRows = 1;
            this.numColumns = n;
        } else {
            this.numRows = n;
            this.numColumns = 1;
        }
    }

    private VisJSONSpec makeLegendSpec(Double d, Double d2, boolean bl) {
        this.calculateGeometry(d, d2, null);
        VisJSONSpec visJSONSpec = new VisJSONSpec();
        visJSONSpec.style = new StyleSpec();
        visJSONSpec.style.fill = "transparent";
        this.addVersion(visJSONSpec);
        if (d != null || d2 != null) {
            visJSONSpec.size = new SizeSpec();
            visJSONSpec.size.width = d;
            visJSONSpec.size.height = d2;
        }
        if (this.aesthetics.size() == 0) {
            return visJSONSpec;
        }
        visJSONSpec.titles = this.makeTitles();
        if (this.parentVis.getVisContext().isUpdateDataOnly()) {
            this.dataCreator.reset();
        }
        if (!this.dataCreator.hasLegendEntries()) {
            return visJSONSpec;
        }
        visJSONSpec.data = this.dataCreator.getDataSpec();
        GrammarSpec grammarSpec = new GrammarSpec();
        visJSONSpec.grammar = new GrammarSpec[]{grammarSpec};
        grammarSpec.style = new StyleSpec();
        grammarSpec.style.fill = "transparent";
        grammarSpec.labelCollisionMethod = "none";
        grammarSpec.coordinates = new CoordinatesSpec();
        ElementsSpec elementsSpec = new ElementsSpec();
        grammarSpec.elements = new ElementsSpec[]{elementsSpec};
        elementsSpec.type = "point";
        elementsSpec.positioning = new LayoutSpec();
        elementsSpec.positioning.method = "pack";
        elementsSpec.positioning.orientation = this.isHorizontal ? "left-to-right" : "top-to-bottom";
        elementsSpec.positioning.packParameters = new PackParametersSpec();
        elementsSpec.positioning.packParameters.method = "grid";
        elementsSpec.positioning.packParameters.rows = this.numRows;
        elementsSpec.positioning.packParameters.columns = this.numColumns;
        elementsSpec.style = this.legendEntry.makeStyleSpec();
        elementsSpec.label = this.makeElementLabelSpec();
        SwatchAestheticCreator swatchAestheticCreator = new SwatchAestheticCreator(this.swatchType, this.element, this.dataCreator, this.aesthetics, this.sizer);
        swatchAestheticCreator.copyApplicableAesthetics(elementsSpec);
        elementsSpec.meta = this.makeMetaValueAesthetic();
        if (this.sizer != null && this.sizer.isSizeChanging() && this.dataCreator.getTickValues() != null) {
            Double[][] doubleArray;
            boolean bl2;
            double[] dArray = this.dataCreator.getTickValues();
            if (bl && (bl2 = this.isSizeClipped(doubleArray = this.sizer.getDataColumns(dArray, elementsSpec)))) {
                this.updateVisSpecForSizeClipping(visJSONSpec.data, elementsSpec, doubleArray);
            }
        }
        return visJSONSpec;
    }

    private void updateVisSpecForSizeClipping(DataSpec[] dataSpecArray, ElementsSpec elementsSpec, Double[][] doubleArray) {
        Object object;
        Object object2;
        boolean bl = false;
        boolean bl2 = false;
        AestheticSpec[] aestheticSpecArray = elementsSpec.size;
        AestheticSpec[] aestheticSpecArray2 = elementsSpec.font;
        AestheticSpec[] aestheticSpecArray3 = elementsSpec.styleBy;
        if (aestheticSpecArray == null && aestheticSpecArray2 == null && aestheticSpecArray3 == null) {
            return;
        }
        if (aestheticSpecArray != null) {
            object2 = aestheticSpecArray[aestheticSpecArray.length - 1];
            bl = this.updateField((AestheticSpec)object2);
        } else if (aestheticSpecArray2 != null) {
            object2 = aestheticSpecArray2[aestheticSpecArray2.length - 1];
            bl = this.updateField((AestheticSpec)object2);
        } else {
            object2 = new AestheticSpec[aestheticSpecArray3.length + 1];
            for (int i = 0; i < aestheticSpecArray3.length; ++i) {
                object2[i] = aestheticSpecArray3[i];
            }
            object = (AestheticSpec[])aestheticSpecArray3[aestheticSpecArray3.length - 1].copy();
            this.updateField((AestheticSpec)object);
            object.mapping = this.migrateSizeFromStyleMapping(aestheticSpecArray3[aestheticSpecArray3.length - 1].mapping);
            object.palette = this.migrateSizeFromStylePalette(aestheticSpecArray3[aestheticSpecArray3.length - 1].palette);
            object2[aestheticSpecArray3.length] = object;
            elementsSpec.styleBy = object2;
            bl = true;
        }
        if (this.appendFieldsForSizeClipping(dataSpecArray, bl)) {
            this.appendRowForSizeClipping(dataSpecArray, doubleArray);
            bl2 = true;
        }
        if ((object2 = elementsSpec.color) == null) {
            object2 = new AestheticSpec[1];
        } else {
            object = new AestheticSpec[((AestheticSpec[])object2).length + 1];
            for (int i = 0; i < ((AestheticSpec[])object2).length; ++i) {
                object[i] = object2[i];
            }
            object2 = object;
        }
        elementsSpec.color = object2;
        object2[((AestheticSpec[])object2).length - 1] = object = new AestheticSpec();
        object.field = new FieldValueRefSpec();
        object.field.$ref = CLIP_COLOR;
        ModifiesSpec modifiesSpec = new ModifiesSpec();
        modifiesSpec.part = "legendentry_tooLargesymbol9238749274";
        modifiesSpec.type = "both";
        modifiesSpec.descendants = true;
        Object[] objectArray = new Object[]{"black", "transparent"};
        object.palette = objectArray;
        object.modifies = modifiesSpec;
        if (bl2) {
            this.legendEntry.modifyStyleForSizeClipping(elementsSpec.style);
        }
    }

    protected boolean updateField(AestheticSpec aestheticSpec) {
        boolean bl = aestheticSpec.palette != null;
        aestheticSpec.field = new FieldValueRefSpec();
        aestheticSpec.field.$ref = SIZE_VALUE;
        return bl;
    }

    private Object[] migrateSizeFromStylePalette(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.migrateSizeFromStyle((StyleSpec)objectArray[i]);
        }
        return objectArray2;
    }

    private MappingSpec[] migrateSizeFromStyleMapping(MappingSpec[] mappingSpecArray) {
        if (mappingSpecArray == null) {
            return null;
        }
        MappingSpec[] mappingSpecArray2 = new MappingSpec[mappingSpecArray.length];
        for (int i = 0; i < mappingSpecArray.length; ++i) {
            mappingSpecArray2[i] = new MappingSpec();
            mappingSpecArray2[i].at = mappingSpecArray[i].at;
            mappingSpecArray2[i].style = this.migrateSizeFromStyle(mappingSpecArray[i].style);
        }
        return mappingSpecArray2;
    }

    private StyleSpec migrateSizeFromStyle(StyleSpec styleSpec) {
        if (styleSpec == null) {
            return null;
        }
        StyleSpec styleSpec2 = new StyleSpec();
        styleSpec2.size = styleSpec.size;
        styleSpec2.height = styleSpec.height;
        styleSpec2.width = styleSpec.width;
        styleSpec.size = null;
        styleSpec.height = null;
        styleSpec.width = null;
        if (styleSpec.font != null && styleSpec.font.size != null) {
            styleSpec2.font = new FontSpec();
            styleSpec2.font.size = styleSpec.font.size;
            styleSpec.font.size = null;
            styleSpec.font.setCachedObject(null);
        }
        return styleSpec2;
    }

    private void appendRowForSizeClipping(DataSpec[] dataSpecArray, Number[][] numberArray) {
        double[][] dArray = dataSpecArray[0].rows;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.augmentRow(dArray[i], numberArray[0][i], numberArray[1][i]);
        }
    }

    private double[] augmentRow(double[] dArray, Number number, Number number2) {
        double[] dArray2 = new double[dArray.length + 2];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i];
        }
        dArray2[dArray.length] = number != null ? number.doubleValue() : Double.NaN;
        dArray2[dArray.length + 1] = number2 != null ? number2.doubleValue() : Double.NaN;
        return dArray2;
    }

    protected boolean appendFieldsForSizeClipping(DataSpec[] dataSpecArray, boolean bl) {
        FieldSpec[] fieldSpecArray = dataSpecArray[0].fields;
        for (int i = 0; i < fieldSpecArray.length; ++i) {
            if (fieldSpecArray[i] == null || fieldSpecArray[i].id == null || !fieldSpecArray[i].id.equals(SIZE_VALUE) && !fieldSpecArray[i].id.equals(CLIP_COLOR)) continue;
            return false;
        }
        FieldSpec[] fieldSpecArray2 = new FieldSpec[fieldSpecArray.length + 2];
        for (int i = 0; i < fieldSpecArray.length; ++i) {
            fieldSpecArray2[i] = fieldSpecArray[i];
        }
        FieldSpec fieldSpec = new FieldSpec();
        fieldSpec.id = SIZE_VALUE;
        if (bl) {
            fieldSpec.unit = "categorical";
        }
        fieldSpecArray2[fieldSpecArray.length] = fieldSpec;
        fieldSpec = new FieldSpec();
        fieldSpec.id = CLIP_COLOR;
        fieldSpec.unit = "categorical";
        fieldSpecArray2[fieldSpecArray.length + 1] = fieldSpec;
        dataSpecArray[0].fields = fieldSpecArray2;
        return true;
    }

    private boolean isSizeClipped(Double[][] doubleArray) {
        if (doubleArray == null) {
            return false;
        }
        Double[] doubleArray2 = doubleArray[1];
        for (int i = 0; i < doubleArray2.length; ++i) {
            if (!(doubleArray2[i] < 1.0)) continue;
            return true;
        }
        return false;
    }

    private void calculateGeometry(Double d, Double d2, Dim dim) {
        this.legendEntry.layout();
        this.legendEntry.makeStyleSpec();
        Dim dim2 = dim == null ? this.getTitleSize(d, d2) : dim;
        this.calculateRowsAndColumns(d, d2, dim2);
        Dim dim3 = this.legendEntry.getSize();
        dim3.setWidth(dim3.getWidth() * (double)this.numColumns);
        dim3.setHeight(dim3.getHeight() * (double)this.numRows);
        boolean bl = false;
        int n = 0;
        while (!bl && n < 25 && this.shouldReduce(d, d2, dim2, dim3)) {
            boolean bl2;
            ++n;
            int n2 = this.numRows;
            int n3 = this.numColumns;
            this.calculateRowsAndColumns(null, null, dim2);
            Dim dim4 = new Dim(Double.MAX_VALUE, Double.MAX_VALUE);
            if (d != null) {
                dim4.setWidth(Math.floor((d - 2.0) / (double)this.numColumns));
            }
            if (d2 != null) {
                dim4.setHeight(Math.floor((d2 - dim2.getHeight() - 2.0) / (double)this.numRows));
            }
            if (bl2 = this.legendEntry.reduceSize(dim4, this.dataCreator.isNumeric())) {
                this.calculateRowsAndColumns(d, d2, dim2);
                dim3 = this.legendEntry.getSize();
                dim3.setWidth(dim3.getWidth() * (double)this.numColumns);
                dim3.setHeight(dim3.getHeight() * (double)this.numRows);
                continue;
            }
            this.numRows = n2;
            this.numColumns = n3;
            bl = true;
        }
        this.adjustDesiredTickCountForNumeric(d, d2);
    }

    private boolean shouldReduce(Double d, Double d2, Dim dim, Dim dim2) {
        int n = this.dataCreator.getRowCount();
        boolean bl = this.legendSpec.rows != null && this.legendSpec.columns != null;
        boolean bl2 = this.legendEntry.canReduceHorizontal();
        boolean bl3 = this.legendEntry.canReduceVertical();
        if (this.numRows * this.numColumns < n && !bl) {
            return bl2 || bl3;
        }
        if (d != null && dim2.getWidth() > d - 2.0 + 0.001 && bl2) {
            return true;
        }
        return d2 != null && dim2.getHeight() > d2 - dim.getHeight() - 2.0 + 0.001 && bl3;
    }

    private void adjustDesiredTickCountForNumeric(Double d, Double d2) {
        if (d != null && d2 != null && this.dataCreator.hasLegendEntries() && this.dataCreator.isNumeric()) {
            int n;
            int n2 = n = this.numRows * this.numColumns;
            this.dataCreator.setDesiredTickCount(n2);
            double d3 = this.legendEntry.measureLabelSize().getWidth();
            double d4 = this.legendEntry.getLabelSize().getWidth();
            int n3 = this.dataCreator.getRowCount();
            if (n3 > n || n2 > 21) {
                if (n2 > 21) {
                    n2 = 22;
                    this.dataCreator.setDesiredTickCount(n2);
                }
                while (n2 > 2 && (n3 > n || d3 > d4)) {
                    this.dataCreator.setDesiredTickCount(--n2);
                    n3 = this.dataCreator.getRowCount();
                    d3 = this.legendEntry.measureLabelSize().getWidth();
                    d4 = this.legendEntry.getLabelSize().getWidth();
                }
            }
        }
    }

    private String determineTypeOfContent() {
        ValueProvider valueProvider = this.firstAesthetic.valueProvider;
        String string = "";
        string = !valueProvider.isCategorical() ? (!valueProvider.getFormatter().isRAVEFormatterEmpty() || valueProvider.getUnit() != null && !valueProvider.getUnit().name.equals(Unit.RATIO.name) ? "legendString" : "legendValue") : "legendString";
        return string;
    }

    private ElementLabelSpec[] makeElementLabelSpec() {
        ElementLabelSpec elementLabelSpec = new ElementLabelSpec();
        FieldValueRefSpec fieldValueRefSpec = new FieldValueRefSpec();
        fieldValueRefSpec.$ref = this.determineTypeOfContent();
        elementLabelSpec.content = new Object[]{fieldValueRefSpec};
        elementLabelSpec.modifies = new ModifiesSpec();
        elementLabelSpec.modifies.part = "legendentry_label9238749274";
        if (this.legendSpec.labelStyle != null) {
            elementLabelSpec.style = (StyleSpec)this.legendSpec.labelStyle.copy();
            elementLabelSpec.style.padding = null;
            if (elementLabelSpec.style.align == null) {
                elementLabelSpec.style.align = "start";
            }
            if (elementLabelSpec.style.valign == null || elementLabelSpec.style.valign.equals("middleOfFirstLine")) {
                elementLabelSpec.style.valign = "start";
            }
            elementLabelSpec.style.location = "inside";
        } else {
            elementLabelSpec.style = new StyleSpec();
            elementLabelSpec.style.align = "start";
            elementLabelSpec.style.valign = "start";
            elementLabelSpec.style.location = "inside";
        }
        return new ElementLabelSpec[]{elementLabelSpec};
    }

    private AestheticSpec[] makeMetaValueAesthetic() {
        AestheticSpec aestheticSpec = new AestheticSpec();
        aestheticSpec.key = LEGEND_META_VALUE;
        aestheticSpec.field = new FieldValueRefSpec();
        aestheticSpec.field.$ref = "legendValue";
        aestheticSpec.scale = this.dataCreator.getScaleSpec();
        return new AestheticSpec[]{aestheticSpec};
    }
}

