/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.legend.nonsimple.ElementSwatch;
import com.ibm.vis.engine.internal.legend.nonsimple.SwatchLabel;
import com.ibm.vis.engine.internal.legend.nonsimple.SwatchSizer;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.FontHelper;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.SymbolShapeSpec;
import com.ibm.vis.spec.internal.SymbolSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class SwatchLegendEntry {
    protected static final String SWATCHLEGENDENTRY_ENTRY = "legendentry_entry9238749274";
    protected static final String SWATCHLEGENDENTRY_SWATCHBOX = "legendentry_swatchBox9238749274";
    protected static final String SWATCHLEGENDENTRY_LABEL = "legendentry_label9238749274";
    protected static final String SWATCHLEGENDENTRY_TOO_LARGE_SYMBOL = "legendentry_tooLargesymbol9238749274";
    private final VisContext visContext;
    private final LegendSpec legendSpec;
    private Insets legendEntryPadding;
    private Insets swatchPadding;
    private Insets swatchBoxPadding;
    private Insets labelPadding;
    private double fontSize;
    private Rect legendEntryRect;
    private Rect swatchBoxRect;
    private Rect swatchRect;
    private Rect labelRect;
    private Rect oversizeRect;
    private SymbolShapeSpec swatchSymbol;
    private final ElementSwatch elementSwatch;
    private final SwatchLabel swatchLabel;
    private final SwatchSizer sizer;
    protected static final double DEFAULT_LEGEND_ENTRY_PADDING = 2.5;

    SwatchLegendEntry(VisContext visContext, LegendSpec legendSpec, ElementSwatch elementSwatch, SwatchLabel swatchLabel, SwatchSizer swatchSizer) {
        this.visContext = visContext;
        this.legendSpec = legendSpec;
        this.elementSwatch = elementSwatch;
        this.swatchLabel = swatchLabel;
        this.sizer = swatchSizer;
    }

    void layout() {
        Dim dim;
        Dim dim2 = this.swatchLabel.getLabelSize();
        boolean bl = this.swatchLabel.isMultiline();
        this.swatchSymbol = this.elementSwatch.makeSwatchSpecification(this.legendSpec.itemStyle);
        if (this.sizer != null && this.sizer.getMaxSymbolSwatch() != null) {
            dim = this.sizer.getMaxSymbolSwatch();
        } else {
            double d = ((Number)this.swatchSymbol.style.width).doubleValue();
            double d2 = ((Number)this.swatchSymbol.style.height).doubleValue();
            dim = new Dim(d, d2);
        }
        if (!bl) {
            Double d;
            this.fontSize = FontHelper.getDefaultFontSize(this.visContext.getMinimumFontSize());
            if (this.legendSpec.labelStyle != null && this.legendSpec.labelStyle.font != null && this.legendSpec.labelStyle.font.size != null && (d = UnitConverter.convertLength(this.legendSpec.labelStyle.font.size, 10.0, 10.0)) != null) {
                this.fontSize = d;
            }
            dim2.setHeight(1.5 * this.fontSize);
        }
        Dim dim3 = new Dim(10.0, 10.0);
        this.legendEntryPadding = SwatchLegendEntry.makePaddingForStyle(this.legendSpec.legendEntryStyle, dim3, 2.5);
        this.swatchPadding = SwatchLegendEntry.makePaddingForStyle(this.legendSpec.itemStyle, dim3, 0.0);
        this.swatchBoxPadding = SwatchLegendEntry.makePaddingForStyle(this.legendSpec.itemBoxStyle, dim3, 0.0);
        this.labelPadding = SwatchLegendEntry.makePaddingForStyle(this.legendSpec.labelStyle, dim3, 0.0);
        this.computeLayout(dim, dim2);
    }

    SymbolSpec getSwatchSpecification() {
        assert (this.legendEntryRect != null);
        Dim dim = this.swatchRect.getExtent();
        Dim dim2 = this.labelRect.getExtent();
        this.computeLayout(dim, dim2);
        SymbolSpec symbolSpec = new SymbolSpec();
        symbolSpec.bounds = new BoundsSpec();
        symbolSpec.bounds.width = this.legendEntryRect.getWidth();
        symbolSpec.bounds.height = this.legendEntryRect.getHeight();
        int n = this.legendSpec.itemBoxStyle != null ? 4 : 3;
        symbolSpec.shape = new SymbolShapeSpec[n];
        int n2 = 0;
        symbolSpec.shape[n2++] = this.makeShapeSpec(SWATCHLEGENDENTRY_ENTRY, "rect", this.legendEntryRect, this.legendSpec.legendEntryStyle);
        if (this.legendSpec.itemBoxStyle != null) {
            StyleSpec styleSpec = new StyleSpec();
            styleSpec.fill = "#aaa";
            styleSpec.outline = null;
            styleSpec = StyleBuilder.mergeStyles(styleSpec, this.legendSpec.itemBoxStyle);
            symbolSpec.shape[n2++] = this.makeShapeSpec(SWATCHLEGENDENTRY_SWATCHBOX, "rect", this.swatchBoxRect, styleSpec);
        }
        symbolSpec.shape[n2++] = this.swatchSymbol;
        this.swatchSymbol.part = "legendentry_swatch9238749274";
        this.swatchSymbol.bounds = new BoundsSpec();
        this.swatchSymbol.bounds.left = this.swatchRect.getX();
        this.swatchSymbol.bounds.top = this.swatchRect.getY();
        this.swatchSymbol.bounds.width = this.swatchRect.getWidth();
        this.swatchSymbol.bounds.height = this.swatchRect.getHeight();
        if (this.swatchSymbol.style != null) {
            this.swatchSymbol.style.width = null;
            this.swatchSymbol.style.height = null;
        }
        symbolSpec.shape[n2++] = this.makeShapeSpec(SWATCHLEGENDENTRY_LABEL, "rect", this.labelRect, null);
        return symbolSpec;
    }

    void modifyStyleForSizeClipping(StyleSpec styleSpec) {
        SymbolSpec symbolSpec = (SymbolSpec)styleSpec.symbol;
        SymbolShapeSpec[] symbolShapeSpecArray = new SymbolShapeSpec[symbolSpec.shape.length + 1];
        for (int i = 0; i < symbolSpec.shape.length; ++i) {
            symbolShapeSpecArray[i] = symbolSpec.shape[i];
        }
        SymbolShapeSpec symbolShapeSpec = new SymbolShapeSpec();
        symbolShapeSpec.part = SWATCHLEGENDENTRY_TOO_LARGE_SYMBOL;
        symbolShapeSpec.type = "group";
        symbolShapeSpec.bounds = new BoundsSpec();
        symbolShapeSpec.bounds.left = this.oversizeRect.getX();
        symbolShapeSpec.bounds.top = this.oversizeRect.getY();
        symbolShapeSpec.bounds.width = this.oversizeRect.getWidth();
        symbolShapeSpec.bounds.height = this.oversizeRect.getHeight();
        SymbolShapeSpec symbolShapeSpec2 = new SymbolShapeSpec();
        symbolShapeSpec2.type = "circle";
        symbolShapeSpec2.style = new StyleSpec();
        symbolShapeSpec2.style.fill = "transparent";
        symbolShapeSpec2.style.outline = "black";
        SymbolShapeSpec symbolShapeSpec3 = new SymbolShapeSpec();
        symbolShapeSpec3.type = "path";
        symbolShapeSpec3.path = "M0.2,0.4L0.2,0.2L0.4,0.2M0.2,0.20L0.8,0.8M0.6,0.8L0.80,0.80L0.8,0.6M0.8,0.4L0.8,0.2L0.6,0.2M0.8,0.20L0.2,0.8M0.4,0.8L0.2,0.8L0.2,0.6";
        symbolShapeSpec3.style = new StyleSpec();
        symbolShapeSpec3.style.fill = "black";
        symbolShapeSpec.shape = new SymbolShapeSpec[]{symbolShapeSpec2, symbolShapeSpec3};
        symbolShapeSpecArray[symbolSpec.shape.length] = symbolShapeSpec;
        symbolSpec.shape = symbolShapeSpecArray;
    }

    Dim getSize() {
        assert (this.legendEntryRect != null);
        return new Dim(this.legendEntryRect.getWidth() + this.legendEntryPadding.getHorizontal(), this.legendEntryRect.getHeight() + this.legendEntryPadding.getVertical());
    }

    private void computeLayout(Dim dim, Dim dim2) {
        double d;
        double d2;
        double d3;
        Dim dim3 = this.sizer == null ? new Dim(dim.getWidth(), dim.getHeight()) : SwatchSizer.unionDim(this.sizer.getMaxSymbolSwatch(), dim);
        double d4 = 0.0;
        double d5 = d4 + this.swatchBoxPadding.left;
        double d6 = d5 + this.swatchPadding.left;
        double d7 = d6 + dim3.getWidth();
        double d8 = d7 + this.swatchPadding.right;
        double d9 = d8 + this.swatchBoxPadding.right + 5.0 + this.labelPadding.left;
        double d10 = d9 + dim2.getWidth();
        double d11 = Math.ceil(d10 + this.labelPadding.right);
        double d12 = this.swatchBoxPadding.getVertical() + this.swatchPadding.getVertical() + dim3.getHeight();
        double d13 = this.labelPadding.getVertical() + dim2.getHeight();
        double d14 = Math.max(d12, d13);
        double d15 = 0.0;
        double d16 = d15 + this.swatchBoxPadding.top;
        double d17 = d15 + this.labelPadding.top;
        double d18 = d17 + dim2.getHeight();
        String string = this.getValign();
        if (string.equals("middle")) {
            if (d12 < d13) {
                d16 = d15 + this.swatchBoxPadding.top + (d14 - d12) / 2.0;
            }
        } else if (string.equals("end")) {
            if (d12 < d13) {
                d16 = d15 + d14 - d12;
            }
        } else if (string.equals("middleOfFirstLine")) {
            Font font;
            d3 = this.swatchBoxPadding.top + this.swatchPadding.top + dim3.getHeight() / 2.0;
            FontSpec fontSpec = null;
            if (this.legendSpec.labelStyle != null) {
                fontSpec = this.legendSpec.labelStyle.font;
            }
            if ((d2 = d3 - (d = this.labelPadding.top + (font = FontHelper.makeFromSpec(fontSpec, this.visContext.getMinimumFontSize(), this.visContext.usesFractionalMetrics())).getHeight() / 2.0)) < 0.0) {
                d14 = Math.max(d12 + Math.abs(d2), d13);
                d16 = d - dim3.getHeight() / 2.0 - this.swatchPadding.top;
            } else {
                d14 = Math.max(d12, d13 + d2);
                d17 = d3 - font.getHeight() / 2.0;
                d18 = d17 + dim2.getHeight();
            }
        }
        d3 = d16 + this.swatchPadding.top;
        double d19 = d3 + dim3.getHeight();
        d = d19 + this.swatchPadding.bottom;
        d2 = Math.max(d + this.swatchBoxPadding.bottom, d18 + this.labelPadding.bottom);
        double d20 = Math.ceil(d15 + d2);
        this.legendEntryRect = new Rect(d4, d15, d11 - d4, d20 - d15);
        this.swatchBoxRect = new Rect(d5, d16, d8 - d5, d - d16);
        double d21 = d7 - d6 - dim.getWidth();
        double d22 = d19 - d3 - dim.getHeight();
        this.swatchRect = new Rect(d6 + d21 / 2.0, d3 + d22 / 2.0, dim.getWidth(), dim.getHeight());
        this.labelRect = new Rect(d9, d17, d10 - d9, d18 - d17);
        double d23 = this.swatchRect.getWidth();
        double d24 = this.swatchRect.getHeight();
        double d25 = Math.min(d23, d24);
        this.oversizeRect = new Rect(this.swatchRect.getMinX() + (d23 - d25) / 2.0, this.swatchRect.getMinY() + (d24 - d25) / 2.0, d25, d25);
    }

    private String getValign() {
        if (this.legendSpec.labelStyle == null || this.legendSpec.labelStyle.valign == null) {
            return "middleOfFirstLine";
        }
        return this.legendSpec.labelStyle.valign;
    }

    private SymbolShapeSpec makeShapeSpec(String string, String string2, Rect rect, StyleSpec styleSpec) {
        SymbolShapeSpec symbolShapeSpec = new SymbolShapeSpec();
        symbolShapeSpec.type = string2;
        symbolShapeSpec.part = string;
        symbolShapeSpec.bounds = new BoundsSpec();
        symbolShapeSpec.bounds.left = rect.getX();
        symbolShapeSpec.bounds.top = rect.getY();
        symbolShapeSpec.bounds.width = rect.getWidth();
        symbolShapeSpec.bounds.height = rect.getHeight();
        symbolShapeSpec.style = this.makeShapeStyle(styleSpec);
        return symbolShapeSpec;
    }

    private StyleSpec makeShapeStyle(StyleSpec styleSpec) {
        StyleSpec styleSpec2 = styleSpec == null ? new StyleSpec() : (StyleSpec)styleSpec.copy();
        styleSpec2.symbol = null;
        styleSpec2.size = null;
        styleSpec2.width = null;
        styleSpec2.height = null;
        styleSpec2.padding = null;
        if (styleSpec2.fill == null) {
            styleSpec2.fill = "transparent";
        }
        if (styleSpec2.outline == null) {
            styleSpec2.outline = "transparent";
        }
        return styleSpec2;
    }

    private static Insets makePaddingForStyle(StyleSpec styleSpec, Dim dim, double d) {
        if (styleSpec == null || styleSpec.padding == null) {
            double d2 = Math.max(0.0, d);
            return new Insets(d2, d2, d2, d2);
        }
        Insets insets = Insets.makeForStylePadding(styleSpec.padding, dim, dim);
        return new Insets(Math.max(0.0, insets.top), Math.max(0.0, insets.left), Math.max(0.0, insets.bottom), Math.max(0.0, insets.right));
    }

    StyleSpec makeStyleSpec() {
        this.swatchLabel.setAvailableWidth(this.swatchLabel.getLabelSize().getWidth());
        Dim dim = this.getSize();
        StyleSpec styleSpec = new StyleSpec();
        styleSpec.height = dim.getHeight();
        styleSpec.width = dim.getWidth();
        styleSpec.padding = this.legendSpec.legendEntryStyle != null && this.legendSpec.legendEntryStyle.padding != null ? this.legendSpec.legendEntryStyle.padding : Double.valueOf(2.5);
        styleSpec.symbol = this.getSwatchSpecification();
        return styleSpec;
    }

    Dim measureLabelSize() {
        return this.swatchLabel.measureLabelSize(false);
    }

    Dim getLabelSize() {
        return this.swatchLabel.getLabelSize();
    }

    boolean canReduceHorizontal() {
        Dim dim = this.swatchLabel.getMinimumSize();
        return !(this.labelRect.getWidth() <= dim.getWidth()) || !(this.swatchRect.getWidth() <= 20.0);
    }

    boolean canReduceVertical() {
        return this.swatchLabel.getMaxLines() > 1 || this.swatchRect.getHeight() > 20.0 && this.sizer != null;
    }

    boolean reduceSize(Dim dim, boolean bl) {
        boolean bl2;
        double d;
        double d2;
        Dim dim2 = this.getSize();
        boolean bl3 = false;
        boolean bl4 = false;
        Dim dim3 = null;
        if (this.sizer != null) {
            dim3 = this.sizer.getMaxSymbolSwatch();
        }
        double d3 = d2 = this.labelRect.getWidth();
        double d4 = this.swatchRect.getWidth();
        if (dim.getWidth() < dim2.getWidth()) {
            Dim dim4 = this.swatchLabel.getMinimumSize();
            d = Math.max(dim4.getWidth(), d2 + (dim.getWidth() - dim2.getWidth()));
            if (d < d2) {
                d3 = d;
            }
            if (!bl && this.sizer != null && dim.getWidth() < dim2.getWidth() - d2 + d3) {
                Double d5;
                double d6 = dim2.getWidth() - d2 - d4;
                double d7 = dim.getWidth() - d6 - d3;
                double d8 = 20.0;
                if (this.legendSpec != null && this.legendSpec.itemStyle != null && this.legendSpec.itemStyle.width != null && (d5 = UnitConverter.convertLength(this.legendSpec.itemStyle.width, 20.0, 20.0)) != null) {
                    d8 = d5;
                }
                if ((d7 = Math.max(d7, d8)) < d4) {
                    this.sizer.setMaxWidth(d7);
                    bl3 = true;
                }
            }
        }
        int n = this.swatchLabel.getMaxLines();
        if (dim2.getHeight() > dim.getHeight() && n > 1) {
            this.swatchLabel.setMaxLines(n - 1);
            bl4 = true;
        } else if (dim2.getHeight() > dim.getHeight() && dim3 != null && dim3.getHeight() > 20.0 && !bl) {
            d = Math.max(20.0, dim3.getHeight() + (dim.getHeight() - dim2.getHeight()));
            this.sizer.setMaxHeight(d);
            bl3 = true;
        }
        if (d3 != d2) {
            boolean bl5 = this.swatchLabel.setAvailableWidth(d3);
            bl4 = bl4 || bl5;
        }
        boolean bl6 = bl2 = bl3 || bl4;
        if (bl2) {
            this.layout();
        }
        return bl2;
    }

    void reset() {
        if (this.sizer != null) {
            this.sizer.reset();
        }
        this.swatchLabel.resetLabelSize();
        this.legendEntryRect = null;
    }
}

