/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.legend.nonsimple;

import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.grammar.aesthetic.Aesthetic;
import com.ibm.vis.engine.internal.grammar.coordinate.Position;
import com.ibm.vis.engine.internal.grammar.element.Builder;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.element.PointBuilder;
import com.ibm.vis.engine.internal.grammar.label.LabelProducer;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.FontHelper;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.scene.SymbolBuilder;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.ShapeLine;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.LegendSpec;
import com.ibm.vis.spec.internal.MappingSpec;
import com.ibm.vis.spec.internal.ModifiesSpec;
import com.ibm.vis.spec.internal.ScaleSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2015\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class SwatchSizer {
    static final double SYMBOL_LENGTH = 50.0;
    static final double DEFAULT_SYMBOL_WIDTH = 20.0;
    static final double DEFAULT_EXTENT = 400.0;
    private double extent = 400.0;
    private Dim symbolSize = new Dim(20.0, 20.0);
    private final List<Aesthetic> aesthetics;
    private final VisContext visContext;
    private final ScaleSpec legendScale;
    private final boolean isStrokeChanging;
    private final boolean isSizeChanging;
    private Dim maxSymbolSwatch;
    private Dim maxStrokeSwatch;
    private double widthLimit = Double.POSITIVE_INFINITY;
    private double heightLimit = Double.POSITIVE_INFINITY;
    private HashMap<Aesthetic, MappingSpec[][]> mappingsMap;
    private final List<Aesthetic> sizeTypeAesthetics;
    private final StyleSpec itemStyle;

    SwatchSizer(List<Aesthetic> list, VisContext visContext, LegendSpec legendSpec) {
        this.aesthetics = list;
        this.visContext = visContext;
        this.legendScale = legendSpec == null ? null : legendSpec.scale;
        this.itemStyle = legendSpec == null ? null : legendSpec.itemStyle;
        this.isStrokeChanging = this.setStrokeChanging();
        this.isSizeChanging = this.isStrokeChanging || this.calculateSizeChanging();
        this.mappingsMap = new HashMap();
        this.setSymbolSizeAndExtent(list.get((int)0).element);
        this.sizeTypeAesthetics = this.selectSizeTypeAesthetics();
        this.calculateMaxSwatchSizes();
    }

    private List<Aesthetic> selectSizeTypeAesthetics() {
        ArrayList<Aesthetic> arrayList = new ArrayList<Aesthetic>();
        if (this.aesthetics != null) {
            for (Aesthetic aesthetic : this.aesthetics) {
                if (!"size".equals(aesthetic.type)) continue;
                arrayList.add(aesthetic);
            }
        }
        return arrayList;
    }

    final boolean isStrokeChanging() {
        return this.isStrokeChanging;
    }

    final boolean isSizeChanging() {
        return this.isSizeChanging;
    }

    Dim getSwatchSize(Dim dim) {
        return this.isSizeChanging ? this.symbolSize : dim;
    }

    void recalculateSizes() {
        if (!this.isSizeChanging) {
            return;
        }
        Element element = this.aesthetics.get((int)0).element;
        this.mappingsMap = new HashMap();
        this.setSymbolSizeAndExtent(element);
        this.maxStrokeSwatch = null;
        this.maxSymbolSwatch = null;
        this.calculateMaxSwatchSizes();
    }

    private void setSymbolSizeAndExtent(Element element) {
        if (!this.isSizeChanging) {
            return;
        }
        if (this.itemStyle != null && this.itemStyle.size != null) {
            Double d = UnitConverter.convertLength(this.itemStyle.size, null, null);
            if (d != null) {
                this.symbolSize = new Dim(d, d);
            }
        } else {
            this.symbolSize = element.getLegendSymbolSize();
        }
        if (element.extent != null) {
            this.extent = Math.min(element.extent.getWidth(), element.extent.getHeight());
        }
    }

    void modifyStyleSize(StyleSpec styleSpec, LabelProducer labelProducer) {
        if (this.isSizeChanging && styleSpec != null) {
            if (labelProducer == null) {
                this.setSizeInfo(styleSpec, this.aesthetics.get((int)0).element.spec.style);
            } else {
                this.setSizeInfo(styleSpec, labelProducer.style);
                if (styleSpec.font == null) {
                    styleSpec.font = new FontSpec();
                    styleSpec.font.size = FontHelper.getDefaultFontSize(this.visContext.getMinimumFontSize());
                } else if (styleSpec.font.size == null) {
                    styleSpec.font.size = FontHelper.getDefaultFontSize(this.visContext.getMinimumFontSize());
                    styleSpec.font.setCachedObject(null);
                }
            }
        }
    }

    void modifySizeAesthetics(AestheticSpec[] aestheticSpecArray) {
        if (!this.isSizeChanging || aestheticSpecArray == null || this.sizeTypeAesthetics.size() < 1) {
            return;
        }
        int n = 0;
        for (int i = 0; i < aestheticSpecArray.length; ++i) {
            if (aestheticSpecArray[i].scale != null) {
                aestheticSpecArray[i].scale.reverse = false;
            }
            if (aestheticSpecArray[i].modifies == null || !(aestheticSpecArray[i].modifies instanceof ModifiesSpec)) continue;
            ModifiesSpec modifiesSpec = (ModifiesSpec)aestheticSpecArray[i].modifies;
            if ("legendentry_symbol9238749274".equals(modifiesSpec.part)) {
                n = this.modifyAestheticSpec(aestheticSpecArray[i], n, true);
                continue;
            }
            if (!"legendentry_line9238749274".equals(modifiesSpec.part)) continue;
            n = this.modifyAestheticSpec(aestheticSpecArray[i], n, false);
        }
    }

    private int modifyAestheticSpec(AestheticSpec aestheticSpec, int n, boolean bl) {
        if (this.aesthetics.size() <= n) {
            return n;
        }
        Aesthetic aesthetic = this.sizeTypeAesthetics.get(n);
        MappingSpec[][] mappingSpecArray = this.mappingsMap.get(aesthetic);
        if (mappingSpecArray != null) {
            aestheticSpec.palette = null;
            if (bl || mappingSpecArray.length < 2) {
                aestheticSpec.mapping = mappingSpecArray[0];
                ++n;
            } else {
                aestheticSpec.mapping = mappingSpecArray[1];
            }
        }
        return n;
    }

    protected void setSizeInfo(StyleSpec styleSpec, StyleSpec styleSpec2) {
        if (styleSpec2 != null) {
            if (styleSpec2.size != null) {
                styleSpec.size = styleSpec2.size;
                styleSpec.height = styleSpec2.size;
                styleSpec.width = styleSpec2.size;
            }
            if (styleSpec2.width != null) {
                styleSpec.width = styleSpec2.width;
            }
            if (styleSpec2.height != null) {
                styleSpec.height = styleSpec2.height;
            }
            if (styleSpec2.font != null) {
                styleSpec.font = (FontSpec)styleSpec2.font.copy();
            }
        }
    }

    private boolean setStrokeChanging() {
        for (Aesthetic aesthetic : this.aesthetics) {
            if (!this.changesStroke(aesthetic)) continue;
            return true;
        }
        return false;
    }

    private boolean calculateSizeChanging() {
        for (Aesthetic aesthetic : this.aesthetics) {
            if (!SwatchSizer.isSizeChangingAesthetic(aesthetic, this.visContext)) continue;
            return true;
        }
        return false;
    }

    final Dim getMaxSymbolSwatch() {
        return this.maxSymbolSwatch;
    }

    final Dim getMaxStrokeSwatch() {
        return this.maxStrokeSwatch;
    }

    private void calculateMaxSwatchSizes() {
        for (Aesthetic aesthetic : this.aesthetics) {
            if (!SwatchSizer.isSizeChangingAesthetic(aesthetic, this.visContext)) continue;
            this.updateMaxSize(aesthetic);
        }
        if (this.maxSymbolSwatch != null) {
            this.maxSymbolSwatch.setWidth(Math.min(this.maxSymbolSwatch.getWidth(), this.widthLimit));
            this.maxSymbolSwatch.setHeight(Math.min(this.maxSymbolSwatch.getHeight(), this.heightLimit));
        }
        if (this.maxStrokeSwatch != null) {
            this.maxStrokeSwatch.setWidth(Math.min(this.maxStrokeSwatch.getWidth(), this.widthLimit));
            this.maxStrokeSwatch.setHeight(Math.min(this.maxStrokeSwatch.getHeight(), this.heightLimit));
        }
    }

    static boolean isSizeChangingAesthetic(Aesthetic aesthetic, VisContext visContext) {
        if (aesthetic.valueProvider.getBaseField() == null) {
            return false;
        }
        if ("size".equals(aesthetic.type)) {
            return !aesthetic.element.type.equals("area") && !aesthetic.element.type.equals("polygon");
        }
        if ("font".equals(aesthetic.type)) {
            Object[] objectArray = aesthetic.scale.isCategorical() && aesthetic.spec.palette != null ? aesthetic.spec.palette : SwatchSizer.extractFontPaletteFromMapping(aesthetic.spec.mapping);
            return SwatchSizer.changesFontSize(objectArray, visContext);
        }
        if ("styleBy".equals(aesthetic.type)) {
            return SwatchSizer.sizeChangesInStyle(aesthetic.spec.palette, visContext, aesthetic.element.spec.style);
        }
        return false;
    }

    private void updateMaxSize(Aesthetic aesthetic) {
        if ("size".equals(aesthetic.type)) {
            if (SwatchSizer.isAestheticOnLineAndPoints(aesthetic)) {
                this.applyAestheticToLineAndPointSwatches(aesthetic);
                return;
            }
            Shape shape = this.getSwatchShape(aesthetic);
            boolean bl = this.changesStroke(aesthetic);
            MappingSpec[] mappingSpecArray = this.updateMaxSizeFromSizingAesthetic(aesthetic, shape, bl);
            MappingSpec[][] mappingSpecArrayArray = new MappingSpec[][]{mappingSpecArray};
            this.mappingsMap.put(aesthetic, mappingSpecArrayArray);
            return;
        }
        if ("font".equals(aesthetic.type)) {
            Shape shape = SwatchSizer.getLetterA(aesthetic.element.spec.style, this.visContext, aesthetic.element.getMaxShapeSize());
            this.updateMaxSizeFromSizingAesthetic(aesthetic, shape, false);
            return;
        }
        if ("styleBy".equals(aesthetic.type)) {
            Shape shape = this.getSwatchShape(aesthetic);
            boolean bl = this.changesStroke(aesthetic);
            this.updateMaxSizeFromSizingAesthetic(aesthetic, shape, bl);
            return;
        }
    }

    private void applyAestheticToLineAndPointSwatches(Aesthetic aesthetic) {
        Shape shape = this.getSwatchShape(aesthetic);
        MappingSpec[] mappingSpecArray = this.updateMaxSizeFromSizingAesthetic(aesthetic, shape, true);
        Dim dim = SwatchSizer.getSymbolSize(aesthetic.element.spec.symbolStyle, this.symbolSize.getWidth(), this.symbolSize.getHeight(), this.extent);
        Dim dim2 = new Dim(this.extent, this.extent);
        PointBuilder pointBuilder = new PointBuilder(this.visContext, null, dim2, dim, aesthetic.element.spec.symbolStyle);
        shape = SwatchSizer.getSwatchFromBuilder(pointBuilder);
        MappingSpec[] mappingSpecArray2 = this.updateMaxSizeFromSizingAesthetic(aesthetic, shape, false);
        MappingSpec[][] mappingSpecArrayArray = new MappingSpec[][]{mappingSpecArray2, mappingSpecArray};
        this.mappingsMap.put(aesthetic, mappingSpecArrayArray);
    }

    static Dim unionDim(Dim dim, Dim dim2) {
        if (dim == null) {
            return dim2;
        }
        if (dim2 == null) {
            return dim;
        }
        double d = Math.max(dim.getWidth(), dim2.getWidth());
        double d2 = Math.max(dim.getHeight(), dim2.getHeight());
        return new Dim(d, d2);
    }

    private static boolean isAestheticOnLineAndPoints(Aesthetic aesthetic) {
        return aesthetic.element.isLineWithPoints && aesthetic.spec.modifies == null;
    }

    private static Shape getSwatchFromBuilder(Builder builder) {
        return builder.make(Position.NO_COORDS, -1, false);
    }

    static Shape getLetterA(StyleSpec styleSpec, VisContext visContext, double d) {
        double d2;
        if (d > 0.0) {
            d2 = d;
            if (styleSpec.font != null) {
                styleSpec.font.size = d2;
                styleSpec.font.setCachedObject(null);
            }
        } else {
            d2 = 20.0;
        }
        Dim dim = SwatchSizer.getSymbolSize(styleSpec, d2, d2, 400.0);
        return SymbolBuilder.makeSymbol("letter-A", 0.0, 0.0, dim.getWidth(), dim.getHeight(), styleSpec, visContext);
    }

    private static Dim getSymbolSize(StyleSpec styleSpec, double d, double d2, double d3) {
        if (styleSpec == null) {
            return new Dim(d, d2);
        }
        double d4 = styleSpec.width != null ? UnitConverter.convertLength(styleSpec.width, d, d3) : (styleSpec.size != null ? UnitConverter.convertLength(styleSpec.size, d, d3) : d);
        double d5 = styleSpec.height != null ? UnitConverter.convertLength(styleSpec.height, d2, d3) : (styleSpec.size != null ? UnitConverter.convertLength(styleSpec.size, d2, d3) : d2);
        return new Dim(d4, d5);
    }

    private Shape getSwatchShape(Aesthetic aesthetic) {
        Aesthetic[] aestheticArray;
        if (aesthetic.labelProducer != null && (aestheticArray = aesthetic.labelProducer.getAesthetics()) != null) {
            for (Aesthetic aesthetic2 : aestheticArray) {
                if (aesthetic2 != aesthetic) continue;
                return SwatchSizer.getLetterA(aesthetic.labelProducer.style, this.visContext, aesthetic.element.getMaxShapeSize());
            }
        }
        aestheticArray = aesthetic.element;
        Aesthetic[] aestheticArray2 = aestheticArray.spec.style;
        if (aestheticArray.spec.type.equals("point")) {
            return this.getPointShape((StyleSpec)aestheticArray2);
        }
        if (aestheticArray.spec.type.equals("interval")) {
            Dim dim = SwatchSizer.getSymbolSize((StyleSpec)aestheticArray2, this.symbolSize.getWidth(), this.symbolSize.getHeight(), this.extent);
            return ShapeFactory2.CreateRect(0.0, 0.0, dim.getWidth(), dim.getHeight());
        }
        if (this.changesStroke(aesthetic)) {
            ShapeLine shapeLine = ShapeLine.make(0.0, 10.0, 50.0, 10.0);
            Double d = this.getStrokeWidthForLine((StyleSpec)aestheticArray2);
            StyleBuilder.scaleStrokeSize(shapeLine, d);
            return shapeLine;
        }
        if (aestheticArray.type.equals("text")) {
            return SwatchSizer.getLetterA((StyleSpec)aestheticArray2, this.visContext, aestheticArray.getMaxShapeSize());
        }
        if (aestheticArray.isLineWithPoints) {
            Shape shape = this.getPointShape(aestheticArray.spec.symbolStyle);
            shape.setMeta("part", "symbol");
            return shape;
        }
        Dim dim = SwatchSizer.getSymbolSize((StyleSpec)aestheticArray2, this.symbolSize.getWidth(), this.symbolSize.getHeight(), this.extent);
        return ShapeFactory2.CreateRect(0.0, 0.0, dim.getWidth(), dim.getHeight());
    }

    private Shape getPointShape(StyleSpec styleSpec) {
        Dim dim = new Dim(this.extent, this.extent);
        PointBuilder pointBuilder = new PointBuilder(this.visContext, null, dim, this.symbolSize, styleSpec);
        return SwatchSizer.getSwatchFromBuilder(pointBuilder);
    }

    private double getStrokeWidthForLine(StyleSpec styleSpec) {
        if (styleSpec == null) {
            return 1.0;
        }
        if (styleSpec.stroke != null && styleSpec.stroke.width != null) {
            return UnitConverter.convertLength(styleSpec.stroke.width, 1.0, this.extent);
        }
        if (styleSpec.size != null) {
            return UnitConverter.convertLength(styleSpec.size, 1.0, this.extent);
        }
        return 1.0;
    }

    private boolean changesStroke(Aesthetic aesthetic) {
        Element element = aesthetic.element;
        if (element.type.equals("edge") || element.type.equals("path")) {
            return SwatchSizer.isSizeChangingAesthetic(aesthetic, this.visContext);
        }
        if (element.type.equals("line") && (element.spec.symbolStyle == null || aesthetic.spec.modifies == null)) {
            return SwatchSizer.isSizeChangingAesthetic(aesthetic, this.visContext);
        }
        return false;
    }

    private MappingSpec[] updateMaxSizeNonCategoricalScale(Aesthetic aesthetic, int n, Shape shape, boolean bl) {
        double d = 0.0;
        double d2 = 0.0;
        boolean bl2 = 1009 == shape.getType();
        double[] dArray = new double[1];
        ArrayList<MappingSpec> arrayList = new ArrayList<MappingSpec>();
        ScaleSpan scaleSpan = aesthetic.scale.getSpans().get(0);
        Range range = scaleSpan.getAdjustedInputRange();
        double d3 = 0.0;
        if (range != null) {
            d3 = range.getMin();
        }
        Dim dim = bl ? SwatchSizer.getPostAestheticStokeWidth(aesthetic, n, d3, shape) : SwatchSizer.getPostAestheticBounds(aesthetic, n, d3, shape, dArray, bl2);
        d = dim.getWidth();
        d2 = dim.getHeight();
        MappingSpec mappingSpec = this.makeMappingSpec(bl, dim, "0%", bl2, dArray[0]);
        double d4 = 0.0;
        if (range != null) {
            d4 = range.getMax();
        }
        Dim dim2 = bl ? SwatchSizer.getPostAestheticStokeWidth(aesthetic, n, d4, shape) : SwatchSizer.getPostAestheticBounds(aesthetic, n, d4, shape, dArray, bl2);
        d = Math.max(d, dim2.getWidth());
        d2 = Math.max(d2, dim2.getHeight());
        boolean bl3 = true;
        boolean bl4 = true;
        MappingSpec[] mappingSpecArray = aesthetic.spec.mapping;
        if (mappingSpecArray != null) {
            for (MappingSpec mappingSpec2 : mappingSpecArray) {
                if (BasicFactory.isString(mappingSpec2.at)) {
                    double d5;
                    Double d6 = UnitConverter.convertLength(mappingSpec2.at, 1.0, 1.0);
                    if (d6 == null || !(0.0 <= (d5 = d6.doubleValue())) || !(d5 <= 1.0)) continue;
                    if (bl3 && d5 > 0.0) {
                        arrayList.add(mappingSpec);
                    }
                    if (d5 == 1.0) {
                        bl4 = false;
                    }
                    bl3 = false;
                    Double d7 = scaleSpan.zeroOneToDataValue(d5);
                    if (d7 == null) continue;
                    dim = bl ? SwatchSizer.getPostAestheticStokeWidth(aesthetic, n, d7, shape) : SwatchSizer.getPostAestheticBounds(aesthetic, n, d7, shape, dArray, bl2);
                    d = Math.max(d, dim.getWidth());
                    d2 = Math.max(d2, dim.getHeight());
                    arrayList.add(this.makeMappingSpec(bl, dim, mappingSpec2.at, bl2, dArray[0]));
                    continue;
                }
                if (!BasicFactory.isNumber(mappingSpec2.at)) continue;
                double d8 = ((Number)mappingSpec2.at).doubleValue();
                if (bl3 && d8 > d3) {
                    arrayList.add(mappingSpec);
                }
                if (d8 >= d4) {
                    bl4 = false;
                }
                bl3 = false;
                dim = bl ? SwatchSizer.getPostAestheticStokeWidth(aesthetic, n, d8, shape) : SwatchSizer.getPostAestheticBounds(aesthetic, n, d8, shape, dArray, bl2);
                d = Math.max(d, dim.getWidth());
                d2 = Math.max(d2, dim.getHeight());
                arrayList.add(this.makeMappingSpec(bl, dim, mappingSpec2.at, bl2, dArray[0]));
            }
            if (bl4) {
                arrayList.add(this.makeMappingSpec(bl, dim2, "100%", bl2, dArray[0]));
            }
        } else {
            arrayList.add(mappingSpec);
            arrayList.add(this.makeMappingSpec(bl, dim2, "100%", bl2, dArray[0]));
        }
        this.updateMaxDim(bl, d, d2);
        return arrayList.toArray(new MappingSpec[arrayList.size()]);
    }

    private MappingSpec makeMappingSpec(boolean bl, Dim dim, Object object, boolean bl2, double d) {
        MappingSpec mappingSpec = new MappingSpec();
        mappingSpec.at = object;
        mappingSpec.size = bl2 ? (Number)d : (Number)(bl ? (Number)MathUtil.r3(dim.getHeight()) : (Number)(this.aesthetics.get((int)0).element.grammar.coordinates.containsTranspose() ? (Number)MathUtil.r3(dim.getHeight()) : (Number)MathUtil.r3(dim.getWidth())));
        return mappingSpec;
    }

    private static Number[] getCategoriesFromScaleSpec(ScaleSpec scaleSpec) {
        return scaleSpec == null || scaleSpec.spans == null || scaleSpec.spans.length < 1 || scaleSpec.spans[0].categories == null ? null : scaleSpec.spans[0].categories;
    }

    private MappingSpec[] updateMaxSizeForCategoricalScale(Aesthetic aesthetic, boolean bl, Field field, int n, Shape shape, boolean bl2) {
        double d = 0.0;
        double d2 = 0.0;
        boolean bl3 = 1009 == shape.getType();
        double[] dArray = new double[1];
        Number[] numberArray = SwatchSizer.getCategoriesFromScaleSpec(this.legendScale);
        MappingSpec[] mappingSpecArray = null;
        if (numberArray != null) {
            mappingSpecArray = new MappingSpec[numberArray.length];
            for (int i = 0; i < numberArray.length; ++i) {
                double d3 = numberArray[i].doubleValue();
                Dim dim = bl2 ? SwatchSizer.getPostAestheticStokeWidth(aesthetic, n, d3, shape) : SwatchSizer.getPostAestheticBounds(aesthetic, n, d3, shape, dArray, bl3);
                d = Math.max(d, dim.getWidth());
                d2 = Math.max(d2, dim.getHeight());
                mappingSpecArray[i] = this.makeMappingSpec(bl2, dim, numberArray[i], bl3, dArray[0]);
            }
            this.updateMaxDim(bl2, d, d2);
            return mappingSpecArray;
        }
        if (bl) {
            int[] nArray = field.getUsedCategories();
            mappingSpecArray = new MappingSpec[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                Dim dim = bl2 ? SwatchSizer.getPostAestheticStokeWidth(aesthetic, n, nArray[i], shape) : SwatchSizer.getPostAestheticBounds(aesthetic, n, nArray[i], shape, dArray, bl3);
                d = Math.max(d, dim.getWidth());
                d2 = Math.max(d2, dim.getHeight());
                mappingSpecArray[i] = this.makeMappingSpec(bl2, dim, nArray[i], bl3, dArray[0]);
            }
        } else {
            Range range = aesthetic.scale.getSpans().get(0).getInputRange();
            double d4 = range.getMin();
            double d5 = range.getMax();
            int n2 = (int)Math.floor(d5);
            mappingSpecArray = new MappingSpec[n2];
            Dim dim = bl2 ? SwatchSizer.getPostAestheticStokeWidth(aesthetic, n, d4, shape) : SwatchSizer.getPostAestheticBounds(aesthetic, n, d4, shape, dArray, bl3);
            d = dim.getWidth();
            d2 = dim.getHeight();
            mappingSpecArray[0] = this.makeMappingSpec(bl2, dim, d4, bl3, dArray[0]);
            d4 += 1.0;
            int n3 = 1;
            while (d4 < d5) {
                dim = bl2 ? SwatchSizer.getPostAestheticStokeWidth(aesthetic, n, d4, shape) : SwatchSizer.getPostAestheticBounds(aesthetic, n, d4, shape, dArray, bl3);
                d = Math.max(d, dim.getWidth());
                d2 = Math.max(d2, dim.getHeight());
                mappingSpecArray[n3] = this.makeMappingSpec(bl2, dim, d4, bl3, dArray[0]);
                d4 += 1.0;
                ++n3;
            }
        }
        this.updateMaxDim(bl2, d, d2);
        return mappingSpecArray;
    }

    protected void updateMaxDim(boolean bl, double d, double d2) {
        Dim dim = new Dim(d, d2);
        if (bl) {
            this.maxStrokeSwatch = SwatchSizer.unionDim(this.maxStrokeSwatch, dim);
        } else {
            this.maxSymbolSwatch = SwatchSizer.unionDim(this.maxSymbolSwatch, dim);
        }
    }

    static Dim getPostAestheticBounds(Aesthetic aesthetic, int n, double d, Shape shape, double[] dArray, boolean bl) {
        Shape shape2 = SwatchSizer.applyAesthetic(aesthetic, n, d, shape);
        if (bl && dArray != null) {
            dArray[0] = ((Text)shape2).getFont().getSize();
        }
        if (1010 == shape2.getType()) {
            double d2 = shape2.getWidth();
            double d3 = shape2.getHeight();
            return new Dim(d2, d3);
        }
        Rect rect = shape2.getBounds();
        return new Dim(rect.getWidth(), rect.getHeight());
    }

    private static Shape applyAesthetic(Aesthetic aesthetic, int n, double d, Shape shape) {
        Shape shape2 = shape.makeGeometryClone();
        shape2.copyInfoFrom(shape);
        Row row = SwatchSizer.makeRow(n, d);
        return aesthetic.apply(shape2, row);
    }

    static Row makeRow(int n, double d) {
        Row row = Row.createEmptyRow(n + 1, 0);
        row.data[n] = d;
        return row;
    }

    static Dim getPostAestheticStokeWidth(Aesthetic aesthetic, int n, double d, Shape shape) {
        Shape shape2 = SwatchSizer.applyAesthetic(aesthetic, n, d, shape);
        Stroke stroke = shape2.getStroke();
        if (stroke == null) {
            return new Dim(50.0, 1.0);
        }
        return new Dim(50.0, stroke.getWidth());
    }

    static boolean changesFontSize(Object[] objectArray, VisContext visContext) {
        if (objectArray == null || objectArray.length < 2) {
            return false;
        }
        double d = FontHelper.getDefaultFontSize(visContext.getMinimumFontSize());
        double d2 = SwatchSizer.getFontSizeFromPaletteItem(objectArray[0], d);
        for (int i = 1; i < objectArray.length; ++i) {
            double d3 = d2 - SwatchSizer.getFontSizeFromPaletteItem(objectArray[i], d);
            if (!(d3 < -0.5) && !(d3 > 0.5)) continue;
            return true;
        }
        return false;
    }

    private static double getFontSizeFromPaletteItem(Object object, double d) {
        double d2;
        if (object == null || object instanceof FontSpec) {
            d2 = SwatchSizer.getFontSize((FontSpec)object, d);
        } else {
            Object object2 = ((StyleSpec)object).size;
            d2 = UnitConverter.convertLength(object2, d, d);
        }
        return d2;
    }

    private static double getFontSize(FontSpec fontSpec, double d) {
        if (fontSpec == null || fontSpec.size == null) {
            return d;
        }
        return UnitConverter.convertLength(fontSpec.size, d, 400.0);
    }

    static Object[] extractFontPaletteFromMapping(MappingSpec[] mappingSpecArray) {
        if (mappingSpecArray == null || mappingSpecArray.length < 1) {
            return null;
        }
        Object[] objectArray = new Object[mappingSpecArray.length];
        for (int i = 0; i < mappingSpecArray.length; ++i) {
            objectArray[i] = mappingSpecArray[i].font;
        }
        return objectArray;
    }

    static boolean sizeChangesInStyle(Object[] objectArray, VisContext visContext, StyleSpec styleSpec) {
        if (objectArray == null || objectArray.length < 2) {
            return false;
        }
        double d = -20.0;
        if (styleSpec != null) {
            if (styleSpec.width != null) {
                d = UnitConverter.convertLength(styleSpec.width, 20.0, 400.0);
            } else if (styleSpec.height != null) {
                d = UnitConverter.convertLength(styleSpec.height, 20.0, 400.0);
            } else if (styleSpec.size != null) {
                d = UnitConverter.convertLength(styleSpec.size, 20.0, 400.0);
            }
        }
        Object[] objectArray2 = new Object[objectArray.length];
        double d2 = SwatchSizer.getSize((StyleSpec)objectArray[0], d, 400.0);
        objectArray2[0] = objectArray[0] == null ? null : ((StyleSpec)objectArray[0]).font;
        for (int i = 1; i < objectArray.length; ++i) {
            double d3 = d2 - SwatchSizer.getSize((StyleSpec)objectArray[i], d, 400.0);
            if (d3 < -0.5 || d3 > 0.5) {
                return true;
            }
            objectArray2[i] = objectArray[i] == null ? null : ((StyleSpec)objectArray[i]).font;
        }
        return SwatchSizer.changesFontSize(objectArray2, visContext);
    }

    static double getSize(StyleSpec styleSpec, double d, double d2) {
        if (styleSpec == null || styleSpec.size == null && styleSpec.width == null && styleSpec.height == null) {
            return d;
        }
        Object object = null;
        object = styleSpec.width != null ? styleSpec.width : (styleSpec.height == null ? styleSpec.size : styleSpec.height);
        return UnitConverter.convertLength(object, d, d2);
    }

    private MappingSpec[] updateMaxSizeFromSizingAesthetic(Aesthetic aesthetic, Shape shape, boolean bl) {
        Field field = aesthetic.valueProvider.getBaseField();
        int n = field.getIndex();
        boolean bl2 = !aesthetic.scale.isLocalUndefined() && aesthetic.scale.localScale != false;
        MappingSpec[] mappingSpecArray = aesthetic.scale.isCategorical() ? this.updateMaxSizeForCategoricalScale(aesthetic, bl2, field, n, shape, bl) : this.updateMaxSizeNonCategoricalScale(aesthetic, n, shape, bl);
        return mappingSpecArray;
    }

    void setMaxHeight(double d) {
        this.heightLimit = d;
        if (this.maxSymbolSwatch != null) {
            this.maxSymbolSwatch.setHeight(Math.min(this.maxSymbolSwatch.getHeight(), this.heightLimit));
        }
        if (this.maxStrokeSwatch != null) {
            this.maxStrokeSwatch.setHeight(Math.min(this.maxStrokeSwatch.getHeight(), this.heightLimit));
        }
    }

    void setMaxWidth(double d) {
        this.widthLimit = d;
        if (this.maxSymbolSwatch != null) {
            this.maxSymbolSwatch.setWidth(Math.min(this.maxSymbolSwatch.getWidth(), this.widthLimit));
        }
        if (this.maxStrokeSwatch != null) {
            this.maxStrokeSwatch.setWidth(Math.min(this.maxStrokeSwatch.getWidth(), this.widthLimit));
        }
    }

    protected Double[][] getDataColumns(double[] dArray, ElementsSpec elementsSpec) {
        if (dArray == null || this.heightLimit == Double.POSITIVE_INFINITY && this.widthLimit == Double.POSITIVE_INFINITY) {
            return null;
        }
        Dim[] dimArray = this.getSwatchSizes(dArray);
        Double[] doubleArray = new Double[dArray.length];
        double d = -1.0;
        double d2 = -1.0;
        int n = -1;
        for (int i = 0; i < dArray.length; ++i) {
            if (dimArray[i].getHeight() > this.heightLimit || dimArray[i].getWidth() > this.widthLimit) {
                doubleArray[i] = 0.0;
                continue;
            }
            doubleArray[i] = 1.0;
            if (d2 < dimArray[i].getWidth()) {
                d2 = dimArray[i].getWidth();
                n = i;
            }
            if (!(d < dimArray[i].getHeight())) continue;
            d = dimArray[i].getHeight();
            n = i;
        }
        Double[] doubleArray2 = new Double[dArray.length];
        if (!this.maxSizeIsClose(d, d2)) {
            if (this.hasPalette(elementsSpec)) {
                n = this.addLargeSizeToAesethticWithPalette(dArray, elementsSpec, n);
                for (int i = 0; i < dArray.length; ++i) {
                    doubleArray2[i] = doubleArray[i] < 1.0 ? n : i % n;
                }
            } else {
                this.addLargeSizeToAesethticWithMapping(elementsSpec);
                for (int i = 0; i < dArray.length; ++i) {
                    doubleArray2[i] = doubleArray[i] < 1.0 ? null : Double.valueOf(dArray[i]);
                }
            }
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                doubleArray2[i] = doubleArray[i] < 1.0 ? dArray[n] : dArray[i];
            }
        }
        return new Double[][]{doubleArray2, doubleArray};
    }

    private boolean hasPalette(ElementsSpec elementsSpec) {
        AestheticSpec aestheticSpec = null;
        if (elementsSpec.size != null) {
            aestheticSpec = elementsSpec.size[elementsSpec.size.length - 1];
        } else if (elementsSpec.font != null) {
            aestheticSpec = elementsSpec.font[elementsSpec.font.length - 1];
        } else {
            return true;
        }
        return aestheticSpec.palette != null;
    }

    protected int addLargeSizeToAesethticWithPalette(double[] dArray, ElementsSpec elementsSpec, int n) {
        int n2 = dArray.length;
        double d = Math.min(this.heightLimit, this.widthLimit);
        if (elementsSpec.size != null) {
            double d2 = d * 0.85;
            AestheticSpec aestheticSpec = elementsSpec.size[elementsSpec.size.length - 1];
            n2 = this.updateAestheticWithLargeSymbolSizePalette(aestheticSpec, d2);
        } else if (elementsSpec.font != null) {
            AestheticSpec aestheticSpec = elementsSpec.font[elementsSpec.font.length - 1];
            FontSpec fontSpec = new FontSpec();
            fontSpec.size = (int)Math.floor(d);
            n2 = this.updateAestheticWithLargeSymbolSizePalette(aestheticSpec, fontSpec);
        } else {
            n2 = n < 0 ? 0 : n;
        }
        return n2;
    }

    protected void addLargeSizeToAesethticWithMapping(ElementsSpec elementsSpec) {
        double d = Math.min(this.heightLimit, this.widthLimit);
        if (elementsSpec.size != null) {
            double d2 = d * 0.85;
            AestheticSpec aestheticSpec = elementsSpec.size[elementsSpec.size.length - 1];
            aestheticSpec.nullValue = d2;
        } else if (elementsSpec.font != null) {
            AestheticSpec aestheticSpec = elementsSpec.font[elementsSpec.font.length - 1];
            FontSpec fontSpec = new FontSpec();
            fontSpec.size = (int)Math.floor(d);
            aestheticSpec.nullValue = fontSpec;
        }
    }

    protected int updateAestheticWithLargeSymbolSizePalette(AestheticSpec aestheticSpec, Object object) {
        int n = 0;
        if (aestheticSpec.palette != null) {
            n = aestheticSpec.palette.length;
            Object[] objectArray = new Object[n + 1];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = aestheticSpec.palette[i];
            }
            objectArray[n] = object;
            aestheticSpec.palette = objectArray;
        }
        return n;
    }

    private boolean maxSizeIsClose(double d, double d2) {
        return Double.POSITIVE_INFINITY != this.heightLimit && d > 0.8 * this.heightLimit || Double.POSITIVE_INFINITY != this.widthLimit && d2 > 0.8 * this.widthLimit;
    }

    private Dim[] getSwatchSizes(double[] dArray) {
        Dim[] dimArray = new Dim[dArray.length];
        for (Aesthetic aesthetic : this.aesthetics) {
            if (!SwatchSizer.isSizeChangingAesthetic(aesthetic, this.visContext)) continue;
            Dim[] dimArray2 = this.getSwatchSizesForAesthetic(aesthetic, dArray);
            for (int i = 0; i < dArray.length; ++i) {
                this.updateSizes(dimArray, i, dimArray2[i]);
            }
        }
        return dimArray;
    }

    private void updateSizes(Dim[] dimArray, int n, Dim dim) {
        if (dimArray[n] == null) {
            dimArray[n] = dim;
        } else if (dimArray[n].getHeight() < dim.getHeight()) {
            dimArray[n] = dim;
        }
    }

    private Dim[] getSwatchSizesForAesthetic(Aesthetic aesthetic, double[] dArray) {
        if (SwatchSizer.isAestheticOnLineAndPoints(aesthetic)) {
            return this.getSwatchSizeForLineWithPoints(aesthetic, dArray);
        }
        Dim[] dimArray = new Dim[dArray.length];
        Shape shape = this.getSwatchShape(aesthetic);
        Field field = aesthetic.valueProvider.getBaseField();
        int n = field.getIndex();
        boolean bl = this.changesStroke(aesthetic);
        boolean bl2 = 1009 == shape.getType();
        double[] dArray2 = new double[1];
        for (int i = 0; i < dArray.length; ++i) {
            dimArray[i] = bl ? SwatchSizer.getPostAestheticStokeWidth(aesthetic, n, dArray[i], shape) : SwatchSizer.getPostAestheticBounds(aesthetic, n, dArray[i], shape, dArray2, bl2);
        }
        return dimArray;
    }

    private Dim[] getSwatchSizeForLineWithPoints(Aesthetic aesthetic, double[] dArray) {
        Dim dim = SwatchSizer.getSymbolSize(aesthetic.element.spec.symbolStyle, this.symbolSize.getWidth(), this.symbolSize.getHeight(), this.extent);
        Dim dim2 = new Dim(this.extent, this.extent);
        PointBuilder pointBuilder = new PointBuilder(this.visContext, null, dim2, dim, aesthetic.element.spec.symbolStyle);
        Shape shape = SwatchSizer.getSwatchFromBuilder(pointBuilder);
        Shape shape2 = this.getSwatchShape(aesthetic);
        Dim[] dimArray = new Dim[dArray.length];
        Field field = aesthetic.valueProvider.getBaseField();
        int n = field.getIndex();
        double[] dArray2 = new double[1];
        for (int i = 0; i < dArray.length; ++i) {
            Dim dim3 = SwatchSizer.getPostAestheticStokeWidth(aesthetic, n, dArray[i], shape2);
            Dim dim4 = SwatchSizer.getPostAestheticBounds(aesthetic, n, dArray[i], shape, dArray2, false);
            this.updateSizes(dimArray, i, dim3);
            this.updateSizes(dimArray, i, dim4);
        }
        return dimArray;
    }

    void reset() {
        this.widthLimit = Double.POSITIVE_INFINITY;
        this.heightLimit = Double.POSITIVE_INFINITY;
    }

    boolean isOrientationSpecialCase() {
        for (Aesthetic aesthetic : this.aesthetics) {
            String string = aesthetic.element.type;
            if (!"schema:boxplot".equals(string) && !"interval".equals(string) || !SwatchSizer.isSizeChangingAesthetic(aesthetic, this.visContext)) continue;
            return true;
        }
        return false;
    }

    boolean isSpecialCaseHorizontal() {
        return this.aesthetics.get((int)0).element.grammar.coordinates.containsTranspose();
    }
}

