/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.migration;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.migration.EvaluationContext;
import com.ibm.vis.engine.internal.migration.Mapping;
import com.ibm.vis.engine.internal.migration.MigrationStrategy;
import com.ibm.vis.engine.internal.migration.MigrationStrategyComparator;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.Version;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class DeclarativeMigrationStrategy
implements MigrationStrategy {
    private final List<Mapping> mappings;
    private final Version version;

    DeclarativeMigrationStrategy(Version version, List<Mapping> list) {
        this.version = version;
        this.mappings = list;
    }

    @Override
    public final Version getTargetVersion() {
        return this.version;
    }

    @Override
    public boolean migrate(JSONArtifact jSONArtifact) {
        boolean bl = false;
        EvaluationContext evaluationContext = new EvaluationContext(jSONArtifact, null);
        evaluationContext.getProperties().put("StrategyReference.version", this.getTargetVersion());
        for (Mapping mapping : this.mappings) {
            if (!mapping.execute(evaluationContext)) continue;
            bl = true;
        }
        return bl;
    }

    public static List<DeclarativeMigrationStrategy> parse(JSONArray jSONArray) {
        int n = BasicFactory.size(jSONArray);
        ArrayList<DeclarativeMigrationStrategy> arrayList = new ArrayList<DeclarativeMigrationStrategy>(n);
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = (JSONObject)BasicFactory.getArrayItem(jSONArray, i);
            arrayList.add(new DeclarativeMigrationStrategy(Version.parseVersion((String)BasicFactory.getItem(jSONObject, "targetVersion")), Mapping.parse((JSONArray)BasicFactory.getItem(jSONObject, "mapping"))));
        }
        BasicFactory.sortList(arrayList, new MigrationStrategyComparator());
        return arrayList;
    }
}

