/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.migration;

import com.ibm.json.java.JSONArtifact;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class EvaluationContext {
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private final Map<Object, Object> properties = new HashMap<Object, Object>();
    private final JSONArtifact context;
    private final EvaluationContext parent;

    EvaluationContext(JSONArtifact jSONArtifact, EvaluationContext evaluationContext) {
        this.context = jSONArtifact;
        this.parent = evaluationContext;
    }

    public EvaluationContext getParent() {
        return this.parent;
    }

    void reset() {
        this.variables.clear();
        this.properties.clear();
    }

    public final JSONArtifact getContext() {
        return this.context;
    }

    final Map<String, Object> getVariables() {
        return this.variables;
    }

    final Map<Object, Object> getProperties() {
        return this.properties;
    }

    public final Object getVariable(String string) {
        Object object = null;
        if (this.variables.containsKey(string)) {
            object = this.variables.get(string);
        } else if (this.parent != null) {
            object = this.parent.getVariable(string);
        }
        return object;
    }

    public final Object getProperty(Object object) {
        Object object2 = null;
        if (this.properties.containsKey(object)) {
            object2 = this.properties.get(object);
        } else if (this.parent != null) {
            object2 = this.parent.getProperty(object);
        }
        return object2;
    }

    public Object getResolvedValue(Object object) {
        if (BasicFactory.isString(object)) {
            String string = (String)object;
            if (string.startsWith("$")) {
                return this.getVariable(string.substring(1));
            }
            if (string.startsWith("\\$")) {
                return string.substring(1);
            }
        }
        return object;
    }
}

