/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.migration;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.migration.EvaluationContext;
import com.ibm.vis.engine.internal.migration.EvaluationResult;
import com.ibm.vis.engine.internal.migration.PathExpression;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Guard {
    private static final String NOT = "not";
    private static final String OR = "or";
    private static final String T_STRING = "string";
    private static final String T_OBJECT = "object";
    private static final String T_ARRAY = "array";
    private static final String T_NUMBER = "number";
    private static final String T_BOOLEAN = "boolean";
    private final PathExpression expression;
    private final boolean hasValue;
    private final Object value;
    private final String type;
    private final String logic;
    private final List<Guard> guards;

    public Guard(String string, boolean bl, Object object, String string2, String string3, List<Guard> list) {
        this.expression = string != null ? new PathExpression(string) : null;
        this.hasValue = bl;
        this.value = object;
        this.type = string2;
        this.logic = string3;
        this.guards = list;
    }

    public boolean execute(EvaluationContext evaluationContext) {
        boolean bl = this.doExecute(new EvaluationContext(evaluationContext.getContext(), evaluationContext));
        return NOT.equals(this.logic) ? !bl : bl;
    }

    private boolean doExecute(EvaluationContext evaluationContext) {
        if (this.expression != null) {
            do {
                boolean bl;
                boolean bl2 = bl = this.executeExpression(evaluationContext) && this.executeChildGuards(evaluationContext);
                if (OR.equals(this.logic)) {
                    if (!bl) continue;
                    return true;
                }
                if (bl) continue;
                return false;
            } while (this.expression.next(evaluationContext));
            return !OR.equals(this.logic);
        }
        return this.executeChildGuards(evaluationContext);
    }

    private boolean executeChildGuards(EvaluationContext evaluationContext) {
        if (this.guards != null) {
            for (Guard guard : this.guards) {
                boolean bl = guard.execute(evaluationContext);
                if (OR.equals(this.logic)) {
                    if (!bl) continue;
                    return true;
                }
                if (bl) continue;
                return false;
            }
            return !OR.equals(this.logic);
        }
        return true;
    }

    private boolean executeExpression(EvaluationContext evaluationContext) {
        EvaluationResult evaluationResult = this.expression.evaluate(evaluationContext);
        if (this.type != null && evaluationResult != EvaluationResult.DOES_NOT_EXIST) {
            boolean bl = true;
            if (T_STRING.equals(this.type)) {
                bl = evaluationResult.isString();
            } else if (T_OBJECT.equals(this.type)) {
                bl = evaluationResult.isObject();
            } else if (T_ARRAY.equals(this.type)) {
                bl = evaluationResult.isArray();
            } else if (T_NUMBER.equals(this.type)) {
                bl = evaluationResult.isNumber();
            } else if (T_BOOLEAN.equals(this.type)) {
                bl = evaluationResult.isBoolean();
            }
            if (!bl) {
                return false;
            }
        }
        if (!this.hasValue) {
            return evaluationResult != EvaluationResult.DOES_NOT_EXIST;
        }
        if (evaluationResult == EvaluationResult.DOES_NOT_EXIST) {
            return false;
        }
        Object object = evaluationContext.getResolvedValue(this.value);
        if (BasicFactory.isString(object)) {
            return evaluationResult.isString() && ((String)object).equals(evaluationResult.getValue());
        }
        if (BasicFactory.isNumber(object)) {
            return evaluationResult.isNumber() && ((Number)object).doubleValue() == ((Number)evaluationResult.getValue()).doubleValue();
        }
        if (BasicFactory.isBoolean(object)) {
            return evaluationResult.isBoolean() && ((Boolean)object).booleanValue() == ((Boolean)evaluationResult.getValue()).booleanValue();
        }
        if (BasicFactory.isArray(object)) {
            return evaluationResult.isArray() && BasicFactory.isEqual((JSONArtifact)((JSONArray)object), (JSONArtifact)((JSONArray)evaluationResult.getValue()));
        }
        if (BasicFactory.isObject(object)) {
            return evaluationResult.isObject() && BasicFactory.isEqual((JSONArtifact)((JSONObject)object), (JSONArtifact)((JSONObject)evaluationResult.getValue()));
        }
        return object == evaluationResult.getValue();
    }

    static List<Guard> parse(JSONArray jSONArray) {
        int n = jSONArray == null ? 0 : BasicFactory.size(jSONArray);
        ArrayList<Guard> arrayList = new ArrayList<Guard>(n);
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = (JSONObject)BasicFactory.getArrayItem(jSONArray, i);
            arrayList.add(new Guard((String)BasicFactory.getItem(jSONObject, "expression"), BasicFactory.containsKey(jSONObject, "value"), BasicFactory.getItem(jSONObject, "value"), (String)BasicFactory.getItem(jSONObject, "type"), (String)BasicFactory.getItem(jSONObject, "logic"), Guard.parse((JSONArray)BasicFactory.getItem(jSONObject, "guard"))));
        }
        return arrayList;
    }
}

