/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.migration;

import com.ibm.json.java.JSONArtifact;
import com.ibm.vis.engine.internal.migration.MigrationStrategy;
import com.ibm.vis.engine.internal.migration.MigrationStrategyComparator;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.Version;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class JSONMigration
implements MigrationStrategy {
    protected static final String VERSION = "version";
    private final List<MigrationStrategy> strategies = new ArrayList<MigrationStrategy>();

    @Override
    public boolean migrate(JSONArtifact jSONArtifact) {
        return this.doMigrate(jSONArtifact, false) != null;
    }

    public JSONArtifact getMigrated(JSONArtifact jSONArtifact) {
        return this.doMigrate(jSONArtifact, true);
    }

    private JSONArtifact doMigrate(JSONArtifact jSONArtifact, boolean bl) {
        Version version = this.getTargetVersion();
        boolean bl2 = false;
        JSONArtifact jSONArtifact2 = null;
        if (!this.strategies.isEmpty() && BasicFactory.containsKey(jSONArtifact, VERSION)) {
            Version version2 = Version.parseVersion((String)BasicFactory.getItem(jSONArtifact, VERSION));
            Version version3 = null;
            for (int i = 0; i < this.strategies.size(); ++i) {
                MigrationStrategy migrationStrategy = this.strategies.get(i);
                if (migrationStrategy.getTargetVersion().compareTo(version) > 0 || version2.compareTo(migrationStrategy.getTargetVersion()) >= 0) continue;
                if (jSONArtifact2 == null) {
                    jSONArtifact2 = bl ? (JSONArtifact)BasicFactory.deepClone(jSONArtifact) : jSONArtifact;
                }
                if (version3 != null && version3.compareTo(migrationStrategy.getTargetVersion()) < 0) {
                    BasicFactory.put(jSONArtifact2, VERSION, version3.toString());
                    version3 = null;
                }
                if (!migrationStrategy.migrate(jSONArtifact2)) continue;
                version3 = migrationStrategy.getTargetVersion();
                bl2 = true;
            }
            if (version3 != null) {
                BasicFactory.put(jSONArtifact2, VERSION, version3.toString());
            }
        }
        return bl2 ? jSONArtifact2 : null;
    }

    public List<MigrationStrategy> getStrategies() {
        return this.strategies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addStrategy(MigrationStrategy migrationStrategy) {
        List<MigrationStrategy> list = this.strategies;
        synchronized (list) {
            this.strategies.add(migrationStrategy);
        }
    }

    @Override
    public Version getTargetVersion() {
        if (this.strategies.isEmpty()) {
            return null;
        }
        return this.strategies.get(this.strategies.size() - 1).getTargetVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sortStrategies() {
        List<MigrationStrategy> list = this.strategies;
        synchronized (list) {
            BasicFactory.sortList(this.strategies, new MigrationStrategyComparator());
        }
    }
}

