/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.migration;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.migration.Converter;
import com.ibm.vis.engine.internal.migration.ConverterReference;
import com.ibm.vis.engine.internal.migration.EvaluationContext;
import com.ibm.vis.engine.internal.migration.EvaluationResult;
import com.ibm.vis.engine.internal.migration.Guard;
import com.ibm.vis.engine.internal.migration.MigrationStrategy;
import com.ibm.vis.engine.internal.migration.PathExpression;
import com.ibm.vis.engine.internal.migration.StrategyReference;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Mapping {
    private static final String MOVE = "move";
    private static final String COPY = "copy";
    private static final String DELETE = "delete";
    private static final String CONCAT = "concat";
    private static final String INIT = "init";
    private static final String SET = "set";
    private final String method;
    private final Map<String, PathExpression> variables;
    private final PathExpression[] contextExpressions;
    private final PathExpression sourceExpression;
    private final PathExpression targetExpression;
    private final List<Guard> guards;
    private final List<Mapping> mappings;
    private final List<Mapping> elseMappings;
    private final boolean hasValue;
    private final Object value;
    private final StrategyReference strategyRef;
    private final ConverterReference converterRef;

    public Mapping(String[] stringArray, StrategyReference strategyReference, ConverterReference converterReference, String string, String string2, String string3, JSONObject jSONObject, List<Mapping> list, List<Mapping> list2, List<Guard> list3, boolean bl, Object object) {
        PathExpression pathExpression;
        this.strategyRef = strategyReference;
        this.converterRef = converterReference;
        this.sourceExpression = string != null ? new PathExpression(string) : null;
        this.mappings = list;
        this.elseMappings = list2;
        this.guards = list3;
        this.hasValue = bl;
        this.value = object;
        this.method = string3 != null ? string3 : SET;
        if (stringArray != null) {
            this.contextExpressions = new PathExpression[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.contextExpressions[i] = new PathExpression(stringArray[i]);
            }
        } else {
            this.contextExpressions = null;
        }
        PathExpression pathExpression2 = pathExpression = string2 != null ? new PathExpression(string2) : null;
        if (this.sourceExpression != null && pathExpression == null && !DELETE.equals(this.method)) {
            pathExpression = new PathExpression(string);
            pathExpression.convertVariableDeclarationToReference();
        }
        this.targetExpression = pathExpression;
        if (jSONObject != null) {
            this.variables = new HashMap<String, PathExpression>();
            for (String string4 : BasicFactory.keySet(jSONObject)) {
                this.variables.put(string4, new PathExpression((String)BasicFactory.getItem(jSONObject, string4)));
            }
        } else {
            this.variables = null;
        }
    }

    public boolean execute(EvaluationContext evaluationContext) {
        boolean bl = false;
        if (this.contextExpressions != null) {
            for (PathExpression pathExpression : this.contextExpressions) {
                do {
                    EvaluationResult evaluationResult;
                    if ((evaluationResult = pathExpression.evaluate(evaluationContext)) == EvaluationResult.DOES_NOT_EXIST || !BasicFactory.isObject(evaluationResult.getValue()) && !BasicFactory.isArray(evaluationResult.getValue()) || !this.doExecute(new EvaluationContext((JSONArtifact)evaluationResult.getValue(), evaluationContext))) continue;
                    bl = true;
                } while (pathExpression.next(evaluationContext));
            }
        } else {
            bl = this.doExecute(new EvaluationContext(evaluationContext.getContext(), evaluationContext));
        }
        return bl;
    }

    private boolean doExecute(EvaluationContext evaluationContext) {
        boolean bl = false;
        if (this.isGuardMet(evaluationContext)) {
            MigrationStrategy migrationStrategy;
            if (this.strategyRef != null && (migrationStrategy = this.strategyRef.get(evaluationContext)) != null) {
                bl = migrationStrategy.migrate(evaluationContext.getContext());
            }
            if (this.sourceExpression != null || this.targetExpression != null) {
                if (MOVE.equals(this.method) || COPY.equals(this.method) || CONCAT.equals(this.method) || INIT.equals(this.method) || SET.equals(this.method)) {
                    if (this.executeExpressions(evaluationContext)) {
                        bl = true;
                        if (MOVE.equals(this.method)) {
                            evaluationContext.reset();
                            this.deleteFromSourceExpression(evaluationContext);
                        }
                    }
                } else if (DELETE.equals(this.method) && this.deleteFromSourceExpression(evaluationContext)) {
                    bl = true;
                }
            }
            if (this.executeChildMappings(evaluationContext, this.mappings)) {
                bl = true;
            }
        } else if (this.executeChildMappings(evaluationContext, this.elseMappings)) {
            bl = true;
        }
        return bl;
    }

    private boolean executeExpressions(EvaluationContext evaluationContext) {
        boolean bl = false;
        do {
            EvaluationResult evaluationResult = null;
            if (this.sourceExpression != null && (evaluationResult = this.sourceExpression.evaluate(evaluationContext)) == EvaluationResult.DOES_NOT_EXIST) continue;
            this.evaluateVariables(evaluationContext);
            if (CONCAT.equals(this.method)) {
                this.targetExpression.concat(evaluationContext, this.convert(evaluationContext, BasicFactory.deepClone(evaluationResult.getValue())));
            } else {
                Object object = INIT.equals(this.method) ? (evaluationResult != null && evaluationResult.isArray() || evaluationResult == null && BasicFactory.isArray(evaluationContext.getContext()) ? BasicFactory.createJSONArray() : (evaluationResult != null && evaluationResult.isObject() || evaluationResult == null && BasicFactory.isObject(evaluationContext.getContext()) ? BasicFactory.createJSONObject() : null)) : (SET.equals(this.method) ? this.convert(evaluationContext, this.hasValue ? BasicFactory.deepClone(this.value) : evaluationResult.getValue()) : (COPY.equals(this.method) ? this.convert(evaluationContext, BasicFactory.deepClone(evaluationResult.getValue())) : this.convert(evaluationContext, evaluationResult.getValue())));
                do {
                    this.targetExpression.assign(evaluationContext, object);
                } while (this.targetExpression.next(evaluationContext));
            }
            bl = true;
        } while (this.sourceExpression != null && this.sourceExpression.next(evaluationContext));
        return bl;
    }

    private Object convert(EvaluationContext evaluationContext, Object object) {
        Converter converter;
        if (this.converterRef != null && (converter = this.converterRef.get()) != null) {
            return converter.convert(evaluationContext, object);
        }
        return object;
    }

    private boolean deleteFromSourceExpression(EvaluationContext evaluationContext) {
        boolean bl = false;
        do {
            this.evaluateVariables(evaluationContext);
            if (!this.sourceExpression.remove(evaluationContext)) continue;
            bl = true;
        } while (this.sourceExpression.next(evaluationContext));
        return bl;
    }

    private boolean executeChildMappings(EvaluationContext evaluationContext, List<Mapping> list) {
        boolean bl = false;
        if (list != null) {
            this.evaluateVariables(evaluationContext);
            for (Mapping mapping : list) {
                if (!mapping.execute(evaluationContext)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private boolean isGuardMet(EvaluationContext evaluationContext) {
        if (this.guards != null) {
            this.evaluateVariables(evaluationContext);
            for (Guard guard : this.guards) {
                if (guard.execute(evaluationContext)) continue;
                return false;
            }
        }
        return true;
    }

    private void evaluateVariables(EvaluationContext evaluationContext) {
        if (this.variables != null) {
            for (Map.Entry<String, PathExpression> entry : this.variables.entrySet()) {
                evaluationContext.getVariables().put(entry.getKey(), entry.getValue().evaluate(evaluationContext).getValue());
            }
        }
    }

    static List<Mapping> parse(JSONArray jSONArray) {
        int n = jSONArray == null ? 0 : BasicFactory.size(jSONArray);
        ArrayList<Mapping> arrayList = new ArrayList<Mapping>(n);
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = (JSONObject)BasicFactory.getArrayItem(jSONArray, i);
            arrayList.add(new Mapping(Mapping.parseStringArray(jSONObject, "context"), StrategyReference.parse((JSONObject)BasicFactory.getItem(jSONObject, "strategy")), ConverterReference.parse((JSONObject)BasicFactory.getItem(jSONObject, "converter")), (String)BasicFactory.getItem(jSONObject, "source"), (String)BasicFactory.getItem(jSONObject, "target"), (String)BasicFactory.getItem(jSONObject, "method"), (JSONObject)BasicFactory.getItem(jSONObject, "variables"), Mapping.parse((JSONArray)BasicFactory.getItem(jSONObject, "mapping")), Mapping.parse((JSONArray)BasicFactory.getItem(jSONObject, "elseMapping")), Guard.parse((JSONArray)BasicFactory.getItem(jSONObject, "guard")), BasicFactory.containsKey(jSONObject, "value"), BasicFactory.getItem(jSONObject, "value")));
        }
        return arrayList;
    }

    private static String[] parseStringArray(Object object, String string) {
        Object object2 = BasicFactory.getItem(object, string);
        if (object2 == null) {
            return null;
        }
        if (BasicFactory.isString(object2)) {
            return new String[]{(String)object2};
        }
        if (BasicFactory.isArray(object2)) {
            JSONArray jSONArray = (JSONArray)object2;
            String[] stringArray = new String[BasicFactory.size(jSONArray)];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)BasicFactory.getArrayItem(jSONArray, i);
            }
            return stringArray;
        }
        return null;
    }
}

