/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.migration;

import com.ibm.json.java.JSONArray;
import com.ibm.vis.engine.internal.migration.ArrayRange;
import com.ibm.vis.engine.internal.migration.EvaluationContext;
import com.ibm.vis.engine.internal.migration.EvaluationResult;
import com.ibm.vis.engine.internal.migration.PathExpression;
import com.ibm.vis.engine.internal.migration.SpecifiedArrayRange;
import com.ibm.vis.engine.internal.migration.VariableArrayRange;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.IntegerUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class PathSegment {
    private static final String ARRAY_LENGTH = "length";
    private static final String ALL = "//";
    private static final String WILD = "*";
    private static final String ROOT = "/";
    private static final String VAR = "$";
    private static final String VARD = "$$";
    private static final String VAR_OBJ = "%";
    private static final char RANGE = ':';
    private static final char PLUS = '+';
    private static final char MINUS = '-';
    private PathSegment parent;
    private PathSegment child = null;
    private final String pathSegment;
    private boolean isArray = false;
    private boolean isMultiDimensionArray = false;
    private boolean definesRange = false;
    private boolean arrayItem = false;
    private String rangeStart = null;
    private String rangeEnd = null;
    private boolean isVariableDeclaration = false;
    private boolean isImplicitVariableDeclaration = false;
    private boolean isVariablePath = false;
    private String variableObject = null;
    private boolean all = false;
    private int offsetStart = 0;
    private int offsetEnd = 0;
    private boolean isRoot = false;
    private String rangeVarStr = "$";

    public PathSegment(String string, PathSegment pathSegment) {
        Object object;
        String string2;
        int n;
        this.parent = pathSegment;
        if (pathSegment != null) {
            pathSegment.child = this;
        }
        if ((n = string.indexOf(91)) >= 0) {
            string2 = string.substring(0, n);
            this.isArray = true;
            this.isMultiDimensionArray = string2.length() == 0;
            object = string.substring(n + 1, string.length() - 1);
            if (((String)object).length() > 0) {
                this.arrayItem = true;
                String[] stringArray = PathSegment.split((String)object, ':');
                this.rangeStart = stringArray[0];
                this.parseOffset(true);
                if (WILD.equals(this.rangeStart)) {
                    this.isVariableDeclaration = true;
                    this.isImplicitVariableDeclaration = true;
                } else if (this.rangeStart.startsWith(VARD)) {
                    this.isVariableDeclaration = true;
                }
                if (stringArray.length == 2) {
                    this.definesRange = true;
                    this.rangeEnd = stringArray[1];
                    this.parseOffset(false);
                    if (WILD.equals(this.rangeStart)) {
                        throw new EngineException("Invalid range '" + this.rangeStart + ':' + this.rangeEnd + "'.", ErrorCode.MIGRATION_INVALID_PATH_EXPRESSION, null);
                    }
                }
            }
        } else {
            string2 = string;
        }
        if (string2.startsWith(ALL)) {
            if (this.arrayItem) {
                this.parent = new PathSegment(string2, this.parent);
                this.parent.child = this;
                this.isMultiDimensionArray = true;
                string2 = "";
            } else {
                object = this.parent;
                while (object != null) {
                    if (((PathSegment)object).all) {
                        throw new EngineException("Only one path segment with '//' is allowed in a qualified path.", ErrorCode.MIGRATION_INVALID_PATH_EXPRESSION, null);
                    }
                    object = ((PathSegment)object).parent;
                }
                this.isArray = true;
                this.all = true;
                string2 = string2.substring(ALL.length());
            }
        } else if (string2.startsWith(ROOT)) {
            if (this.parent != null) {
                throw new EngineException("A root reference with '/' is only allowed as the first segment in a qualified path.", ErrorCode.MIGRATION_INVALID_PATH_EXPRESSION, null);
            }
            this.isRoot = true;
            string2 = string2.substring(ROOT.length());
        }
        if (string2.startsWith(VAR)) {
            this.isVariablePath = true;
            this.pathSegment = string2.substring(VAR.length());
        } else if (string2.startsWith(VAR_OBJ)) {
            if (this.parent != null || this.all || this.isRoot) {
                throw new EngineException("An object reference with '%' is only allowed as the first segment in a qualified path.", ErrorCode.MIGRATION_INVALID_PATH_EXPRESSION, null);
            }
            this.variableObject = string2.substring(VAR_OBJ.length());
            this.pathSegment = "";
        } else {
            this.pathSegment = PathSegment.unescapePath(string2);
        }
    }

    private static String unescapePath(String string) {
        if (string.startsWith("\\$") || string.startsWith("\\%")) {
            return string.substring(1);
        }
        return string;
    }

    public void convertVariableDeclarationToReference() {
        this.isVariableDeclaration = false;
        this.rangeVarStr = VARD;
        if (this.isImplicitVariableDeclaration) {
            this.rangeStart = this.rangeVarStr + this.getImplicitVariable();
        }
    }

    private String getImplicitVariable() {
        int n = 0;
        PathSegment pathSegment = this;
        while ((pathSegment = pathSegment.getParent()) != null) {
            if (!pathSegment.isImplicitVariableDeclaration) continue;
            ++n;
        }
        return "" + n;
    }

    private void parseOffset(boolean bl) {
        String string = bl ? this.rangeStart : this.rangeEnd;
        boolean bl2 = true;
        String[] stringArray = PathSegment.split(string, '+');
        if (stringArray.length != 2) {
            bl2 = false;
            stringArray = PathSegment.split(string, '-');
        }
        if (stringArray.length == 2) {
            int n = IntegerUtil.parseInt(stringArray[1], 10).intValue();
            if (!bl2) {
                n = 0 - n;
            }
            if (bl) {
                this.rangeStart = stringArray[0];
                this.offsetStart = n;
            } else {
                this.rangeEnd = stringArray[0];
                this.offsetEnd = n;
            }
        }
    }

    public final PathSegment getParent() {
        return this.parent;
    }

    public EvaluationResult evaluate(EvaluationContext evaluationContext) {
        return this.createAndEvaluate(evaluationContext, false);
    }

    private int getIndex(JSONArray jSONArray, EvaluationContext evaluationContext) {
        int n;
        if (this.definesRange) {
            ArrayRange arrayRange = (ArrayRange)evaluationContext.getProperties().get(this);
            if (arrayRange == null) {
                int n2 = this.parseRange(evaluationContext, this.rangeStart, this.offsetStart);
                int n3 = this.parseRange(evaluationContext, this.rangeEnd, this.offsetEnd);
                if (n2 == -1) {
                    n2 = n3;
                }
                if (n3 == -1) {
                    n3 = n2;
                }
                if (n2 == -1 && n3 == -1) {
                    throw new EngineException("Invalid range [" + this.rangeStart + "-" + this.rangeEnd + "]", ErrorCode.MIGRATION_INVALID_PATH_EXPRESSION, null);
                }
                arrayRange = new ArrayRange(n2, n3);
                evaluationContext.getProperties().put(this, arrayRange);
            }
            n = arrayRange.current;
        } else if (this.isVariableDeclaration || this.all) {
            ArrayRange arrayRange = (ArrayRange)evaluationContext.getProperties().get(this);
            if (arrayRange == null) {
                int n4 = 0;
                int n5 = BasicFactory.size(jSONArray) - 1;
                if (this.all) {
                    arrayRange = new SpecifiedArrayRange(n4, n5, jSONArray);
                } else {
                    String string = this.isImplicitVariableDeclaration ? this.getImplicitVariable() : this.rangeStart.substring(VARD.length());
                    arrayRange = new VariableArrayRange(n4, n5, string);
                    evaluationContext.getVariables().put(string, arrayRange.current);
                }
                evaluationContext.getProperties().put(this, arrayRange);
            }
            n = arrayRange.current;
        } else {
            n = this.parseRange(evaluationContext, this.rangeStart, this.offsetStart);
        }
        return n;
    }

    public boolean next(EvaluationContext evaluationContext) {
        if (this.isArray) {
            ArrayRange arrayRange = (ArrayRange)evaluationContext.getProperties().get(this);
            if (arrayRange == null && (this.definesRange || this.isVariableDeclaration || this.all)) {
                JSONArray jSONArray;
                Object object = this.getContextObject(evaluationContext, false);
                if (object != null && (jSONArray = this.getArray(object, evaluationContext)) != null) {
                    this.getIndex(jSONArray, evaluationContext);
                }
                arrayRange = (ArrayRange)evaluationContext.getProperties().get(this);
            }
            if (arrayRange != null) {
                if (arrayRange.current < arrayRange.end) {
                    ++arrayRange.current;
                    if (arrayRange instanceof VariableArrayRange) {
                        evaluationContext.getVariables().put(((VariableArrayRange)arrayRange).variable, arrayRange.current);
                    }
                    return true;
                }
                if (this.parent != null && this.parent.next(evaluationContext)) {
                    if (arrayRange instanceof VariableArrayRange) {
                        evaluationContext.getVariables().remove(((VariableArrayRange)arrayRange).variable);
                    }
                    evaluationContext.getProperties().remove(this);
                    return true;
                }
                return false;
            }
        }
        return this.parent == null ? false : this.parent.next(evaluationContext);
    }

    private EvaluationResult createAndEvaluate(EvaluationContext evaluationContext, boolean bl) {
        EvaluationResult evaluationResult = EvaluationResult.DOES_NOT_EXIST;
        if (this.variableObject != null) {
            Object object = this.getVariableObject(evaluationContext);
            if (this.isArray) {
                if (BasicFactory.isArray(object)) {
                    if (this.arrayItem) {
                        int n = this.getIndex((JSONArray)object, evaluationContext);
                        if (n < BasicFactory.size((JSONArray)object)) {
                            evaluationResult = new EvaluationResult(BasicFactory.getArrayItem((JSONArray)object, n));
                        }
                    } else {
                        evaluationResult = new EvaluationResult(object);
                    }
                }
            } else {
                evaluationResult = new EvaluationResult(object);
            }
            return evaluationResult;
        }
        String string = this.getPath(evaluationContext);
        Object object = this.getContextObject(evaluationContext, bl);
        if (BasicFactory.isArray(object) && ARRAY_LENGTH.equals(string)) {
            return new EvaluationResult(BasicFactory.size((JSONArray)object));
        }
        if (object != null) {
            if (this.isArray && (this.arrayItem || this.all)) {
                if (!BasicFactory.isArray(object) && !BasicFactory.isObject(object)) {
                    evaluationResult = EvaluationResult.DOES_NOT_EXIST;
                } else {
                    JSONArray jSONArray = this.getArray(object, evaluationContext);
                    int n = -1;
                    if (this.arrayItem) {
                        if (jSONArray == null && bl) {
                            jSONArray = BasicFactory.createJSONArray();
                            BasicFactory.put(object, string, jSONArray);
                        }
                        if (bl) {
                            n = this.getIndex(jSONArray, evaluationContext);
                            for (int i = BasicFactory.size(jSONArray); n >= i; ++i) {
                                Object object2 = null;
                                if (this.child != null && i == n) {
                                    object2 = this.child.isMultiDimensionArray ? BasicFactory.createJSONArray() : BasicFactory.createJSONObject();
                                }
                                BasicFactory.add(jSONArray, object2);
                            }
                        }
                    }
                    if (jSONArray != null) {
                        if (n == -1) {
                            n = this.getIndex(jSONArray, evaluationContext);
                        }
                        if (n < BasicFactory.size(jSONArray)) {
                            evaluationResult = new EvaluationResult(BasicFactory.getArrayItem(jSONArray, n));
                        }
                    }
                }
            } else {
                if (this.isMultiDimensionArray && BasicFactory.isArray(object)) {
                    evaluationResult = new EvaluationResult(object);
                } else if (BasicFactory.isObject(object) && BasicFactory.containsKey(object, string)) {
                    evaluationResult = new EvaluationResult(BasicFactory.getItem(object, string));
                }
                if (bl && evaluationResult.getValue() == null) {
                    JSONArray jSONArray = this.isArray ? BasicFactory.createJSONArray() : BasicFactory.createJSONObject();
                    BasicFactory.put(object, string, jSONArray);
                    evaluationResult = new EvaluationResult(jSONArray);
                }
            }
        }
        return evaluationResult;
    }

    private Object getContextObject(EvaluationContext evaluationContext, boolean bl) {
        Object object = null;
        if (this.variableObject != null) {
            object = evaluationContext.getVariable(this.variableObject);
        } else if (this.parent != null) {
            EvaluationResult evaluationResult = this.parent.createAndEvaluate(evaluationContext, bl);
            if (evaluationResult != EvaluationResult.DOES_NOT_EXIST) {
                object = evaluationResult.getValue();
            }
        } else {
            object = evaluationContext.getContext();
            if (this.isRoot) {
                EvaluationContext evaluationContext2 = evaluationContext;
                while ((evaluationContext2 = evaluationContext2.getParent()) != null) {
                    object = evaluationContext2.getContext();
                }
            }
        }
        return object;
    }

    private Object getVariableObject(EvaluationContext evaluationContext) {
        assert (this.variableObject != null);
        return evaluationContext.getVariable(this.variableObject);
    }

    public void assign(EvaluationContext evaluationContext, Object object) {
        Object object2 = this.getContextObject(evaluationContext, true);
        String string = this.getPath(evaluationContext);
        if (this.isArray && this.arrayItem) {
            JSONArray jSONArray = this.getArray(object2, evaluationContext);
            if (jSONArray == null) {
                jSONArray = BasicFactory.createJSONArray();
                BasicFactory.put(object2, string, jSONArray);
            }
            int n = this.getIndex(jSONArray, evaluationContext);
            while (n >= BasicFactory.size(jSONArray)) {
                BasicFactory.add(jSONArray, null);
            }
            BasicFactory.setAt(jSONArray, object, n);
        } else if (BasicFactory.isObject(object2)) {
            BasicFactory.put(object2, string, object);
        } else {
            throw new EngineException("Unable to assign a value to '" + string + "' due to an invalid value in the path.", ErrorCode.MIGRATION_INVALID_PATH_EXPRESSION, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void concat(EvaluationContext evaluationContext, Object object) {
        if (!this.isArray || this.arrayItem) throw new EngineException("Concatenation is not supported for '" + this.getPath(evaluationContext) + "' because it is not an array.", ErrorCode.MIGRATION_INVALID_PATH_EXPRESSION, null);
        EvaluationResult evaluationResult = this.createAndEvaluate(evaluationContext, true);
        if (BasicFactory.isArray(object)) {
            BasicFactory.addAll((JSONArray)evaluationResult.getValue(), (JSONArray)object);
            return;
        } else {
            if (!evaluationResult.isArray()) throw new EngineException("Unable to concat a value to '" + this.getPath(evaluationContext) + "' due to an invalid value in the path.", ErrorCode.MIGRATION_INVALID_PATH_EXPRESSION, null);
            BasicFactory.add((JSONArray)evaluationResult.getValue(), object);
        }
    }

    public boolean remove(EvaluationContext evaluationContext) {
        boolean bl = false;
        Object object = this.parent == null ? evaluationContext.getContext() : this.parent.createAndEvaluate(evaluationContext, false).getValue();
        if (object != null) {
            String string;
            if (this.isArray && this.arrayItem) {
                int n;
                JSONArray jSONArray = this.getArray(object, evaluationContext);
                if (jSONArray != null && (n = this.getIndex(jSONArray, evaluationContext)) < BasicFactory.size(jSONArray)) {
                    bl = true;
                    BasicFactory.removeAt(jSONArray, this.getIndex(jSONArray, evaluationContext));
                    ArrayRange arrayRange = (ArrayRange)evaluationContext.getProperties().get(this);
                    if (arrayRange != null) {
                        --arrayRange.current;
                        --arrayRange.end;
                    }
                }
            } else if (BasicFactory.isObject(object) && BasicFactory.containsKey(object, string = this.getPath(evaluationContext))) {
                bl = true;
                BasicFactory.remove(object, string);
            }
        }
        return bl;
    }

    private int parseRange(EvaluationContext evaluationContext, String string, int n) {
        if (string.startsWith(this.rangeVarStr + "(")) {
            Integer n2 = (Integer)new PathExpression(string.substring(this.rangeVarStr.length() + 1, string.length() - 1)).evaluate(evaluationContext).getValue();
            if (n2 == null) {
                return -1;
            }
            return n2 + n;
        }
        if (string.startsWith(this.rangeVarStr)) {
            return (Integer)evaluationContext.getVariable(string.substring(this.rangeVarStr.length())) + n;
        }
        return IntegerUtil.parseInt(string, 10).intValue() + n;
    }

    private String getPath(EvaluationContext evaluationContext) {
        if (this.isVariablePath) {
            return (String)evaluationContext.getVariable(this.pathSegment);
        }
        return this.pathSegment;
    }

    private JSONArray getArray(Object object, EvaluationContext evaluationContext) {
        Object object2;
        JSONArray jSONArray = null;
        String string = this.getPath(evaluationContext);
        if (this.isMultiDimensionArray) {
            if (BasicFactory.isArray(object)) {
                jSONArray = (JSONArray)object;
            }
        } else if (this.all) {
            SpecifiedArrayRange specifiedArrayRange = (SpecifiedArrayRange)evaluationContext.getProperties().get(this);
            if (specifiedArrayRange != null) {
                jSONArray = specifiedArrayRange.array;
            } else {
                jSONArray = BasicFactory.createJSONArray();
                this.objectSearch(evaluationContext, object, jSONArray);
            }
        } else if (BasicFactory.isObject(object) && BasicFactory.isArray(object2 = BasicFactory.getItem(object, string))) {
            jSONArray = (JSONArray)object2;
        }
        return jSONArray;
    }

    private void objectSearch(EvaluationContext evaluationContext, Object object, JSONArray jSONArray) {
        block6: {
            block5: {
                String[] stringArray;
                if (!BasicFactory.isObject(object)) break block5;
                String string = this.getPath(evaluationContext);
                if (BasicFactory.containsKey(object, string)) {
                    if (this.child == null) {
                        BasicFactory.add(jSONArray, object);
                    } else {
                        BasicFactory.add(jSONArray, BasicFactory.getItem(object, string));
                    }
                }
                for (String string2 : stringArray = BasicFactory.keySet(object)) {
                    this.objectSearch(evaluationContext, BasicFactory.getItem(object, string2), jSONArray);
                }
                break block6;
            }
            if (!BasicFactory.isArray(object)) break block6;
            int n = BasicFactory.size((JSONArray)object);
            for (int i = 0; i < n; ++i) {
                this.objectSearch(evaluationContext, BasicFactory.getArrayItem((JSONArray)object, i), jSONArray);
            }
        }
    }

    static String[] split(String string, char c) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == '[' || c2 == '(') {
                ++n2;
            } else if (c2 == ']' || c2 == ')') {
                --n2;
            } else if (c2 == c && n2 == 0) {
                arrayList.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
                continue;
            }
            stringBuilder.append(c2);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

