/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.migration;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.extension.RAVEExtensionManager;
import com.ibm.vis.engine.internal.migration.EvaluationContext;
import com.ibm.vis.engine.internal.migration.ExtensionParameter;
import com.ibm.vis.engine.internal.migration.MigrationStrategy;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.Version;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class StrategyReference {
    public static final String VERSION_PROPERTY = "StrategyReference.version";
    private final String id;
    private final Object parameters;

    public StrategyReference(String string, Object object) {
        this.id = string;
        this.parameters = object;
    }

    public MigrationStrategy get(EvaluationContext evaluationContext) {
        Version version = (Version)evaluationContext.getProperty(VERSION_PROPERTY);
        if (version == null) {
            throw new IllegalArgumentException("No 'version' property found in the evaluation context.");
        }
        return (MigrationStrategy)RAVEExtensionManager.INSTANCE.newInstance(this.id, new ExtensionParameter(version, this.parameters));
    }

    static StrategyReference parse(JSONObject jSONObject) {
        StrategyReference strategyReference = null;
        if (jSONObject != null) {
            strategyReference = new StrategyReference((String)BasicFactory.getItem(jSONObject, "id"), BasicFactory.getItem(jSONObject, "parameters"));
        }
        return strategyReference;
    }
}

