/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.migration.spec;

import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.migration.MigrationStrategy;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.Version;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class CircleShapeMigrator3_0
implements MigrationStrategy {
    private static final Version VERSION = new Version(3, 0, 0);

    CircleShapeMigrator3_0() {
    }

    @Override
    public final Version getTargetVersion() {
        return VERSION;
    }

    @Override
    public boolean migrate(JSONArtifact jSONArtifact) {
        boolean bl = false;
        if (jSONArtifact != null) {
            Object object = BasicFactory.createJSONObject();
            BasicFactory.put(jSONArtifact, "type", "circle");
            Object object2 = BasicFactory.getItem(jSONArtifact, "r");
            Object object3 = BasicFactory.getItem(jSONArtifact, "x");
            Object object4 = BasicFactory.getItem(jSONArtifact, "y");
            if (BasicFactory.isString(object2) && BasicFactory.isString(object3) && BasicFactory.isString(object4)) {
                String string = (String)object2;
                String string2 = (String)object3;
                String string3 = (String)object4;
                if (string.endsWith("%%") || string2.endsWith("%%") || string3.endsWith("%%")) {
                    throw new EngineException("Unable to migrate the spec because it has %% used for Shape bounds. Please consider using % or absolute values.", ErrorCode.MIGRATION_COULD_NOT_BE_DONE, null);
                }
                if (string.endsWith("%") && string2.endsWith("%") && string3.endsWith("%")) {
                    bl = true;
                    object = CircleShapeMigrator3_0.createBoundsValues(string, string2, string3, "%");
                } else if (string.endsWith("px") && string2.endsWith("px") && string3.endsWith("px")) {
                    bl = true;
                    object = CircleShapeMigrator3_0.createBoundsValues(string, string2, string3, "px");
                } else if (string.endsWith("pt") && string2.endsWith("pt") && string3.endsWith("pt")) {
                    bl = true;
                    object = CircleShapeMigrator3_0.createBoundsValues(string, string2, string3, "pt");
                } else if (string.endsWith("pc") && string2.endsWith("pc") && string3.endsWith("pc")) {
                    bl = true;
                    object = CircleShapeMigrator3_0.createBoundsValues(string, string2, string3, "pc");
                } else if (string.endsWith("cm") && string2.endsWith("cm") && string3.endsWith("cm")) {
                    bl = true;
                    object = CircleShapeMigrator3_0.createBoundsValues(string, string2, string3, "cm");
                } else if (string.endsWith("mm") && string2.endsWith("mm") && string3.endsWith("mm")) {
                    bl = true;
                    object = CircleShapeMigrator3_0.createBoundsValues(string, string2, string3, "mm");
                } else if (string.endsWith("in") && string2.endsWith("in") && string3.endsWith("in")) {
                    bl = true;
                    object = CircleShapeMigrator3_0.createBoundsValues(string, string2, string3, "in");
                } else {
                    Double d = UnitConverter.convertLength(object2, null, null);
                    Double d2 = UnitConverter.convertLength(object3, null, null);
                    Double d3 = UnitConverter.convertLength(object4, null, null);
                    if (d != null & d2 != null && d3 != null) {
                        object = CircleShapeMigrator3_0.createBoundsValuesForNumeric(d, d2, d3);
                        bl = true;
                    }
                }
            } else {
                Double d = UnitConverter.convertLength(object2, null, null);
                Double d4 = UnitConverter.convertLength(object3, null, null);
                Double d5 = UnitConverter.convertLength(object4, null, null);
                if (d != null & d4 != null && d5 != null) {
                    object = CircleShapeMigrator3_0.createBoundsValuesForNumeric(d, d4, d5);
                    bl = true;
                }
            }
            if (bl) {
                BasicFactory.put(jSONArtifact, "bounds", object);
                BasicFactory.remove(jSONArtifact, "r");
                BasicFactory.remove(jSONArtifact, "x");
                BasicFactory.remove(jSONArtifact, "y");
            } else {
                throw new EngineException("Unable to migrate the Symbol Spec for circle Shape.This could be due to [i] Use of Preferred Size Spec [ii] Use of %% [iii] Using different Units for x,y and r", ErrorCode.MIGRATION_COULD_NOT_BE_DONE, null);
            }
        }
        return bl;
    }

    private static Object createBoundsValues(String string, String string2, String string3, String string4) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = string3.length();
        int n4 = string4.length();
        double d = CircleShapeMigrator3_0.tryParse(string.substring(0, n - n4));
        double d2 = CircleShapeMigrator3_0.tryParse(string2.substring(0, n2 - n4));
        double d3 = CircleShapeMigrator3_0.tryParse(string3.substring(0, n3 - n4));
        JSONObject jSONObject = BasicFactory.createJSONObject();
        Double d4 = 2.0 * d;
        Double d5 = 2.0 * d;
        Double d6 = d2 - d;
        Double d7 = d3 - d;
        BasicFactory.put(jSONObject, "width", d4 + string4);
        BasicFactory.put(jSONObject, "height", d5 + string4);
        BasicFactory.put(jSONObject, "left", d6 + string4);
        BasicFactory.put(jSONObject, "top", d7 + string4);
        return jSONObject;
    }

    private static Object createBoundsValuesForNumeric(double d, double d2, double d3) {
        JSONObject jSONObject = BasicFactory.createJSONObject();
        Double d4 = 2.0 * d;
        Double d5 = 2.0 * d;
        Double d6 = d2 - d;
        Double d7 = d3 - d;
        BasicFactory.put(jSONObject, "width", d4);
        BasicFactory.put(jSONObject, "height", d5);
        BasicFactory.put(jSONObject, "left", d6);
        BasicFactory.put(jSONObject, "top", d7);
        return jSONObject;
    }

    private static double tryParse(String string) {
        try {
            double d = Double.parseDouble(string);
            return Double.isNaN(d) ? null : Double.valueOf(d);
        }
        catch (Exception exception) {
            throw new EngineException("Could not parse the string value to convert it to a numeric value", ErrorCode.MIGRATION_COULD_NOT_BE_DONE, null);
        }
    }
}

