/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.migration.spec;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.migration.MigrationStrategy;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.ResourceUtil;
import com.ibm.vis.engine.internal.util.Version;
import com.ibm.vis.exceptions.internal.EngineException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

public class CustomShapeStrategy
implements MigrationStrategy {
    private static final Version VERSION = new Version(3, 0, 0);
    private static CustomShapeStrategy INSTANCE;
    private static final String ITEMS = "items";
    private static final String PROPERTIES = "properties";
    private static final String ENUM = "enum";
    private Collection<String> schemaDefinedTypes;

    @Override
    public final Version getTargetVersion() {
        return VERSION;
    }

    public static CustomShapeStrategy getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CustomShapeStrategy();
        }
        return INSTANCE;
    }

    private CustomShapeStrategy() {
        try {
            JSONArray jSONArray;
            JSONObject jSONObject;
            JSONObject jSONObject2 = ResourceUtil.getRaveSchema(this.getTargetVersion());
            JSONObject jSONObject3 = this.getNextObject(this.getProperties(jSONObject2), "grammar");
            jSONObject3 = this.getNextObject(jSONObject3, "elements");
            JSONObject jSONObject4 = jSONObject = jSONObject3 == null ? null : (JSONObject)BasicFactory.getItem(jSONObject3, "type");
            if (jSONObject != null && (jSONArray = (JSONArray)BasicFactory.getItem(jSONObject, ENUM)) != null) {
                this.schemaDefinedTypes = new HashSet<String>((Collection<String>)jSONArray);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public boolean migrate(JSONArtifact jSONArtifact) throws EngineException {
        if (this.schemaDefinedTypes == null) {
            return false;
        }
        boolean bl = false;
        Object object = BasicFactory.getItem(jSONArtifact, "type");
        Object object2 = BasicFactory.getItem(jSONArtifact, "path");
        if (object2 != null && !this.schemaDefinedTypes.contains(object)) {
            BasicFactory.put(jSONArtifact, "type", "path");
            bl = true;
        }
        return bl;
    }

    private JSONObject getProperties(JSONObject jSONObject) {
        return jSONObject == null ? null : (JSONObject)BasicFactory.getItem(jSONObject, PROPERTIES);
    }

    private JSONObject getItems(JSONObject jSONObject) {
        return jSONObject == null ? null : (JSONObject)BasicFactory.getItem(jSONObject, ITEMS);
    }

    private JSONObject getNextObject(JSONObject jSONObject, String string) {
        JSONObject jSONObject2 = jSONObject == null ? null : (JSONObject)BasicFactory.getItem(jSONObject, string);
        JSONObject jSONObject3 = this.getItems(jSONObject2);
        return this.getProperties(jSONObject3);
    }
}

