/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.migration.spec;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.migration.MigrationStrategy;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.util.Version;
import com.ibm.vis.exceptions.internal.EngineException;
import java.util.ArrayList;
import java.util.List;

public class LegendLocationStrategy
implements MigrationStrategy {
    private static final String LEGENDS = "legends";
    private static final String LOCATION = "location";
    private Version version = new Version(5, 1, 0);

    @Override
    public Version getTargetVersion() {
        return this.version;
    }

    @Override
    public boolean migrate(JSONArtifact jSONArtifact) throws EngineException {
        int n;
        boolean bl = false;
        JSONArray jSONArray = (JSONArray)BasicFactory.getItem(jSONArtifact, LEGENDS);
        if (jSONArray != null && (n = BasicFactory.size(jSONArray)) > 0 && (n != 1 || BasicFactory.keySet(BasicFactory.getArrayItem(jSONArray, 0)).length > 0)) {
            bl = this.migrateLegendsLocations(jSONArray);
        }
        return bl;
    }

    private boolean migrateLegendsLocations(JSONArray jSONArray) {
        int n = BasicFactory.size(jSONArray);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = (JSONObject)BasicFactory.getArrayItem(jSONArray, i);
            Object object = BasicFactory.getItem(jSONObject, LOCATION);
            if (object != null) {
                arrayList2.add(object);
                continue;
            }
            arrayList.add(jSONObject);
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        JSONObject jSONObject = this.getWidestBounds(arrayList2);
        if (jSONObject == null) {
            return false;
        }
        for (Object object : arrayList) {
            BasicFactory.put(object, LOCATION, jSONObject);
        }
        return true;
    }

    private JSONObject getWidestBounds(List list) {
        double d = 0.0;
        String string = null;
        for (Object e : list) {
            double d2;
            String string2;
            Object object;
            if (!BasicFactory.isObject(e) || (object = BasicFactory.getItem(e, "width")) == null || !BasicFactory.isString(object) || (string2 = (String)object).endsWith("%%") || !string2.endsWith("%") || !((d2 = Double.parseDouble(string2.substring(0, string2.length() - 1)) / 100.0) > d)) continue;
            d = d2;
            string = string2;
        }
        if (string == null) {
            return null;
        }
        JSONObject jSONObject = BasicFactory.createJSONObject();
        BasicFactory.put(jSONObject, "width", string);
        return jSONObject;
    }
}

