/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.migration.spec;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.migration.MigrationStrategy;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.Version;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class LegendMigrator1_3
implements MigrationStrategy {
    private static final String LEGENDS = "legends";
    private static final String CONTENT = "content";
    private static final String TEXT_STYLE = "textStyle";
    private static final String TEXT = "text";
    private static final String TITLE_STYLE = "titleStyle";
    private static final String AESTHETICS = "aesthetics";
    private static final Version VERSION = new Version(1, 3, 0);

    LegendMigrator1_3() {
    }

    @Override
    public final Version getTargetVersion() {
        return VERSION;
    }

    @Override
    public boolean migrate(JSONArtifact jSONArtifact) {
        int n;
        boolean bl = false;
        JSONArray jSONArray = (JSONArray)BasicFactory.getItem(jSONArtifact, LEGENDS);
        if (jSONArray != null && (n = BasicFactory.size(jSONArray)) > 0 && (n != 1 || BasicFactory.keySet(BasicFactory.getArrayItem(jSONArray, 0)).length > 0)) {
            bl = LegendMigrator1_3.mergeLegendTitles(jSONArray);
        }
        return bl;
    }

    private static boolean mergeLegendTitles(JSONArray jSONArray) {
        boolean bl = false;
        int n = BasicFactory.size(jSONArray);
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = (JSONObject)BasicFactory.getArrayItem(jSONArray, i);
            JSONArray jSONArray2 = (JSONArray)BasicFactory.getItem(jSONObject, CONTENT);
            if (jSONArray2 == null) continue;
            bl = LegendMigrator1_3.mergeContentTitles(jSONArray2) || bl;
        }
        return bl;
    }

    private static boolean mergeContentTitles(JSONArray jSONArray) {
        boolean bl = false;
        int n = BasicFactory.size(jSONArray);
        JSONArray jSONArray2 = null;
        JSONObject jSONObject = null;
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject2 = (JSONObject)BasicFactory.getArrayItem(jSONArray, i);
            boolean bl2 = jSONArray2 != null && BasicFactory.size(jSONArray2) > 0;
            boolean bl3 = BasicFactory.containsKey(jSONObject2, AESTHETICS);
            boolean bl4 = bl3 || i == n - 1;
            boolean bl5 = BasicFactory.containsKey(jSONObject2, TEXT);
            if (bl5) {
                Object object;
                if (jSONArray2 == null) {
                    jSONArray2 = BasicFactory.createJSONArray();
                }
                if (BasicFactory.isArray(object = BasicFactory.getItem(jSONObject2, TEXT))) {
                    BasicFactory.addAll(jSONArray2, (JSONArray)object);
                } else {
                    BasicFactory.add(jSONArray2, object);
                }
                if (jSONObject == null) {
                    jSONObject = (JSONObject)BasicFactory.getItem(jSONObject2, TEXT_STYLE);
                }
            }
            if (bl2) {
                bl = true;
                BasicFactory.removeAt(jSONArray, i - 1);
                --i;
                --n;
            }
            if (!bl4) continue;
            bl = true;
            if (jSONArray2 != null) {
                BasicFactory.put(jSONObject2, TEXT, jSONArray2);
            } else {
                if (bl3) {
                    BasicFactory.put(jSONObject2, TEXT, BasicFactory.createJSONArray());
                }
                if (jSONObject == null && (jSONObject = (JSONObject)BasicFactory.getItem(jSONObject2, TEXT_STYLE)) == null) {
                    jSONObject = BasicFactory.createJSONObject();
                }
            }
            if (jSONObject != null) {
                BasicFactory.put(jSONObject2, TITLE_STYLE, jSONObject);
            }
            jSONArray2 = null;
            jSONObject = null;
        }
        return bl;
    }
}

