/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.migration.spec;

import com.ibm.vis.engine.internal.migration.Converter;
import com.ibm.vis.engine.internal.migration.EvaluationContext;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class MigrationUnitConverter
implements Converter {
    public static final String MULTIPLIER = "multiplier";
    public static final String UNIT = "unit";
    private String unit = null;
    private double multiplier = 1.0;

    public MigrationUnitConverter(Object object) {
        if (BasicFactory.isObject(object)) {
            Object object2;
            Object object3 = BasicFactory.getItem(object, MULTIPLIER);
            if (BasicFactory.isNumber(object3)) {
                this.multiplier = ((Number)object3).doubleValue();
            }
            if (BasicFactory.containsKey(object, UNIT) && BasicFactory.isString(object2 = BasicFactory.getItem(object, UNIT))) {
                this.unit = (String)object2;
            }
        }
    }

    @Override
    public Object convert(EvaluationContext evaluationContext, Object object) {
        if (BasicFactory.isNumber(object)) {
            double d = MigrationUnitConverter.r3(((Number)object).doubleValue() * this.multiplier).doubleValue();
            if (d % 1.0 == 0.0) {
                long l = (long)d;
                return this.unit == null ? Long.valueOf(l) : l + this.unit;
            }
            return this.unit == null ? Double.valueOf(d) : d + this.unit;
        }
        return object;
    }

    public static Number r3(double d) {
        double d2 = (double)Math.round(d * 1000.0) / 1000.0;
        int n = (int)d2;
        if ((double)n == d2) {
            return n;
        }
        return d2;
    }
}

