/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.migration.spec;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.extension.RAVEExtensionManager;
import com.ibm.vis.engine.internal.migration.DeclarativeMigrationStrategy;
import com.ibm.vis.engine.internal.migration.JSONMigration;
import com.ibm.vis.engine.internal.migration.MigrationStrategy;
import com.ibm.vis.engine.internal.migration.spec.SpecMigrationExtensionFactory;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.ResourceUtil;
import com.ibm.vis.engine.internal.util.Version;
import java.io.IOException;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2103\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/migrationLayer")
public final class SpecMigration
extends JSONMigration {
    private static SpecMigration instance;
    private static final Version TARGET_VERSION;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final SpecMigration getInstance() throws IOException {
        if (instance != null) return instance;
        Class<SpecMigration> clazz = SpecMigration.class;
        synchronized (SpecMigration.class) {
            if (instance != null) return instance;
            RAVEExtensionManager.INSTANCE.registerDefaultFactory(new SpecMigrationExtensionFactory());
            SpecMigration specMigration = new SpecMigration();
            JSONArray jSONArray = ResourceUtil.getDeclarativeSpecMigrationStrategies();
            if (jSONArray != null) {
                for (MigrationStrategy migrationStrategy : DeclarativeMigrationStrategy.parse(jSONArray)) {
                    specMigration.addStrategy(migrationStrategy);
                }
            }
            specMigration.sortStrategies();
            instance = specMigration;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SpecMigration() {
    }

    @Override
    public JSONArtifact getMigrated(JSONArtifact jSONArtifact) {
        JSONArtifact jSONArtifact2 = super.getMigrated(jSONArtifact);
        if (jSONArtifact2 != null) {
            BasicFactory.put(jSONArtifact2, "version", this.getTargetVersion().toString());
        }
        return jSONArtifact2;
    }

    @Override
    public boolean migrate(JSONArtifact jSONArtifact) {
        boolean bl = super.migrate(jSONArtifact);
        BasicFactory.put(jSONArtifact, "version", this.getTargetVersion().toString());
        return bl;
    }

    @Override
    public Version getTargetVersion() {
        return TARGET_VERSION;
    }

    static {
        TARGET_VERSION = Version.parseVersion("7.2");
    }
}

