/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.migration.spec;

import com.ibm.vis.engine.internal.extension.ExtensionFactory;
import com.ibm.vis.engine.internal.migration.Converter;
import com.ibm.vis.engine.internal.migration.ExtensionParameter;
import com.ibm.vis.engine.internal.migration.MigrationStrategy;
import com.ibm.vis.engine.internal.migration.spec.CircleShapeMigrator3_0;
import com.ibm.vis.engine.internal.migration.spec.CustomShapeStrategy;
import com.ibm.vis.engine.internal.migration.spec.LegendLocationStrategy;
import com.ibm.vis.engine.internal.migration.spec.LegendMigrator1_3;
import com.ibm.vis.engine.internal.migration.spec.LevelLabelMigrator5_0;
import com.ibm.vis.engine.internal.migration.spec.LevelMigrator5_0;
import com.ibm.vis.engine.internal.migration.spec.MigrationUnitConverter;
import com.ibm.vis.engine.internal.migration.spec.StringFormatConverter;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.Version;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class SpecMigrationExtensionFactory
implements ExtensionFactory {
    private static final String MIGRATION_PREFIX = "migration.";
    private static final String CONVERTER_PREFIX = "migration.converter.";
    private static final String LEGENDS = "migration.legends";
    private static final String CIRCLE_SHAPE = "migration.circleShape";
    private static final String CUSTOM_SHAPE = "migration.customShape";
    private static final String LEVELS = "migration.levels";
    private static final String LEVELS_LABEL = "migration.levelsLabel";
    private static final String UNIT_CONVERTER = "migration.converter.units";
    private static final String STRING_FORMAT_CONVERTER = "migration.converter.stringFormat";

    SpecMigrationExtensionFactory() {
    }

    @Override
    public Object newInstance(String string, Object object) {
        if (string != null) {
            if (string.startsWith(CONVERTER_PREFIX)) {
                return SpecMigrationExtensionFactory.createConverter(string, object);
            }
            if (string.startsWith(MIGRATION_PREFIX) && object instanceof ExtensionParameter) {
                return SpecMigrationExtensionFactory.createMigrationStrategy(string, (ExtensionParameter)object);
            }
        }
        return null;
    }

    private static MigrationStrategy createMigrationStrategy(String string, ExtensionParameter extensionParameter) {
        MigrationStrategy migrationStrategy = null;
        Version version = extensionParameter.getVersion();
        if (version.equals(new Version(1, 3, 0))) {
            if (LEGENDS.equals(string)) {
                migrationStrategy = new LegendMigrator1_3();
            }
        } else if (version.equals(new Version(3, 0, 0))) {
            if (CIRCLE_SHAPE.equals(string)) {
                migrationStrategy = new CircleShapeMigrator3_0();
            }
        } else if (version.equals(new Version(5, 0, 0))) {
            if (LEVELS.equals(string)) {
                migrationStrategy = new LevelMigrator5_0();
            } else if (LEVELS_LABEL.equals(string)) {
                migrationStrategy = new LevelLabelMigrator5_0();
            }
        } else if (version.equals(new Version(5, 1, 0))) {
            if (LEGENDS.equals(string)) {
                migrationStrategy = new LegendLocationStrategy();
            } else if (CUSTOM_SHAPE.equals(string)) {
                migrationStrategy = CustomShapeStrategy.getInstance();
            }
        }
        return migrationStrategy;
    }

    private static Converter createConverter(String string, Object object) {
        Converter converter = null;
        if (UNIT_CONVERTER.equals(string)) {
            converter = new MigrationUnitConverter(object);
        } else if (STRING_FORMAT_CONVERTER.equals(string)) {
            converter = new StringFormatConverter(object);
        }
        return converter;
    }
}

