/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class BasicFactory {
    private static final NumberFormat decimal = new DecimalFormat("#.###");
    private static final NumberFormat scientific = new DecimalFormat("0.####E0");
    private static final NumberFormat unformattedInteger = new DecimalFormat("0");
    private static final DecimalFormatSymbols dfs = new DecimalFormatSymbols();
    private static final NumberFormat unformattedDouble;
    private static final NumberFormat unformattedScientific;

    public static void addAll(JSONArray jSONArray, JSONArray jSONArray2) {
        jSONArray.addAll((Collection)jSONArray2);
    }

    public static void add(JSONArray jSONArray, Object object) {
        jSONArray.add(object);
    }

    public static void addAt(JSONArray jSONArray, Object object, int n) {
        jSONArray.add(n, object);
    }

    public static void setAt(JSONArray jSONArray, Object object, int n) {
        jSONArray.set(n, object);
    }

    public static Object clone(JSONObject jSONObject) {
        return jSONObject.clone();
    }

    public static JSONArray createJSONArray() {
        return new JSONArray();
    }

    public static JSONObject createJSONObject() {
        return new JSONObject();
    }

    public static JSONArray createSizedJSONArray(int n) {
        return new JSONArray(n);
    }

    public static String getRegExBarString() {
        return "\\|";
    }

    public static Object deepClone(Object object) {
        if (object instanceof JSONObject) {
            JSONObject jSONObject = (JSONObject)object;
            JSONObject jSONObject2 = BasicFactory.createJSONObject();
            for (String string : BasicFactory.keySet(jSONObject)) {
                BasicFactory.put(jSONObject2, string, BasicFactory.deepClone(BasicFactory.getItem(jSONObject, string)));
            }
            return jSONObject2;
        }
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            JSONArray jSONArray2 = BasicFactory.createSizedJSONArray(BasicFactory.size(jSONArray));
            for (Object e : jSONArray) {
                BasicFactory.add(jSONArray2, BasicFactory.deepClone(e));
            }
            return jSONArray2;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unformattedNumber(Number number) {
        String string;
        if (number == null) {
            return null;
        }
        double d = number.doubleValue();
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (d == -0.0) {
            return "0";
        }
        long l = number.longValue();
        if ((double)l >= -1.0E15 && (double)l <= 1.0E15) {
            if ((double)l == d) {
                NumberFormat numberFormat = unformattedInteger;
                synchronized (numberFormat) {
                    return unformattedInteger.format(l);
                }
            }
            l = Math.round(d);
            if (l != 0L && Math.abs(d - (double)l) < 5.0E-11) {
                NumberFormat numberFormat = unformattedInteger;
                synchronized (numberFormat) {
                    return unformattedInteger.format(l);
                }
            }
        }
        if (Math.abs(d) >= 0.001 && Math.abs(d) <= 1.0E8) {
            NumberFormat numberFormat = unformattedDouble;
            synchronized (numberFormat) {
                return unformattedDouble.format(d);
            }
        }
        NumberFormat numberFormat = unformattedScientific;
        synchronized (numberFormat) {
            string = unformattedScientific.format(number);
        }
        int n = string.indexOf(101);
        if (string.charAt(n + 1) == '-') {
            return string;
        }
        return string.substring(0, n + 1) + "+" + string.substring(n + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(double d, Range range) {
        if (Math.max(Math.abs(range.getMax()), Math.abs(range.getMin())) < 1.0E-4) {
            NumberFormat numberFormat = scientific;
            synchronized (numberFormat) {
                return scientific.format(d);
            }
        }
        if (Math.max(Math.abs(range.getMax()), Math.abs(range.getMin())) > 100000.0) {
            NumberFormat numberFormat = scientific;
            synchronized (numberFormat) {
                return scientific.format(d);
            }
        }
        NumberFormat numberFormat = decimal;
        synchronized (numberFormat) {
            return decimal.format(d);
        }
    }

    public static Object getArrayItem(JSONArray jSONArray, int n) {
        return jSONArray.get(n);
    }

    public static Object getItem(Object object, String string) {
        return ((JSONObject)object).get((Object)string);
    }

    public static double getNumberWithDefault(Object object, String string, double d) {
        Object object2 = null;
        if (object instanceof JSONObject) {
            object2 = ((JSONObject)object).get((Object)string);
        }
        if (object2 != null && object2 instanceof Number) {
            return ((Number)object2).doubleValue();
        }
        return d;
    }

    public static boolean isEmpty(JSONObject jSONObject) {
        return jSONObject.isEmpty();
    }

    public static boolean isNumber(Object object) {
        assert (!(object instanceof Character));
        return object instanceof Number;
    }

    public static boolean isBoolean(Object object) {
        return object instanceof Boolean;
    }

    public static boolean isString(Object object) {
        return object instanceof String;
    }

    public static boolean isInteger(Object object) {
        return BasicFactory.isNumber(object) && ((Number)object).doubleValue() % 1.0 == 0.0;
    }

    public static boolean isArray(Object object) {
        return object instanceof JSONArray || object != null && object.getClass().isArray();
    }

    public static boolean isObject(Object object) {
        return object instanceof JSONObject;
    }

    public static String[] keySet(Object object) {
        if (object instanceof JSONObject) {
            Set set = ((JSONObject)object).keySet();
            return set.toArray(new String[set.size()]);
        }
        return null;
    }

    public static boolean containsKey(Object object, String string) {
        if (object instanceof JSONObject) {
            return ((JSONObject)object).containsKey((Object)string);
        }
        return false;
    }

    public static int[] makeSortOrder(final double[] dArray) {
        Integer[] integerArray = new Integer[dArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            integerArray[i] = new Integer(i);
        }
        Arrays.sort(integerArray, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return Double.compare(dArray[n], dArray[n2]);
            }
        });
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    public static JSONObject parse(Object object) throws IOException {
        if (object instanceof InputStream) {
            return JSONObject.parse((InputStream)((InputStream)object));
        }
        if (object instanceof Reader) {
            return JSONObject.parse((Reader)((Reader)object));
        }
        if (object instanceof byte[]) {
            return JSONObject.parse((InputStream)new ByteArrayInputStream((byte[])object));
        }
        if (object instanceof String) {
            return JSONObject.parse((String)((String)object));
        }
        return null;
    }

    public static JSONArtifact parseObjectOrArray(Object object) throws IOException {
        if (object instanceof InputStream) {
            return JSON.parse((InputStream)((InputStream)object));
        }
        if (object instanceof Reader) {
            return JSON.parse((Reader)((Reader)object));
        }
        if (object instanceof String) {
            return JSON.parse((String)((String)object));
        }
        return null;
    }

    public static void put(Object object, String string, Object object2) {
        ((JSONObject)object).put((Object)string, object2);
    }

    public static void remove(Object object, String string) {
        ((JSONObject)object).remove((Object)string);
    }

    public static void removeAt(JSONArray jSONArray, int n) {
        jSONArray.remove(n);
    }

    public static void removeFromArray(JSONArray jSONArray, Object object) {
        jSONArray.remove(object);
    }

    public static int size(JSONArray jSONArray) {
        return jSONArray.size();
    }

    public static void sortArray(Object[] objectArray) {
        Arrays.sort(objectArray);
    }

    public static void sortArray(int[] nArray) {
        Arrays.sort(nArray);
    }

    public static void sortArray(double[] dArray) {
        Arrays.sort(dArray);
    }

    public static <T> void sortList(List<? extends T> list, Comparator<T> comparator) {
        Collections.sort(list, comparator);
    }

    public static <T> List<T> asList(T[] TArray) {
        return Arrays.asList(TArray);
    }

    public static int compareTo(String string, String string2) {
        return string.compareTo(string2);
    }

    public static Double[] getHashMapKeysAsDoubleArray(HashMap hashMap) {
        Set set = hashMap.keySet();
        Double[] doubleArray = new Double[set.size()];
        doubleArray = set.toArray(doubleArray);
        return doubleArray;
    }

    public static Long[] getHashMapKeysAsLongArray(HashMap hashMap) {
        Set set = hashMap.keySet();
        Long[] longArray = new Long[set.size()];
        longArray = set.toArray(longArray);
        return longArray;
    }

    public static boolean isEqual(JSONArtifact jSONArtifact, JSONArtifact jSONArtifact2) {
        if (jSONArtifact == null) {
            return jSONArtifact2 == null;
        }
        return jSONArtifact.equals(jSONArtifact2);
    }

    public static Long makeLong(int n) {
        return new Long(n);
    }

    public static long getSystemTimer() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    public static long getUTCTime() {
        return System.currentTimeMillis();
    }

    public static boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    public static boolean isWhitespaceString(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPunctuation(String string, int n) {
        char c = string.charAt(n);
        boolean bl = c == '.' || c == ',' || c == ';' || c == '!' || c == '?' || c == ':';
        char c2 = n == 0 ? (char)' ' : (char)string.charAt(n - 1);
        char c3 = n == string.length() - 1 ? (char)' ' : (char)string.charAt(n + 1);
        return bl && (!BasicFactory.isNumerical(c2) || !BasicFactory.isNumerical(c3));
    }

    public static double parseDouble(String string) {
        try {
            double d = Double.parseDouble(string);
            if (Double.isInfinite(d)) {
                return Double.NaN;
            }
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    public static String codeToString(char c) {
        return new String(new char[]{c});
    }

    public static int charCodeAt(String string, int n) {
        return string.charAt(n);
    }

    public static boolean isNumerical(char c) {
        return c >= '0' && c <= '9';
    }

    public static char fromCharCode(int n) {
        return (char)n;
    }

    public static int getJSONArraySize(JSONArray jSONArray) {
        return jSONArray.size();
    }

    public static String replace(String string, String string2, String string3) {
        assert (string != null);
        assert (string2.length() > 0);
        assert (string3.length() > 0);
        return string.replace(string2, string3);
    }

    static {
        dfs.setExponentSeparator("e");
        dfs.setDecimalSeparator('.');
        unformattedDouble = new DecimalFormat("0.0#########", dfs);
        unformattedScientific = new DecimalFormat("0.0000000000E0", dfs);
    }
}

