/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.vis.engine.internal.nativeImpl.VisCommand;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class CancellableSingleThreadExecutor
extends ThreadPoolExecutor {
    private Runnable currentRunnable = null;
    private final Map<VisCommand, FutureTask> taskMap = new HashMap<VisCommand, FutureTask>();
    private final Map<FutureTask, VisCommand> commandMap = new HashMap<FutureTask, VisCommand>();

    public CancellableSingleThreadExecutor(ThreadFactory threadFactory) {
        super(1, 1, 1L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>());
        this.setThreadFactory(threadFactory);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        RunnableFuture<T> runnableFuture = super.newTaskFor(callable);
        this.taskMap.put((VisCommand)callable, (FutureTask)runnableFuture);
        this.commandMap.put((FutureTask)runnableFuture, (VisCommand)callable);
        return runnableFuture;
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        this.currentRunnable = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        Object object = this.currentRunnable;
        synchronized (object) {
            this.currentRunnable = null;
        }
        object = this.commandMap.get(runnable);
        this.commandMap.remove(runnable);
        this.taskMap.remove(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearQueue(boolean bl) {
        Runnable runnable = null;
        VisCommand visCommand = null;
        while ((runnable = (Runnable)this.getQueue().peek()) != null) {
            visCommand = this.commandMap.get(runnable);
            this.remove(runnable);
        }
        if (bl && this.currentRunnable != null) {
            Runnable runnable2 = this.currentRunnable;
            synchronized (runnable2) {
                if (this.currentRunnable != null) {
                    visCommand = this.commandMap.get(this.currentRunnable);
                    ((FutureTask)this.currentRunnable).cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean selectiveClearQueue(VisCommand.SubType subType) {
        Runnable runnable = null;
        VisCommand visCommand = null;
        while ((runnable = (Runnable)this.getQueue().peek()) != null) {
            visCommand = this.commandMap.get(runnable);
            this.remove(runnable);
        }
        if (this.currentRunnable != null) {
            Runnable runnable2 = this.currentRunnable;
            synchronized (runnable2) {
                if (this.currentRunnable != null) {
                    visCommand = this.commandMap.get(this.currentRunnable);
                    if (visCommand.subType() != subType) {
                        ((FutureTask)this.currentRunnable).cancel(true);
                    } else {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean remove(Runnable runnable) {
        VisCommand visCommand = this.commandMap.get(runnable);
        this.commandMap.remove(runnable);
        this.taskMap.remove(visCommand);
        return super.remove(runnable);
    }
}

