/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.LocaleUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class DateUtil {
    private final long EPOCH;
    private static final double OVERFLOW_CENTURY = 2777.777777;
    private static final double OVERFLOW_YEAR = 277777.777777;
    private static final double OVERFLOW_QUARTER = 1111111.111111;
    private static final double OVERFLOW_MONTH = 3333333.333333;
    private static final double OVERFLOW_WEEK = 1.4285714285714E7;
    private static final double OVERFLOW_DATE = 1.0E8;
    private static final double OVERFLOW_HOUR = 2.4E9;
    private static final double OVERFLOW_MINUTE = 1.44E11;
    private static final double OVERFLOW_SECOND = 8.64E12;
    private static final String DATE_PATTERN_SECOND = "h:mm:ss a";
    private static final String DATE_PATTERN_MINIUTE = "h:mm a";
    private static final String DATE_PATTERN_MONTH = "MMM yy";
    private static final String DATE_PATTERN_YEAR = "yyyy";
    private static final int FORMAT_TYPE_SECOND = 0;
    private static final int FORMAT_TYPE_MINUTE = 1;
    private static final int FORMAT_TYPE_HOUR = 2;
    private static final int FORMAT_TYPE_DAY = 3;
    private static final int FORMAT_TYPE_MONTH = 4;
    private static final int FORMAT_TYPE_YEAR = 5;
    public static DateUtil INSTANCE = new DateUtil();
    private final Map<String, DateFormat> formatSecondMap;
    private final Map<String, DateFormat> formatMinuteMap;
    private final Map<String, DateFormat> formatHourMap;
    private final Map<String, DateFormat> formatDayMap;
    private final Map<String, DateFormat> formatMonthMap;
    private final Map<String, DateFormat> formatYearMap;
    private final Map<String, DateFormat> formats;
    public static final String DEFAULT_TIMEZONE = "GMT";

    private DateUtil() {
        Calendar calendar = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)DEFAULT_TIMEZONE));
        calendar.clear();
        this.EPOCH = calendar.getTimeInMillis();
        this.formatSecondMap = new ConcurrentHashMap<String, DateFormat>(16, 0.75f, 1);
        this.formatMinuteMap = new ConcurrentHashMap<String, DateFormat>(16, 0.75f, 1);
        this.formatHourMap = new ConcurrentHashMap<String, DateFormat>(16, 0.75f, 1);
        this.formatDayMap = new ConcurrentHashMap<String, DateFormat>(16, 0.75f, 1);
        this.formatMonthMap = new ConcurrentHashMap<String, DateFormat>(16, 0.75f, 1);
        this.formatYearMap = new ConcurrentHashMap<String, DateFormat>(16, 0.75f, 1);
        this.formats = new ConcurrentHashMap<String, DateFormat>(16, 0.75f, 1);
    }

    public Object asDate(Object object) {
        if (object instanceof Calendar) {
            return object;
        }
        if (object instanceof Date) {
            Calendar calendar = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)DEFAULT_TIMEZONE));
            calendar.setTime((Date)object);
            return calendar;
        }
        return null;
    }

    public Object makeDate0() {
        Calendar calendar = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)DEFAULT_TIMEZONE));
        calendar.clear();
        return calendar;
    }

    public Object makeDate(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)DEFAULT_TIMEZONE));
        calendar.clear();
        calendar.set(n, n2 - 1, n3);
        return calendar;
    }

    public Object makeDateTime(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)DEFAULT_TIMEZONE));
        calendar.clear();
        calendar.set(n, n2 - 1, n3, n4, n5, n6);
        return calendar;
    }

    public Object copy(Object object) {
        return ((Calendar)object).clone();
    }

    public void setDate(Object object, int n, int n2, int n3) {
        Calendar calendar = (Calendar)object;
        calendar.clear();
        calendar.set(n, n2 - 1, n3, 0, 0, 0);
    }

    public void setDateTime(Object object, int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = (Calendar)object;
        calendar.clear();
        calendar.set(n, n2 - 1, n3, n4, n5, n6);
    }

    public Object toDate(double d, Unit unit, String string) {
        Calendar calendar = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)DEFAULT_TIMEZONE));
        calendar.clear();
        if (unit == Unit.DATE) {
            if (d > 1.0E8) {
                throw new EngineException("Date overflow error: " + d, ErrorCode.DATA_OVERFLOW, null);
            }
            calendar.add(5, (int)d);
            calendar.add(13, (int)Math.round((d - (double)((int)d)) * 24.0 * 3600.0));
        } else if (unit == Unit.CENTURY) {
            if (d > 2777.777777) {
                throw new EngineException("Date overflow error: " + d, ErrorCode.DATA_OVERFLOW, null);
            }
            calendar.add(1, (int)d * 100);
            calendar.add(13, (int)Math.round((d - (double)((int)d)) * 100.0 * 365.25 * 24.0 * 3600.0));
        } else if (unit == Unit.YEAR) {
            if (d > 277777.777777) {
                throw new EngineException("Date overflow error: " + d, ErrorCode.DATA_OVERFLOW, null);
            }
            calendar.add(1, (int)d);
            calendar.add(13, (int)Math.round((d - (double)((int)d)) * 365.25 * 24.0 * 3600.0));
        } else if (unit == Unit.QUARTER) {
            if (d > 1111111.111111) {
                throw new EngineException("Date overflow error: " + d, ErrorCode.DATA_OVERFLOW, null);
            }
            calendar.add(2, (int)d * 3);
            calendar.add(13, (int)Math.round((d - (double)((int)d)) * 91.3125 * 24.0 * 3600.0));
        } else if (unit == Unit.MONTH) {
            if (d > 3333333.333333) {
                throw new EngineException("Date overflow error: " + d, ErrorCode.DATA_OVERFLOW, null);
            }
            calendar.add(2, (int)d);
            calendar.add(13, (int)Math.round((d - (double)((int)d)) * 30.4375 * 24.0 * 3600.0));
        } else if (unit == Unit.WEEK) {
            if (d > 1.4285714285714E7) {
                throw new EngineException("Date overflow error: " + d, ErrorCode.DATA_OVERFLOW, null);
            }
            calendar.add(5, (int)d * 7);
            calendar.add(13, (int)Math.round((d - (double)((int)d)) * 7.0 * 24.0 * 3600.0));
        } else if (unit == Unit.HOUR) {
            if (d > 2.4E9) {
                throw new EngineException("Date overflow error: " + d, ErrorCode.DATA_OVERFLOW, null);
            }
            calendar.add(10, (int)d);
            calendar.add(13, (int)Math.round((d - (double)((int)d)) * 3600.0));
        } else if (unit == Unit.MINUTE) {
            if (d > 1.44E11) {
                throw new EngineException("Date overflow error: " + d, ErrorCode.DATA_OVERFLOW, null);
            }
            calendar.add(12, (int)d);
            calendar.add(13, (int)Math.round((d - (double)((int)d)) * 60.0));
        } else {
            if (d > 8.64E12) {
                throw new EngineException("Date overflow error: " + d, ErrorCode.DATA_OVERFLOW, null);
            }
            calendar = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)(string == null ? DEFAULT_TIMEZONE : string)));
            calendar.clear();
            calendar.setTimeInMillis(calendar.getTimeInMillis() + Math.round(d) * 1000L);
            calendar.add(14, calendar.get(15));
        }
        return calendar;
    }

    public double fromDateObject(Object object, Unit unit) {
        double d = Math.round((double)(((Calendar)object).getTimeInMillis() - this.EPOCH) / 1000.0);
        return unit == Unit.DATE ? d / 86400.0 : d;
    }

    public String getAxisTimeZone(String string, String string2) {
        return string;
    }

    public void increment(Object object, Unit unit, int n) {
        Calendar calendar = (Calendar)object;
        if (unit == Unit.CENTURY) {
            calendar.add(1, 100 * n);
        } else if (unit == Unit.YEAR) {
            calendar.add(1, n);
        } else if (unit == Unit.QUARTER) {
            calendar.add(2, 3 * n);
        } else if (unit == Unit.MONTH) {
            calendar.add(2, n);
        } else if (unit == Unit.WEEK) {
            calendar.add(5, 7 * n);
        } else if (unit == Unit.DAY) {
            calendar.add(5, n);
        } else if (unit == Unit.HOUR) {
            calendar.add(10, n);
        } else if (unit == Unit.MINUTE) {
            calendar.add(12, n);
        } else if (unit == Unit.SECOND) {
            calendar.add(13, n);
        }
    }

    public String formatDate(Object object, Unit unit, String string, String string2, String string3) {
        String string4;
        if (unit == Unit.CENTURY || unit == Unit.YEAR) {
            string4 = this.getFormattedValue(5, string2, object, string, string3);
        } else if (unit == Unit.QUARTER || unit == Unit.MONTH) {
            string4 = this.getFormattedValue(4, string2, object, string, string3);
        } else if (unit == Unit.WEEK || unit == Unit.DAY || unit == Unit.DATE) {
            string4 = this.getFormattedValue(3, string2, object, string, string3);
        } else if (unit == Unit.HOUR || unit == Unit.TIMESTAMP) {
            string4 = this.getFormattedValue(2, string2, object, string, string3);
        } else if (unit == Unit.MINUTE) {
            string4 = this.getFormattedValue(1, string2, object, string, string3);
        } else if (unit == Unit.SECOND) {
            string4 = this.getFormattedValue(0, string2, object, string, string3);
        } else {
            String string5 = unit.toString() + " : is an invalid Date Format";
            throw new EngineException(string5, ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedValue(int n, String string, Object object, String string2, String string3) {
        String string4;
        Date date = ((Calendar)object).getTime();
        Map<String, DateFormat> map = this.formatSecondMap;
        if (string == null) {
            string = LocaleUtil.getDefaultLocale();
        }
        if (string2 == null) {
            string2 = string.equals("zh_CN") ? "y\u5e74M\u6708" : DateUtil.getDefaultFormattingPattern(n);
        }
        if (n == 0) {
            map = this.formatSecondMap;
        } else if (n == 1) {
            map = this.formatMinuteMap;
        } else if (n == 2) {
            map = this.formatHourMap;
        } else if (n == 3) {
            map = this.formatDayMap;
        } else if (n == 4) {
            map = this.formatMonthMap;
        } else if (n == 5) {
            map = this.formatYearMap;
        }
        String string5 = string + "_" + string2;
        DateFormat dateFormat = map.get(string5);
        Locale locale = LocaleUtil.getLocaleFromString(string);
        if (dateFormat == null) {
            if (n == 3 && string2 == null) {
                dateFormat = DateFormat.getDateInstance((int)3, (Locale)locale);
            } else if (n == 2 && string2 == null) {
                dateFormat = DateFormat.getDateTimeInstance((int)3, (int)3, (Locale)locale);
            } else {
                dateFormat = DateFormat.getDateInstance((int)3, (Locale)locale);
                ((SimpleDateFormat)dateFormat).applyPattern(string2);
            }
            map.put(string5, dateFormat);
        }
        DateFormat dateFormat2 = dateFormat;
        synchronized (dateFormat2) {
            dateFormat.setCalendar((Calendar)new GregorianCalendar());
            dateFormat.setTimeZone(TimeZone.getTimeZone((String)(string3 == null ? DEFAULT_TIMEZONE : string3)));
            string4 = dateFormat.format(date);
        }
        return string4;
    }

    private static String getDefaultFormattingPattern(int n) {
        String string = null;
        if (n == 0) {
            string = DATE_PATTERN_SECOND;
        } else if (n == 1) {
            string = DATE_PATTERN_MINIUTE;
        } else if (n == 4) {
            string = DATE_PATTERN_MONTH;
        } else if (n == 5) {
            string = DATE_PATTERN_YEAR;
        }
        return string;
    }

    public void floorToUnitMultiple(Object object, Unit unit, int n) {
        Calendar calendar = (Calendar)object;
        int n2 = calendar.get(14);
        calendar.set(14, 0);
        if (n2 >= 500) {
            calendar.add(13, 1);
        }
        if (unit == Unit.CENTURY) {
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            calendar.set(5, 1);
            calendar.set(2, 0);
            calendar.set(1, calendar.get(1) / 100 / n * 100 * n);
        } else if (unit == Unit.YEAR) {
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            calendar.set(5, 1);
            calendar.set(2, 0);
            calendar.set(1, calendar.get(1) / n * n);
        } else if (unit == Unit.QUARTER) {
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            calendar.set(5, 1);
            calendar.set(2, calendar.get(2) / 3 / n * 3 * n);
        } else if (unit == Unit.MONTH) {
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            calendar.set(5, 1);
            calendar.set(2, (calendar.get(2) + 1) / n * n - 1);
        } else if (unit == Unit.WEEK) {
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            calendar.add(5, 1 - calendar.get(7));
        } else if (unit == Unit.DAY) {
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, 0);
            calendar.set(5, calendar.get(5) / n * n);
        } else if (unit == Unit.HOUR) {
            calendar.set(13, 0);
            calendar.set(12, 0);
            calendar.set(11, calendar.get(11) / n * n);
        } else if (unit == Unit.MINUTE) {
            calendar.set(13, 0);
            calendar.set(12, calendar.get(12) / n * n);
        } else if (unit == Unit.SECOND) {
            calendar.set(13, calendar.get(13) / n * n);
        } else {
            String string = "Unit parameter passed is not a valid date unit :" + unit.toString();
            throw new EngineException(string, ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
    }

    public static double fromDateString(String string, String string2, String string3) {
        DateFormat dateFormat;
        Date date = null;
        try {
            dateFormat = DateFormat.getDateInstance((int)3, (Locale)LocaleUtil.getLocaleFromString(string3));
            ((SimpleDateFormat)dateFormat).applyPattern(string);
            date = dateFormat.parse(string2);
        }
        catch (ParseException parseException) {
            throw new EngineException("invalid date format or date string", ErrorCode.ENGINE_FACET_INVALID_DATA, null);
        }
        dateFormat = Calendar.getInstance();
        dateFormat.setTime(date);
        Object object = INSTANCE.makeDate(dateFormat.get(1), dateFormat.get(2) + 1, dateFormat.get(5));
        return INSTANCE.fromDateObject(object, Unit.DATE);
    }

    public int getYear(Object object) {
        return ((Calendar)object).get(1);
    }

    public int getMonth(Object object) {
        return ((Calendar)object).get(2) + 1;
    }

    public int getDayOfMonth(Object object) {
        return ((Calendar)object).get(5);
    }

    public int getDayOfWeek(Object object) {
        return ((Calendar)object).get(7) - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormattedDate(Object object, String string, String string2) {
        String string3 = string2 + "_" + string;
        String string4 = null;
        DateUtil dateUtil = this;
        synchronized (dateUtil) {
            DateFormat dateFormat = this.formats.get(string3);
            if (dateFormat == null) {
                dateFormat = DateFormat.getDateInstance((int)3, (Locale)LocaleUtil.getLocaleFromString(string2));
                ((SimpleDateFormat)dateFormat).applyPattern(string);
                this.formats.put(string3, dateFormat);
            }
            string4 = dateFormat.format(((Calendar)object).getTime());
        }
        return string4;
    }
}

