/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.PrimitiveHashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class DoubleHashMap<T>
extends PrimitiveHashMap<T> {
    int tableLen;
    private DoubleEntry<T> nextEntry;

    public DoubleHashMap() {
        super(DEFAULT_INITIALSIZE);
        this.primitiveType = PRIMITIVE_TYPE_DOUBLE;
        this.tableLen = this.table.length;
    }

    @Override
    protected PrimitiveHashMap.Entry<T>[] createTable(int n) {
        return new DoubleEntry[n];
    }

    @Override
    public void initIterator() {
        this.nextEntry = null;
        DoubleEntry doubleEntry = null;
        this.hasNextEntry = false;
        for (int i = 0; doubleEntry == null && i < this.table.length; ++i) {
            doubleEntry = (DoubleEntry)this.table[i];
            if (doubleEntry == null) continue;
            this.nextEntry = doubleEntry;
            this.hasNextEntry = true;
            this.currentIndex = i;
        }
    }

    @Override
    public boolean iteratorHasNext() {
        return this.hasNextEntry;
    }

    public double getNextKey() {
        double d = 0.0;
        if (this.hasNextEntry) {
            d = this.nextEntry.key;
            this.nextEntry = this.getNextEntry();
            return d;
        }
        return 0.0;
    }

    public DoubleEntry<T> getNextEntry() {
        this.hasNextEntry = false;
        if (this.nextEntry.next != null) {
            this.nextEntry = (DoubleEntry)this.nextEntry.next;
            this.hasNextEntry = true;
            return this.nextEntry;
        }
        this.nextEntry = null;
        ++this.currentIndex;
        while (this.nextEntry == null && this.currentIndex < this.table.length) {
            this.nextEntry = (DoubleEntry)this.table[this.currentIndex];
            if (this.nextEntry != null) {
                this.hasNextEntry = true;
                return this.nextEntry;
            }
            ++this.currentIndex;
        }
        return null;
    }

    public boolean containsKey(double d) {
        DoubleEntry[] doubleEntryArray = (DoubleEntry[])this.table;
        int n = this.createHash(d);
        DoubleEntry doubleEntry = doubleEntryArray[n];
        while (doubleEntry != null) {
            if (doubleEntry.key == d) {
                return true;
            }
            doubleEntry = (DoubleEntry)doubleEntry.next;
        }
        return false;
    }

    public T get(double d) {
        DoubleEntry[] doubleEntryArray = (DoubleEntry[])this.table;
        int n = this.createHash(d);
        DoubleEntry doubleEntry = doubleEntryArray[n];
        while (doubleEntry != null) {
            if (doubleEntry.key == d) {
                return (T)doubleEntry.value;
            }
            doubleEntry = (DoubleEntry)doubleEntry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        DoubleEntry[] doubleEntryArray = (DoubleEntry[])this.table;
        int n2 = n * 2 + 1;
        DoubleEntry[] doubleEntryArray2 = new DoubleEntry[n2];
        this.tableLen = n2;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = doubleEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            DoubleEntry doubleEntry = doubleEntryArray[n3];
            while (doubleEntry != null) {
                DoubleEntry doubleEntry2 = doubleEntry;
                doubleEntry = (DoubleEntry)doubleEntry.next;
                int n4 = this.createHash(doubleEntry2.key);
                doubleEntry2.next = doubleEntryArray2[n4];
                doubleEntryArray2[n4] = doubleEntry2;
            }
        }
    }

    public T put(double d, T t) {
        DoubleEntry[] doubleEntryArray = (DoubleEntry[])this.table;
        int n = this.createHash(d);
        DoubleEntry<T> doubleEntry = doubleEntryArray[n];
        while (doubleEntry != null) {
            if (doubleEntry.key == d) {
                Object object = doubleEntry.value;
                doubleEntry.value = t;
                return (T)object;
            }
            doubleEntry = (DoubleEntry)doubleEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            doubleEntryArray = (DoubleEntry[])this.table;
            n = this.createHash(d);
        }
        doubleEntryArray[n] = doubleEntry = new DoubleEntry<T>(d, t, doubleEntryArray[n]);
        ++this.count;
        return null;
    }

    public T remove(double d) {
        DoubleEntry[] doubleEntryArray = (DoubleEntry[])this.table;
        int n = this.createHash(d);
        DoubleEntry doubleEntry = doubleEntryArray[n];
        DoubleEntry doubleEntry2 = null;
        while (doubleEntry != null) {
            if (doubleEntry.key == d) {
                if (doubleEntry2 != null) {
                    doubleEntry2.next = doubleEntry.next;
                } else {
                    doubleEntryArray[n] = (DoubleEntry)doubleEntry.next;
                }
                --this.count;
                Object object = doubleEntry.value;
                doubleEntry.value = null;
                return (T)object;
            }
            doubleEntry2 = doubleEntry;
            doubleEntry = (DoubleEntry)doubleEntry.next;
        }
        return null;
    }

    private int createHash(double d) {
        long l = Double.doubleToLongBits(d);
        int n = (int)(l ^ l >>> 32);
        return (n & Integer.MAX_VALUE) % this.tableLen;
    }

    public static class DoubleEntry<T>
    extends PrimitiveHashMap.Entry<T> {
        public double key;

        protected DoubleEntry(double d, T t, PrimitiveHashMap.Entry<T> entry) {
            super(t, entry);
            this.key = d;
        }
    }
}

