/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FontUtil {
    private static final String FONT_FAMILY_SEPARATOR = ",";
    private static final String DEFAULT_FONT_NAME = "Arial";
    public static final Font DEFAULT_FONT = new Font("Arial", 0, 12);
    public static final String DEFAULT_FALLBACK_FONT_NAME = "Dialog";
    private static final HashMap<String, String> FONTS = new HashMap();

    public static String getFontFamily(String string) {
        String[] stringArray;
        if (string == null) {
            return DEFAULT_FONT_NAME;
        }
        String string2 = string + FONT_FAMILY_SEPARATOR;
        for (String string3 : stringArray = string2.split(FONT_FAMILY_SEPARATOR)) {
            String string4 = FONTS.get(string3.toLowerCase().trim());
            if (string4 == null) continue;
            return string4;
        }
        return DEFAULT_FONT_NAME;
    }

    public static Map<AttributedCharacterIterator.Attribute, Object> populateFontAttributes(String string, double d, boolean bl, String string2) {
        boolean bl2;
        HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        hashMap.put(TextAttribute.FAMILY, FontUtil.getFontFamily(string));
        hashMap.put(TextAttribute.SIZE, new Double(d));
        if (bl) {
            hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        boolean bl3 = bl2 = string2 != null && string2.equals("italic");
        if (bl2) {
            hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        return hashMap;
    }

    private static Font createFallbackFont(Font font) {
        return font.deriveFont(Collections.singletonMap(TextAttribute.FAMILY, DEFAULT_FALLBACK_FONT_NAME));
    }

    public static boolean replaceLimitedFonts(AttributedString attributedString, String string, Font font) {
        boolean bl = false;
        int n = font.canDisplayUpTo(string);
        if (n >= 0) {
            Font font2 = FontUtil.createFallbackFont(font);
            if (n == 0 && font2.canDisplayUpTo(string) < 0) {
                attributedString.addAttribute(TextAttribute.FONT, font2);
                bl = true;
            } else {
                while (n < string.length()) {
                    int n2 = FontUtil.getSubstituteRun(string, n, font, font2);
                    if (n2 > n) {
                        attributedString.addAttribute(TextAttribute.FONT, font2, n, n2);
                        bl = true;
                    }
                    n = Math.max(n2, n + 1);
                }
            }
        }
        return bl;
    }

    private static int getSubstituteRun(String string, int n, Font font, Font font2) {
        int n2;
        for (n2 = n; n2 < string.length() && !font.canDisplay(string.charAt(n2)) && font2.canDisplay(string.charAt(n2)); ++n2) {
        }
        return n2;
    }

    static {
        for (String string : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            FONTS.put(string.toLowerCase(), string);
        }
    }
}

