/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.LocaleUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FormatObject {
    public static final String CUSTOM_FORMAT = "custom_format";
    public static final String ZERO_FORMAT = "zero_format";
    public static final String NEGATIVE_FORMAT = "negative_format";
    public static final String NO_SPACE_FORMAT = "no_space_format";
    public static final String DEFAULT_FORMAT = "default_format";
    public static final String SPACE = " ";
    public static final String SCIENTIFIC_FORMAT = "scientific_format";
    public static final String NEGATIVE_SCIENTIFIC_FORMAT = "negative_scientific_format";
    public static final String ZERO_SCIENTIFIC_FORMAT = "zero_scientific_format";
    private final String locale;
    private final Map<String, DecimalFormat> formatterMap;
    private final String type;
    private final String pattern;
    private boolean useSymbolsForJson;

    public FormatObject(String string, String string2, String string3, boolean bl) {
        this.type = string;
        this.pattern = string2;
        this.useSymbolsForJson = bl;
        this.locale = string3 == null ? LocaleUtil.getDefaultLocale() : string3;
        this.formatterMap = new HashMap<String, DecimalFormat>();
        this.updateFormatterMap();
    }

    private void updateFormatterMap() {
        String string;
        if (this.isNoSpaceFormat()) {
            return;
        }
        Locale locale = LocaleUtil.getLocaleFromString(this.locale);
        DecimalFormat decimalFormat = this.formatterMap.get(this.locale);
        if (decimalFormat == null) {
            decimalFormat = (DecimalFormat)NumberFormat.getNumberInstance((Locale)locale);
            this.formatterMap.put(this.locale, decimalFormat);
        }
        if (this.useSymbolsForJson) {
            decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance((Locale)locale));
        }
        if (this.pattern != null && !(string = this.pattern.replace("?", "#")).equals(decimalFormat.toPattern())) {
            decimalFormat.applyPattern(string);
        }
    }

    public String format(Number number) {
        DecimalFormat decimalFormat;
        if (this.isNoSpaceFormat()) {
            return this.pattern;
        }
        if (number.doubleValue() < 0.0 && (NEGATIVE_FORMAT.equals(this.type) || NEGATIVE_SCIENTIFIC_FORMAT.equals(this.type))) {
            number = 0.0 - number.doubleValue();
        }
        String string = (decimalFormat = this.formatterMap.get(this.locale)) != null ? decimalFormat.format((Object)number) : "";
        return this.addLeadingOrTrailingSpaces(string);
    }

    private String addLeadingOrTrailingSpaces(String string) {
        int n;
        String string2 = "";
        int n2 = this.getNumOfSpacesRequired(this.getPart(string, false).length(), false);
        int n3 = this.getNumOfSpacesRequired(this.getPart(string, true).length(), true);
        for (n = 0; n < n2; ++n) {
            string2 = string2 + SPACE;
        }
        string2 = string2 + string;
        for (n = 0; n < n3; ++n) {
            string2 = string2 + SPACE;
        }
        return string2;
    }

    private int getNumOfSpacesRequired(int n, boolean bl) {
        int n2;
        block4: {
            String string = this.getPart(this.pattern, bl);
            n2 = 0;
            if (string.length() <= n) break block4;
            char[] cArray = string.toCharArray();
            if (bl) {
                for (int i = n; i < string.length(); ++i) {
                    if (cArray[i] != '?') continue;
                    ++n2;
                }
            } else {
                for (int i = 0; i < string.length() - n; ++i) {
                    if (cArray[i] != '?') continue;
                    ++n2;
                }
            }
        }
        return n2;
    }

    private String getPart(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf(".");
        if (n < 0) {
            return bl ? "" : string;
        }
        return bl ? string.substring(n + 1, string.length()) : string.substring(0, n);
    }

    public boolean isNoSpaceFormat() {
        return NO_SPACE_FORMAT.equals(this.type);
    }

    public String getType() {
        return this.type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isUseSymbolsForJson() {
        return this.useSymbolsForJson;
    }

    public void setUseSymbolsForJson(boolean bl) {
        this.useSymbolsForJson = bl;
    }
}

