/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.PrimitiveHashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class IntHashMap<T>
extends PrimitiveHashMap<T> {
    private IntEntry<T> nextEntry;

    public IntHashMap() {
        super(DEFAULT_INITIALSIZE);
        this.primitiveType = PRIMITIVE_TYPE_INTEGER;
    }

    @Override
    protected PrimitiveHashMap.Entry<T>[] createTable(int n) {
        return new IntEntry[n];
    }

    @Override
    public void initIterator() {
        this.nextEntry = null;
        IntEntry intEntry = null;
        this.hasNextEntry = false;
        for (int i = 0; intEntry == null && i < this.table.length; ++i) {
            intEntry = (IntEntry)this.table[i];
            if (intEntry == null) continue;
            this.nextEntry = intEntry;
            this.hasNextEntry = true;
            this.currentIndex = i;
        }
    }

    public int getNextKey() {
        int n = 0;
        if (this.hasNextEntry) {
            n = this.nextEntry.key;
            this.nextEntry = this.getNextEntry();
            return n;
        }
        return 0;
    }

    public IntEntry<T> getNextEntry() {
        this.hasNextEntry = false;
        if (this.nextEntry.next != null) {
            this.nextEntry = (IntEntry)this.nextEntry.next;
            this.hasNextEntry = true;
            return this.nextEntry;
        }
        this.nextEntry = null;
        ++this.currentIndex;
        while (this.nextEntry == null && this.currentIndex < this.table.length) {
            this.nextEntry = (IntEntry)this.table[this.currentIndex];
            if (this.nextEntry != null) {
                this.hasNextEntry = true;
                return this.nextEntry;
            }
            ++this.currentIndex;
        }
        return null;
    }

    public boolean containsKey(int n) {
        IntEntry[] intEntryArray = (IntEntry[])this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intEntryArray.length;
        IntEntry intEntry = intEntryArray[n3];
        while (intEntry != null) {
            if (intEntry.key == n2) {
                return true;
            }
            intEntry = (IntEntry)intEntry.next;
        }
        return false;
    }

    public T get(int n) {
        IntEntry[] intEntryArray = (IntEntry[])this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intEntryArray.length;
        IntEntry intEntry = intEntryArray[n3];
        while (intEntry != null) {
            if (intEntry.key == n2) {
                return (T)intEntry.value;
            }
            intEntry = (IntEntry)intEntry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        IntEntry[] intEntryArray = (IntEntry[])this.table;
        int n2 = n * 2 + 1;
        IntEntry[] intEntryArray2 = new IntEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = intEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            IntEntry intEntry = intEntryArray[n3];
            while (intEntry != null) {
                IntEntry intEntry2 = intEntry;
                intEntry = (IntEntry)intEntry.next;
                int n4 = (intEntry2.key & Integer.MAX_VALUE) % n2;
                intEntry2.next = intEntryArray2[n4];
                intEntryArray2[n4] = intEntry2;
            }
        }
    }

    public T put(int n, T t) {
        IntEntry[] intEntryArray = (IntEntry[])this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intEntryArray.length;
        IntEntry<T> intEntry = intEntryArray[n3];
        while (intEntry != null) {
            if (intEntry.key == n2) {
                Object object = intEntry.value;
                intEntry.value = t;
                return (T)object;
            }
            intEntry = (IntEntry)intEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            intEntryArray = (IntEntry[])this.table;
            n3 = (n2 & Integer.MAX_VALUE) % intEntryArray.length;
        }
        intEntryArray[n3] = intEntry = new IntEntry<T>(n, t, intEntryArray[n3]);
        ++this.count;
        return null;
    }

    public T remove(int n) {
        IntEntry[] intEntryArray = (IntEntry[])this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intEntryArray.length;
        IntEntry intEntry = intEntryArray[n3];
        IntEntry intEntry2 = null;
        while (intEntry != null) {
            if (intEntry.key == n2) {
                if (intEntry2 != null) {
                    intEntry2.next = intEntry.next;
                } else {
                    intEntryArray[n3] = (IntEntry)intEntry.next;
                }
                --this.count;
                Object object = intEntry.value;
                intEntry.value = null;
                return (T)object;
            }
            intEntry2 = intEntry;
            intEntry = (IntEntry)intEntry.next;
        }
        return null;
    }

    public static class IntEntry<T>
    extends PrimitiveHashMap.Entry<T> {
        public int key;

        protected IntEntry(int n, T t, PrimitiveHashMap.Entry<T> entry) {
            super(t, entry);
            this.key = n;
        }
    }
}

