/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.spec.internal.LocalizationSpec;
import java.util.Locale;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class LocaleUtil {
    public static Locale getLocaleFromString(String string) {
        if (string == null) {
            return Locale.getDefault();
        }
        if ((string = string.trim()).toLowerCase().equals("default")) {
            return Locale.getDefault();
        }
        int n = string.indexOf(95);
        String string2 = null;
        if (n == -1) {
            return new Locale(string, "");
        }
        string2 = string.substring(0, n);
        int n2 = string.indexOf(95, n + 1);
        String string3 = null;
        if (n2 == -1) {
            string3 = string.substring(n + 1);
            return new Locale(string2, string3);
        }
        string3 = string.substring(n + 1, n2);
        String string4 = string.substring(n2 + 1);
        return new Locale(string2, string3, string4);
    }

    public static String getExponentSeparator(String string) {
        Locale locale = LocaleUtil.getLocaleFromString(string);
        String string2 = DecimalFormatSymbols.getInstance((Locale)locale).getExponentSeparator();
        if (string2 == null) {
            string2 = "E";
        }
        return string2;
    }

    public static String getDefaultLocale() {
        return "en_US";
    }

    public static boolean isValid(String string) {
        Locale[] localeArray;
        String string2 = string.equals("he") ? "iw" : string;
        for (Locale locale : localeArray = Locale.getAvailableLocales()) {
            if (!string2.equals(locale.toString())) continue;
            return true;
        }
        return false;
    }

    public static String getLocaleStringFromSpec(LocalizationSpec localizationSpec) {
        String string = null;
        if (localizationSpec != null && localizationSpec.locale != null) {
            string = localizationSpec.locale;
        }
        return string;
    }
}

