/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.internal.AbstractMappedJSONObject;
import com.ibm.vis.internal.SpecVar;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class MappedJSONObject
extends AbstractMappedJSONObject {
    private static final String SPEC_PACKAGE = "com.ibm.vis.spec.internal.";
    private static Map<Class<? extends MappedJSONObject>, Map<String, Field>> classFields = new ConcurrentHashMap<Class<? extends MappedJSONObject>, Map<String, Field>>(16, 0.75f, 1);

    @Override
    protected Integer[] toIntegerArray(JSONArray jSONArray) {
        Integer[] integerArray = new Integer[jSONArray.size()];
        for (int i = 0; i < integerArray.length; ++i) {
            Object object = jSONArray.get(i);
            if (!(object instanceof Integer)) continue;
            integerArray[i] = (Integer)jSONArray.get(i);
        }
        return integerArray;
    }

    @Override
    protected String[] toStringArray(JSONArray jSONArray) {
        Object[] objectArray = new String[jSONArray.size()];
        jSONArray.toArray(objectArray);
        return objectArray;
    }

    @Override
    protected Boolean[] toBooleanArray(JSONArray jSONArray) {
        Boolean[] booleanArray = new Boolean[jSONArray.size()];
        for (int i = 0; i < booleanArray.length; ++i) {
            booleanArray[i] = (Boolean)jSONArray.get(i);
        }
        return booleanArray;
    }

    @Override
    protected Object toNumberArray(JSONArray jSONArray, boolean bl) {
        Number[] numberArray = new Number[jSONArray.size()];
        Number[][] numberArrayArray = new Number[jSONArray.size()][];
        for (int i = 0; i < numberArray.length; ++i) {
            Object object = jSONArray.get(i);
            if (object instanceof Number) {
                numberArray[i] = (Number)jSONArray.get(i);
                continue;
            }
            if (!(object instanceof JSONArray)) continue;
            numberArrayArray[i] = (Number[])this.toNumberArray((JSONArray)object, false);
        }
        return bl ? numberArrayArray : numberArray;
    }

    @Override
    protected Object toObjectArray(JSONArray jSONArray, String string, String string2) throws IllegalAccessException, InstantiationException {
        Object object;
        boolean bl = "object".equalsIgnoreCase(string);
        Class<?> clazz = null;
        try {
            object = bl ? "java.lang.Object" : SPEC_PACKAGE + string;
            clazz = Class.forName((String)object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        object = Array.newInstance(clazz, jSONArray.size());
        for (int i = 0; i < jSONArray.size(); ++i) {
            Object object2;
            Object object3 = jSONArray.get(i);
            if (BasicFactory.isString(object3) || BasicFactory.isNumber(object3) || BasicFactory.isBoolean(object3)) {
                Array.set(object, i, object3);
                continue;
            }
            if (bl) {
                object2 = this.getDynamicType(string2, (JSONArtifact)((JSONObject)object3));
                try {
                    clazz = Class.forName(SPEC_PACKAGE + (String)object2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            object2 = (MappedJSONObject)clazz.newInstance();
            ((AbstractMappedJSONObject)object2).setJSON((JSONObject)object3);
            Array.set(object, i, object2);
        }
        return object;
    }

    @Override
    protected Object getFieldValue(SpecVar specVar) {
        Object object = null;
        try {
            Field field = (Field)specVar.getNativeCache();
            if (field == null) {
                field = this.getClass().getField(specVar.getName());
                specVar.setNativeCache(field);
            }
            object = field.get(this);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return object;
    }

    @Override
    protected void setFieldValue(SpecVar specVar, Object object, Object object2) {
        Field field = (Field)specVar.getNativeCache();
        try {
            field.set(object, object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    protected void set(String string, Object object) {
        try {
            Field field;
            Class<?> clazz = this.getClass();
            Map<String, Field> map = classFields.get(clazz);
            if (map == null) {
                map = new ConcurrentHashMap<String, Field>();
                classFields.put(clazz, map);
            }
            if ((field = map.get(string)) == null) {
                field = clazz.getField(string);
                map.put(string, field);
            }
            field.set(this, object);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static void register(String string, Class<?> clazz) {
    }

    @Override
    protected MappedJSONObject createInstance() {
        MappedJSONObject mappedJSONObject = null;
        try {
            mappedJSONObject = (MappedJSONObject)this.getClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return mappedJSONObject;
    }

    public final JSONObject toJSON() {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        JSONObject jSONObject = new JSONObject();
        for (Field field : fieldArray) {
            Object object;
            if (!Modifier.isPublic(field.getModifiers())) continue;
            String string = field.getName();
            Class<?> clazz = field.getType();
            boolean bl = clazz.isArray();
            Object object2 = null;
            try {
                object2 = field.get(this);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            if (object2 == null) {
                jSONObject.remove((Object)string);
                continue;
            }
            if (object2 instanceof MappedJSONObject[]) {
                object = (JSONArray)object2;
                if (!(jSONObject.get((Object)string) instanceof JSONArray) && !bl) continue;
                JSONArray jSONArray = new JSONArray();
                for (Object object3 : object) {
                    jSONArray.add((Object)((MappedJSONObject)object3).toJSON());
                }
                jSONObject.put((Object)string, (Object)jSONArray);
                continue;
            }
            if (object2 instanceof Object[]) {
                object = MappedJSONObject.writeArray((Object[])object2);
                jSONObject.put((Object)string, object);
                continue;
            }
            if (object2 instanceof MappedJSONObject) {
                object = (MappedJSONObject)object2;
                jSONObject.put((Object)string, (Object)((MappedJSONObject)object).toJSON());
                continue;
            }
            jSONObject.put((Object)string, object2);
        }
        return jSONObject;
    }

    private static JSONArray writeArray(Object[] objectArray) {
        JSONArray jSONArray = new JSONArray();
        for (Object object : objectArray) {
            if (object instanceof double[]) {
                double[] dArray = (double[])object;
                jSONArray.add((Object)MappedJSONObject.writePrimitiveArray(dArray));
                continue;
            }
            if (object instanceof Object[]) {
                jSONArray.add((Object)MappedJSONObject.writeArray((Object[])object));
                continue;
            }
            if (object instanceof MappedJSONObject) {
                jSONArray.add((Object)((MappedJSONObject)object).toJSON());
                continue;
            }
            jSONArray.add(object);
        }
        return jSONArray;
    }

    private static JSONArray writePrimitiveArray(double[] dArray) {
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < dArray.length; ++i) {
            jSONArray.add((Object)dArray[i]);
        }
        return jSONArray;
    }

    @Override
    public MappedJSONObject createSpecInstance(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return MappedJSONObject.createSpecInstanceFromType(string);
    }

    public static MappedJSONObject createSpecInstanceFromType(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(SPEC_PACKAGE + string);
        return (MappedJSONObject)clazz.newInstance();
    }

    @Override
    protected Object cloneField(Object object, boolean bl) {
        if (object instanceof MappedJSONObject) {
            MappedJSONObject mappedJSONObject = (MappedJSONObject)object;
            return mappedJSONObject.copy();
        }
        if (bl) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])objectArray.clone();
            for (Object object2 : objectArray) {
                if (!(object2 instanceof MappedJSONObject)) continue;
                objectArray2[var5_6] = ((MappedJSONObject)object2).copy();
            }
            return objectArray2;
        }
        return object;
    }

    public static double[][] toDoubleArray(JSONArray jSONArray) {
        if (jSONArray == null) {
            return null;
        }
        int n = jSONArray.size();
        if (n == 0) {
            return new double[0][0];
        }
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            JSONArray jSONArray2 = (JSONArray)jSONArray.get(i);
            int n2 = jSONArray2.size();
            dArrayArray[i] = new double[n2];
            for (int j = 0; j < n2; ++j) {
                Object object = jSONArray2.get(j);
                dArrayArray[i][j] = object instanceof Number ? ((Number)object).doubleValue() : Double.NaN;
            }
        }
        return dArrayArray;
    }
}

