/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.vis.engine.internal.grammar.label.NativeFontMetric;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.FontUtil;
import com.ibm.vis.engine.internal.scene.FontHeightMetrics;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class NativeTextMeasure {
    private static FontRenderContext frc;
    private static String sample;

    private static FontRenderContext getFRC(boolean bl) {
        if (frc == null || frc.usesFractionalMetrics() != bl) {
            frc = new FontRenderContext(null, false, bl);
        }
        return frc;
    }

    private static Font getAWTFont(com.ibm.vis.engine.internal.scene.Font font, String string) {
        AttributedString attributedString = new AttributedString(string);
        Map<AttributedCharacterIterator.Attribute, Object> map = FontUtil.populateFontAttributes(font.getFamily(), font.getSize(), font.getBold(), font.getStyle());
        Font font2 = new Font(map);
        if (FontUtil.replaceLimitedFonts(attributedString, string, font2)) {
            map.put(TextAttribute.FAMILY, "Dialog");
            font2 = new Font(map);
        }
        return font2;
    }

    public static TextLayout getTextLayout(com.ibm.vis.engine.internal.scene.Font font, String string) {
        if (string == null || string.length() == 0) {
            string = " ";
        }
        Font font2 = NativeTextMeasure.getAWTFont(font, string);
        FontRenderContext fontRenderContext = NativeTextMeasure.getFRC(font.usesFractionalMetrics());
        TextLayout textLayout = new TextLayout(string, font2, fontRenderContext);
        return textLayout;
    }

    public static double getWidth(com.ibm.vis.engine.internal.scene.Font font, String string) {
        if (string == null || string.length() == 0) {
            return 0.0;
        }
        double d = NativeTextMeasure.getTextLayout(font, string).getAdvance();
        ((NativeFontMetric)font.getMetric()).getFontStats().updAvg(d / (double)string.length());
        return d;
    }

    public static double getAscent(com.ibm.vis.engine.internal.scene.Font font) {
        return -NativeTextMeasure.getTextLayout(font, sample).getBounds().getY();
    }

    public static double getHeight(com.ibm.vis.engine.internal.scene.Font font) {
        return NativeTextMeasure.getTextLayout(font, sample).getBounds().getHeight();
    }

    public static double getAccessibleMinimumFontSize() {
        return 0.0;
    }

    public static FontHeightMetrics getFontHeightMetrics(com.ibm.vis.engine.internal.scene.Font font, String string) {
        TextLayout textLayout = NativeTextMeasure.getTextLayout(font, string);
        double d = -textLayout.getBounds().getY();
        double d2 = textLayout.getBounds().getHeight();
        return new FontHeightMetrics(d, d2 - d);
    }

    static {
        sample = "\u00c2j";
    }
}

