/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class PrimitiveHashMap<T> {
    public static int PRIMITIVE_TYPE_INTEGER = 1;
    public static int PRIMITIVE_TYPE_LONG = 2;
    public static int PRIMITIVE_TYPE_FLOAT = 3;
    public static int PRIMITIVE_TYPE_DOUBLE = 4;
    protected static float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static int DEFAULT_INITIALSIZE = 20;
    protected int primitiveType;
    protected transient Entry<T>[] table;
    protected transient int count;
    protected int threshold;
    protected float loadFactor = DEFAULT_LOAD_FACTOR;
    protected boolean hasNextEntry;
    protected int currentIndex;

    public PrimitiveHashMap(int n) {
        this.table = this.createTable(n);
        this.threshold = (int)((float)n * this.loadFactor);
    }

    public void initIterator() {
    }

    public boolean iteratorHasNext() {
        return this.hasNextEntry;
    }

    public int getType() {
        return this.primitiveType;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    protected Entry<T>[] createTable(int n) {
        return new Entry[n];
    }

    public void clear() {
        Entry<T>[] entryArray = this.table;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    protected static class Entry<T> {
        public T value;
        public Entry<T> next;

        protected Entry(T t, Entry<T> entry) {
            this.value = t;
            this.next = entry;
        }
    }
}

