/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.Version;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ResourceUtil {
    public static JSONArray getFontMetricsArray() throws IOException {
        return (JSONArray)ResourceUtil.loadJSONResource("metrics.json");
    }

    public static JSONArray getDeclarativeSpecMigrationStrategies() throws IOException {
        return (JSONArray)ResourceUtil.loadJSONResource("/resources/migration.json");
    }

    public static JSONObject getRaveSchema(Version version) throws IOException {
        if (version.equals(Version.parseVersion("7.2"))) {
            return (JSONObject)ResourceUtil.loadJSONResource("/resources/raveSchema.json");
        }
        return (JSONObject)ResourceUtil.loadJSONResource("/resources/raveSchema" + version.toString().replace(".", "_") + ".json");
    }

    private static JSONArtifact loadJSONResource(String string) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = BasicFactory.class.getResourceAsStream(string);
            JSONArtifact jSONArtifact = inputStream != null ? JSON.parse((InputStream)inputStream) : null;
            return jSONArtifact;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static URL getResourceURL(String string) {
        return BasicFactory.class.getResource("/resources/" + string);
    }
}

