/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.text.AttributedString;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TextRaster {
    private BufferedImage image;
    private final Dim size;
    private byte[] imageData;
    private Graphics2D g2D;

    public TextRaster(Dim dim) {
        assert (dim != null);
        this.size = dim;
        int n = (int)dim.getWidth();
        int n2 = (int)dim.getHeight();
        this.image = new BufferedImage(n, n2, 10);
        this.g2D = this.image.createGraphics();
        this.g2D.setColor(Color.BLACK);
        this.g2D.fillRect(0, 0, n, n2);
    }

    public final Dim getSize() {
        return this.size;
    }

    private void place(Text text, Point point, double d, Rect rect, Point point2) {
        String string;
        if (text != null && (string = text.getText()).length() > 0) {
            if (point2 != null) {
                this.g2D.translate(point2.getX(), point2.getY());
            }
            AttributedString attributedString = new AttributedString(text.getText());
            int n = 0;
            if (text.getFont().getBold()) {
                n |= 1;
            }
            if ("italic".equals(text.getFont().getStyle())) {
                n |= 2;
            }
            Font font = new Font(text.getFont().getFamily(), n, (int)text.getFont().getSize());
            attributedString.addAttribute(TextAttribute.FONT, font);
            attributedString.addAttribute(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            this.g2D.setColor(Color.WHITE);
            if (d != 0.0) {
                this.g2D.rotate(d, point.getX(), point.getY());
            }
            this.g2D.drawString(attributedString.getIterator(), (int)point.getX(), (int)point.getY());
            if (rect != null) {
                this.g2D.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            }
        }
    }

    public void placeText(Text text, Point point, double d, Rect rect) {
        this.place(text, point, d, rect, null);
    }

    public void placeTextRaster(TextRaster textRaster, Point point) {
        byte[] byArray = textRaster.getImageData();
        byte[] byArray2 = this.getImageData();
        int n = (int)point.getX();
        int n2 = (int)point.getY();
        int n3 = (int)textRaster.size.getWidth();
        int n4 = (int)textRaster.size.getHeight();
        int n5 = (int)this.size.getWidth();
        int n6 = n5 * n2 + n;
        for (int i = 0; i < n4; ++i) {
            int n7 = i * n3;
            int n8 = i * n5 + n6;
            for (int j = 0; j < n3; ++j) {
                int n9 = n8 + j;
                byArray2[n9] = (byte)(byArray2[n9] | byArray[n7 + j]);
            }
        }
    }

    private void refreshImageData() {
        int n = (int)this.size.getWidth() * (int)this.size.getHeight();
        byte[] byArray = new byte[n];
        DataBuffer dataBuffer = this.image.getData().getDataBuffer();
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)dataBuffer.getElem(i);
        }
        this.imageData = byArray;
    }

    private byte[] getImageData() {
        if (this.imageData == null) {
            if (this.image != null) {
                this.refreshImageData();
            } else {
                this.imageData = new byte[(int)this.size.getWidth() * (int)this.size.getHeight()];
            }
        }
        return this.imageData;
    }

    public boolean collidesWith(TextRaster textRaster, Rect rect) {
        byte[] byArray = this.getImageData();
        byte[] byArray2 = textRaster.getImageData();
        int n = (int)rect.getX();
        int n2 = (int)rect.getWidth();
        int n3 = (int)rect.getHeight();
        int n4 = n + (int)rect.getY() * (int)textRaster.size.getWidth();
        int n5 = 1;
        for (int i = 0; i < n3; ++i) {
            int n6 = i * n2;
            int n7 = i * (int)textRaster.size.getWidth() + n4;
            for (int j = n5; j < n2; j += 2) {
                int n8 = byArray[n6 + j] & byArray2[n7 + j];
                if (n8 == 0) continue;
                return true;
            }
            n5 = n5 == 1 ? 0 : 1;
        }
        return false;
    }

    public void dispose() {
        this.g2D.dispose();
    }
}

