/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.InteractivityCommand;
import com.ibm.vis.engine.internal.nativeImpl.VisCommandExecutor;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.VisException;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.interaction.internal.InteractivityWrapper;
import com.ibm.vis.monitor.LogComponent;
import com.ibm.vis.monitor.LogLevel;
import com.ibm.vis.monitor.internal.LoggerImpl;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ThreadHelper {
    private final VisCommandExecutor executor;
    private final LoggerImpl logger;
    private final boolean localExecutor;

    public ThreadHelper(VisCommandExecutor visCommandExecutor, LoggerImpl loggerImpl) {
        if (visCommandExecutor == null) {
            this.localExecutor = true;
            this.executor = VisCommandExecutor.newInstance();
        } else {
            this.localExecutor = false;
            this.executor = visCommandExecutor;
        }
        this.logger = loggerImpl;
    }

    public boolean isInterrupted() {
        return Thread.currentThread().isInterrupted();
    }

    public void executeInteractivity(InteractivityWrapper interactivityWrapper) {
        Future future = this.executor.execute(new InteractivityCommand("Interactivity", interactivityWrapper, null));
        if (future != null) {
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                String string;
                if (this.logger != null) {
                    this.logger.log(LogLevel.Error, LogComponent.CommonGrammar, "Interactivity request failed", "exception", executionException);
                }
                if (executionException.getCause() instanceof VisException) {
                    throw (VisException)executionException.getCause();
                }
                String string2 = string = executionException.getCause() != null ? executionException.getCause().getMessage() : null;
                if (string == null) {
                    string = "Interactivity request failed";
                }
                EngineException engineException = new EngineException(string, ErrorCode.INTERACTIVITY_FAIL, null);
                engineException.initCause(executionException.getCause());
                throw engineException;
            }
        }
    }

    public void dispose() {
        if (this.localExecutor) {
            this.executor.dispose();
        }
    }
}

