/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.vis.engine.internal.RaveFuture;
import com.ibm.vis.engine.internal.RaveRunnable;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ThreadLauncher {
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final String typeName;
    private static Map<String, ThreadLauncher> launcherMap;

    private ThreadLauncher(String string) {
        this.typeName = string;
    }

    public static final ThreadLauncher getInstance(String string) {
        ThreadLauncher threadLauncher;
        if (launcherMap == null) {
            launcherMap = new HashMap<String, ThreadLauncher>();
        }
        if ((threadLauncher = launcherMap.get(string)) == null) {
            threadLauncher = new ThreadLauncher(string);
            launcherMap.put(string, threadLauncher);
        }
        return threadLauncher;
    }

    public static final void disposeAll() {
        if (launcherMap != null) {
            Set<Map.Entry<String, ThreadLauncher>> set = launcherMap.entrySet();
            while (set.iterator().hasNext()) {
                Map.Entry<String, ThreadLauncher> entry = set.iterator().next();
                ThreadLauncher threadLauncher = ThreadLauncher.getInstance(entry.getKey());
                threadLauncher.dispose();
            }
        }
    }

    public RaveFuture execute(RaveRunnable raveRunnable) {
        RunnableWrapper runnableWrapper = new RunnableWrapper(raveRunnable);
        Future<?> future = this.executorService.submit(runnableWrapper);
        return new FutureWrapper(future);
    }

    public void dispose() {
        this.executorService.shutdownNow();
        launcherMap.remove(this.typeName);
    }

    class FutureWrapper
    implements RaveFuture {
        Future<?> myFuture;

        public FutureWrapper(Future<?> future) {
            this.myFuture = future;
        }

        @Override
        public boolean get() throws Exception {
            this.myFuture.get();
            return true;
        }
    }

    class RunnableWrapper
    implements Runnable {
        RaveRunnable myRunnable;

        RunnableWrapper(RaveRunnable raveRunnable) {
            this.myRunnable = raveRunnable;
        }

        @Override
        public void run() {
            this.myRunnable.run();
        }
    }
}

