/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl;

import com.ibm.vis.engine.internal.nativeImpl.CancellableSingleThreadExecutor;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.VisCommand;
import com.ibm.vis.engine.internal.nativeImpl.VisCommandThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class VisCommandExecutor {
    private final ExecutorService specExecutorService = new CancellableSingleThreadExecutor(specThreads);
    private final ExecutorService renderExecutorService = new CancellableSingleThreadExecutor(renderThreads);
    private final ExecutorService interactivityExecutorService = new CancellableSingleThreadExecutor(interactivityThreads);
    private static final ThreadFactory specThreads = new VisCommandThreadFactory("vis-specificn-");
    private static final ThreadFactory renderThreads = new VisCommandThreadFactory("vis-rendering-");
    private static final ThreadFactory interactivityThreads = new VisCommandThreadFactory("vis-interactn-");

    private VisCommandExecutor() {
    }

    public static final VisCommandExecutor newInstance() {
        return new VisCommandExecutor();
    }

    public Future execute(VisCommand visCommand) {
        if (visCommand.type() == VisCommand.Type.interactivity) {
            boolean bl;
            if (visCommand.subType() == VisCommand.SubType.animation && !(bl = ((CancellableSingleThreadExecutor)this.interactivityExecutorService).selectiveClearQueue(VisCommand.SubType.general))) {
                ((CancellableSingleThreadExecutor)this.specExecutorService).clearQueue(true);
                ((CancellableSingleThreadExecutor)this.renderExecutorService).clearQueue(true);
            }
            return this.interactivityExecutorService.submit(visCommand);
        }
        if (visCommand.type() == VisCommand.Type.render) {
            return this.renderExecutorService.submit(visCommand);
        }
        return null;
    }

    public void dispose() {
        this.specExecutorService.shutdownNow();
        this.renderExecutorService.shutdownNow();
        this.interactivityExecutorService.shutdownNow();
    }
}

