/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl.collections;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.Arrays;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class DoublePrimitiveArrayList {
    private double[] elementData;
    private int size;

    public DoublePrimitiveArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new double[n];
    }

    public DoublePrimitiveArrayList() {
        this(10);
    }

    public DoublePrimitiveArrayList(DoublePrimitiveArrayList doublePrimitiveArrayList) {
        this.elementData = doublePrimitiveArrayList.toArray();
        this.size = this.elementData.length;
    }

    public void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = Arrays.copyOf(this.elementData, n3);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(double d) {
        return this.indexOf(d) >= 0;
    }

    public int indexOf(double d) {
        for (int i = 0; i < this.size; ++i) {
            if (d != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public double[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    public double get(int n) {
        this.RangeCheck(n);
        return this.elementData[n];
    }

    public double set(int n, double d) {
        this.RangeCheck(n);
        double d2 = this.elementData[n];
        this.elementData[n] = d;
        return d2;
    }

    public boolean add(double d) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = d;
        return true;
    }

    public void add(int n, double d) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
        this.elementData[n] = d;
        ++this.size;
    }

    public boolean remove(double d) {
        for (int i = 0; i < this.size; ++i) {
            if (d != this.elementData[i]) continue;
            this.fastRemove(i);
            return true;
        }
        return false;
    }

    private void fastRemove(int n) {
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = 0.0;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = 0.0;
        }
        this.size = 0;
    }

    public boolean addAll(DoublePrimitiveArrayList doublePrimitiveArrayList) {
        double[] dArray = doublePrimitiveArrayList.toArray();
        int n = dArray.length;
        this.ensureCapacity(this.size + n);
        System.arraycopy(dArray, 0, this.elementData, this.size, n);
        this.size += n;
        return n != 0;
    }

    public boolean addAll(int n, DoublePrimitiveArrayList doublePrimitiveArrayList) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        double[] dArray = doublePrimitiveArrayList.toArray();
        int n2 = dArray.length;
        this.ensureCapacity(this.size + n2);
        int n3 = this.size - n;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n, this.elementData, n + n2, n3);
        }
        System.arraycopy(dArray, 0, this.elementData, n, n2);
        this.size += n2;
        return n2 != 0;
    }

    protected void removeRange(int n, int n2) {
        int n3 = this.size - n2;
        System.arraycopy(this.elementData, n2, this.elementData, n, n3);
        int n4 = this.size - (n2 - n);
        while (this.size != n4) {
            this.elementData[--this.size] = 0.0;
        }
    }

    private void RangeCheck(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DoublePrimitiveArrayList)) {
            return false;
        }
        DoublePrimitiveArrayList doublePrimitiveArrayList = (DoublePrimitiveArrayList)object;
        int n = 0;
        for (n = 0; n < this.size() && n < doublePrimitiveArrayList.size; ++n) {
            if (this.get(n) == doublePrimitiveArrayList.get(n)) continue;
            return false;
        }
        return n == this.size() && n == doublePrimitiveArrayList.size();
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size(); ++i) {
            long l = Double.doubleToLongBits(this.get(i));
            int n2 = (int)(l ^ l >>> 32);
            n = 31 * n + n2;
        }
        return n;
    }

    public boolean removeAll(DoublePrimitiveArrayList doublePrimitiveArrayList) {
        boolean bl = false;
        for (int i = 0; i < doublePrimitiveArrayList.size() && this.size() > 0; ++i) {
            while (this.remove(doublePrimitiveArrayList.get(i))) {
                bl = true;
            }
        }
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(this.elementData[i]);
            if (i >= this.size - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

