/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl.collections;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import java.util.Arrays;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class IntPrimitiveArrayList {
    private int[] elementData;
    private int size;

    public IntPrimitiveArrayList(int n) {
        if (n < 0) {
            throw new EngineException("Illegal Capacity: " + n, ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        this.elementData = new int[n];
    }

    public IntPrimitiveArrayList() {
        this(10);
    }

    public IntPrimitiveArrayList(IntPrimitiveArrayList intPrimitiveArrayList) {
        this.elementData = intPrimitiveArrayList.toArray();
        this.size = this.elementData.length;
    }

    public void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = Arrays.copyOf(this.elementData, n3);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(int n) {
        return this.indexOf(n) >= 0;
    }

    public int indexOf(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (n != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public int[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    public int[] toArray(int[] nArray) {
        if (nArray.length < this.size) {
            return Arrays.copyOf(this.elementData, this.size);
        }
        System.arraycopy(this.elementData, 0, nArray, 0, this.size);
        if (nArray.length > this.size) {
            nArray[this.size] = 0;
        }
        return nArray;
    }

    public int get(int n) {
        this.RangeCheck(n);
        return this.elementData[n];
    }

    public int set(int n, int n2) {
        this.RangeCheck(n);
        int n3 = this.elementData[n];
        this.elementData[n] = n2;
        return n3;
    }

    public boolean add(int n) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = n;
        return true;
    }

    public void add(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new EngineException("Index: " + n + ", Size: " + this.size, ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
        this.elementData[n] = n2;
        ++this.size;
    }

    public boolean remove(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (n != this.elementData[i]) continue;
            this.fastRemove(i);
            return true;
        }
        return false;
    }

    private void fastRemove(int n) {
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = 0;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = 0;
        }
        this.size = 0;
    }

    public boolean addAll(IntPrimitiveArrayList intPrimitiveArrayList) {
        int[] nArray = intPrimitiveArrayList.toArray();
        int n = nArray.length;
        this.ensureCapacity(this.size + n);
        System.arraycopy(nArray, 0, this.elementData, this.size, n);
        this.size += n;
        return n != 0;
    }

    public boolean addAll(int n, IntPrimitiveArrayList intPrimitiveArrayList) {
        assert (0 <= n && n < this.size) : "Index is out of bounds: " + n + ", Size: " + this.size;
        if (n > this.size || n < 0) {
            throw new EngineException("Invalid index passed: Index: " + n + ", Size: " + this.size, ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        int[] nArray = intPrimitiveArrayList.toArray();
        int n2 = nArray.length;
        this.ensureCapacity(this.size + n2);
        int n3 = this.size - n;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n, this.elementData, n + n2, n3);
        }
        System.arraycopy(nArray, 0, this.elementData, n, n2);
        this.size += n2;
        return n2 != 0;
    }

    protected void removeRange(int n, int n2) {
        int n3 = this.size - n2;
        System.arraycopy(this.elementData, n2, this.elementData, n, n3);
        int n4 = this.size - (n2 - n);
        while (this.size != n4) {
            this.elementData[--this.size] = 0;
        }
    }

    private void RangeCheck(int n) {
        if (n >= this.size) {
            throw new EngineException("Index is out of bounds: " + n + ", Size: " + this.size, ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntPrimitiveArrayList)) {
            return false;
        }
        IntPrimitiveArrayList intPrimitiveArrayList = (IntPrimitiveArrayList)object;
        int n = 0;
        for (n = 0; n < this.size() && n < intPrimitiveArrayList.size; ++n) {
            if (this.get(n) == intPrimitiveArrayList.get(n)) continue;
            return false;
        }
        return n == this.size() && n == intPrimitiveArrayList.size();
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size(); ++i) {
            n = 31 * n + this.get(i);
        }
        return n;
    }

    public boolean removeAll(IntPrimitiveArrayList intPrimitiveArrayList) {
        boolean bl = false;
        for (int i = 0; i < intPrimitiveArrayList.size() && this.size() > 0; ++i) {
            while (this.remove(intPrimitiveArrayList.get(i))) {
                bl = true;
            }
        }
        return bl;
    }
}

