/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl.uriHandlers;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.uriHandlers.GraphicNativeResourceImpl;
import com.ibm.vis.engine.internal.resource.BinaryNativeResource;
import com.ibm.vis.engine.internal.resource.INativeResource;
import com.ibm.vis.engine.internal.resource.ResourceURIHandler;
import com.ibm.vis.engine.internal.resource.TextNativeResource;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class AbstractURIHandler
implements ResourceURIHandler {
    static final String TEXT_RESOURCE = "text";
    static final String BINARY_RESOURCE = "binary";
    static final String GRAPHIC_RESOURCE = "graphic";

    @Override
    public final INativeResource getTextResource(String string) {
        return this.getResource(string, TEXT_RESOURCE);
    }

    @Override
    public final INativeResource getBinaryResource(String string) {
        return this.getResource(string, BINARY_RESOURCE);
    }

    @Override
    public final INativeResource getGraphicResource(String string) {
        return this.getResource(string, GRAPHIC_RESOURCE);
    }

    public static final String getDefaultURIType() {
        return "file";
    }

    public static final String convertByteArrayToString(byte[] byArray, String string) {
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "Encoding not supported on system." + string;
            EngineException engineException = new EngineException(string2, ErrorCode.ENGINE_UNSUPPORTED_OPERATION, unsupportedEncodingException.getMessage());
            engineException.initCause(unsupportedEncodingException);
            throw engineException;
        }
    }

    protected INativeResource getResource(String string, String string2) {
        String string3 = this.resolveToURI(string);
        return this.getResourceFromURL(this.getValidURL(string3), string2);
    }

    protected abstract String getProtocol();

    protected URL getValidURL(String string) {
        String string2;
        Object object;
        URL uRL = null;
        if (string == null || string.length() == 0) {
            String string3 = "Path for external resource cannot be null";
            throw new EngineException(string3, ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        try {
            object = new URI(string);
            uRL = ((URI)object).toURL();
        }
        catch (URISyntaxException uRISyntaxException) {
            String string4 = "Path for external resource is not valid: '" + string + "'";
            EngineException engineException = new EngineException(string4, ErrorCode.ENGINE_ILLEGAL_ARGUMENT, uRISyntaxException.getMessage());
            engineException.initCause(uRISyntaxException);
            throw engineException;
        }
        catch (MalformedURLException malformedURLException) {
            String string5 = "Path for external resource is not valid: '" + string + "'";
            EngineException engineException = new EngineException(string5, ErrorCode.ENGINE_ILLEGAL_ARGUMENT, malformedURLException.getMessage());
            engineException.initCause(malformedURLException);
            throw engineException;
        }
        object = this.getProtocol();
        if (object != null && string.indexOf(":") > -1 && !(string2 = string.substring(0, string.indexOf(":"))).equalsIgnoreCase((String)object)) {
            String string6 = "URL should start with '" + (String)object + "'";
            throw new EngineException(string6, ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        return uRL;
    }

    protected INativeResource getResourceFromURL(URL uRL, String string) {
        try {
            int n;
            URLConnection uRLConnection = uRL.openConnection();
            int n2 = uRLConnection.getContentLength();
            InputStream inputStream = uRLConnection.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = n2 != -1 ? new ByteArrayOutputStream(n2) : new ByteArrayOutputStream();
            byte[] byArray = new byte[512];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            String string2 = uRLConnection.getContentType();
            String string3 = uRLConnection.getContentEncoding();
            inputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            INativeResource iNativeResource = AbstractURIHandler.makeNativeResource(string2, string3, byArray2, string, uRL.getPath());
            return iNativeResource;
        }
        catch (IOException iOException) {
            String string4 = "Could not connect to given URL : '" + uRL.toString() + "'";
            EngineException engineException = new EngineException(string4, ErrorCode.ENGINE_UNSUPPORTED_OPERATION, iOException.getMessage());
            engineException.initCause(iOException);
            throw engineException;
        }
    }

    protected static INativeResource makeNativeResource(String string, String string2, byte[] byArray, String string3, String string4) {
        INativeResource iNativeResource = null;
        iNativeResource = TEXT_RESOURCE.equals(string3) ? new TextNativeResource(string, string2, byArray) : (GRAPHIC_RESOURCE.equals(string3) ? new GraphicNativeResourceImpl(string, string2, byArray, string4) : new BinaryNativeResource(string, string2, byArray));
        return iNativeResource;
    }

    protected String resolveToURI(String string) {
        return string;
    }
}

