/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.nativeImpl.uriHandlers;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.resource.GraphicNativeResource;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GraphicNativeResourceImpl
extends GraphicNativeResource {
    public GraphicNativeResourceImpl(String string, String string2, byte[] byArray, String string3) {
        super(string, string2, byArray, string3);
    }

    @Override
    public Object getData() {
        this.blocked = false;
        if (this.image != null) {
            return this.image;
        }
        BufferedImage bufferedImage = null;
        if (this.data != null) {
            try {
                bufferedImage = ImageIO.read(new ByteArrayInputStream(this.data));
            }
            catch (IOException iOException) {
                String string = "Could not read " + this.imageName + " as image format.";
                EngineException engineException = new EngineException(string, ErrorCode.ENGINE_UNSUPPORTED_OPERATION, iOException.getMessage());
                engineException.initCause(iOException);
                throw engineException;
            }
        }
        this.image = bufferedImage;
        if (bufferedImage != null) {
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
        }
        return this.image;
    }
}

