/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.resource;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.ResourceSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ResourceAttributes {
    private static final String TYPE_DELIMITER = "/";
    private final String id;
    private final String type;
    private final String[] URIs;
    private final Object embeddedData;
    private String contentType = null;
    private String formatType = null;
    private String nativeType = null;
    private static List<String> graphicFormats = new ArrayList<String>();

    public ResourceAttributes(ResourceSpec resourceSpec) {
        this.id = resourceSpec.id;
        this.type = resourceSpec.type;
        if (resourceSpec.URIs != null) {
            this.URIs = new String[resourceSpec.URIs.length];
            for (int i = 0; i < resourceSpec.URIs.length; ++i) {
                this.URIs[i] = resourceSpec.URIs[i];
            }
        } else {
            this.URIs = null;
        }
        this.embeddedData = resourceSpec.embeddedData;
        this.initResourceTypes();
    }

    private void initResourceTypes() {
        if (this.type != null) {
            String[] stringArray = this.type.split(TYPE_DELIMITER);
            if (stringArray.length != 3) {
                String string = "Invalid resource type specified: '" + this.type + "'";
                throw new SpecException(string, ErrorCode.SPEC_INVALID_VALUE, null);
            }
            this.contentType = stringArray[0];
            this.formatType = stringArray[1];
            this.nativeType = stringArray[2];
        }
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String[] getURIs() {
        return this.URIs;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFormatType() {
        if (graphicFormats.contains(this.formatType)) {
            return "graphic";
        }
        return this.formatType;
    }

    public String getNativeType() {
        return this.nativeType;
    }

    public Object getEmbeddedData() {
        return this.embeddedData;
    }

    static {
        graphicFormats.add("png");
        graphicFormats.add("jpg");
        graphicFormats.add("gif");
        graphicFormats.add("bmp");
    }
}

