/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.resource;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.resource.CachedResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ResourceCache {
    int MAX_SIZE_IN_KILOBYTES = 51200;
    private static final double MAX_ITEM_SIZE_AS_FRACTION = 0.75;
    final Map<String, CachedResource> items = new HashMap<String, CachedResource>();
    final List<CachedResource> ordered = new ArrayList<CachedResource>();
    int currentSize = 0;

    public void put(String string, Object object, long l) {
        int n = (int)Math.ceil((double)(l + 1L) / 1024.0);
        if ((double)n > 0.75 * (double)this.MAX_SIZE_IN_KILOBYTES) {
            return;
        }
        CachedResource cachedResource = new CachedResource(string, object, n);
        this.items.put(string, cachedResource);
        this.ordered.add(cachedResource);
        this.currentSize += n;
        while (this.currentSize > this.MAX_SIZE_IN_KILOBYTES) {
            for (int i = 0; i < this.ordered.size(); ++i) {
                CachedResource cachedResource2 = this.ordered.get(i);
                if (cachedResource2.ref.get() != null) continue;
                this.removeItem(cachedResource2);
                this.ordered.remove(cachedResource2);
            }
            CachedResource cachedResource3 = this.ordered.remove(0);
            this.removeItem(cachedResource3);
        }
    }

    public Object get(String string) {
        CachedResource cachedResource = this.items.get(string);
        if (cachedResource == null) {
            return null;
        }
        Object object = cachedResource.ref.get();
        this.ordered.remove(cachedResource);
        if (object == null) {
            this.removeItem(cachedResource);
        } else {
            this.ordered.add(cachedResource);
        }
        return object;
    }

    private void removeItem(CachedResource cachedResource) {
        this.items.remove(cachedResource.id);
        this.currentSize -= cachedResource.size;
    }

    public void clear() {
        this.items.clear();
        this.ordered.clear();
        this.currentSize = 0;
    }
}

