/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.resource;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.extension.RAVEExtensionFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.MappedJSONObject;
import com.ibm.vis.engine.internal.nativeImpl.SpecUtil;
import com.ibm.vis.engine.internal.resource.GraphicNativeResource;
import com.ibm.vis.engine.internal.resource.INativeResource;
import com.ibm.vis.engine.internal.resource.ResourceAttributes;
import com.ibm.vis.engine.internal.resource.ResourceCache;
import com.ibm.vis.engine.internal.resource.ResourceContentHandler;
import com.ibm.vis.engine.internal.resource.ResourceFormatHandler;
import com.ibm.vis.engine.internal.resource.ResourceURIHandler;
import com.ibm.vis.engine.internal.resource.content.ResourceContentHandlerFactory;
import com.ibm.vis.engine.internal.resource.format.ResourceFormatHandlerFactory;
import com.ibm.vis.engine.internal.resource.uriHandlers.EmbeddedDataURIHandler;
import com.ibm.vis.engine.internal.resource.uriHandlers.ResourceURIHandlerFactory;
import com.ibm.vis.engine.internal.util.VisJSONUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.spec.internal.ResourceSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ResourceService {
    private static final String FILE_SEPARATOR = "/";
    private final ResourceCache rcache = new ResourceCache();
    private static volatile ResourceService rservice = null;
    private final Map<String, RAVEExtensionFactory<ResourceURIHandler>> uriHandlerFactories = new ConcurrentHashMap<String, RAVEExtensionFactory<ResourceURIHandler>>(16, 0.75f, 1);
    private final Map<String, RAVEExtensionFactory<ResourceFormatHandler>> formatHandlerFactories = new ConcurrentHashMap<String, RAVEExtensionFactory<ResourceFormatHandler>>(16, 0.75f, 1);
    private final Map<String, RAVEExtensionFactory<ResourceContentHandler>> contentHandlerFactories = new ConcurrentHashMap<String, RAVEExtensionFactory<ResourceContentHandler>>(16, 0.75f, 1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceService getInstance() {
        if (rservice != null) return rservice;
        Class<ResourceService> clazz = ResourceService.class;
        synchronized (ResourceService.class) {
            if (rservice != null) return rservice;
            rservice = new ResourceService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return rservice;
        }
    }

    private ResourceService() {
        this.registerURIHandlerFactory(new ResourceURIHandlerFactory());
        this.registerFormatHandlerFactory(new ResourceFormatHandlerFactory());
        this.registerContentHandlerFactory(new ResourceContentHandlerFactory());
    }

    public void registerURIHandlerFactory(RAVEExtensionFactory<ResourceURIHandler> rAVEExtensionFactory) {
        Set<String> set = this.uriHandlerFactories.keySet();
        List<String> list = rAVEExtensionFactory.getExtensionsSupported();
        ResourceService.checkRegisteredExtensions(set, list);
        for (String string : list) {
            this.uriHandlerFactories.put(string, rAVEExtensionFactory);
        }
    }

    public void registerFormatHandlerFactory(RAVEExtensionFactory<ResourceFormatHandler> rAVEExtensionFactory) {
        Set<String> set = this.formatHandlerFactories.keySet();
        List<String> list = rAVEExtensionFactory.getExtensionsSupported();
        ResourceService.checkRegisteredExtensions(set, list);
        for (String string : list) {
            this.formatHandlerFactories.put(string, rAVEExtensionFactory);
        }
    }

    public void registerContentHandlerFactory(RAVEExtensionFactory<ResourceContentHandler> rAVEExtensionFactory) {
        Set<String> set = this.contentHandlerFactories.keySet();
        List<String> list = rAVEExtensionFactory.getExtensionsSupported();
        ResourceService.checkRegisteredExtensions(set, list);
        for (String string : list) {
            this.contentHandlerFactories.put(string, rAVEExtensionFactory);
        }
    }

    public ResourceURIHandler getResourceURIHandler(String string) {
        RAVEExtensionFactory<ResourceURIHandler> rAVEExtensionFactory = this.uriHandlerFactories.get(string);
        if (rAVEExtensionFactory != null) {
            return rAVEExtensionFactory.createExtension(string);
        }
        throw new EngineException("The extension '" + string + "' for Resource URI Handling is not found", ErrorCode.EXTENSION_NOT_FOUND, null);
    }

    public ResourceFormatHandler getResourceFormatHandler(String string) {
        RAVEExtensionFactory<ResourceFormatHandler> rAVEExtensionFactory = this.formatHandlerFactories.get(string);
        if (rAVEExtensionFactory != null) {
            return rAVEExtensionFactory.createExtension(string);
        }
        throw new EngineException("The extension '" + string + "' for Resource Format Handling is not found", ErrorCode.EXTENSION_NOT_FOUND, null);
    }

    public ResourceContentHandler getResourceContentHandler(String string) {
        RAVEExtensionFactory<ResourceContentHandler> rAVEExtensionFactory = this.contentHandlerFactories.get(string);
        if (rAVEExtensionFactory != null) {
            return rAVEExtensionFactory.createExtension(string);
        }
        throw new EngineException("The extension '" + string + "' for Resource Content Handling is not found", ErrorCode.EXTENSION_NOT_FOUND, null);
    }

    private static void checkRegisteredExtensions(Set<String> set, List<String> list) {
        for (String string : list) {
            if (!set.contains(string)) continue;
            throw new EngineException("Extension '" + string + "' is already registered.Cannot overwrite with a new one.", ErrorCode.EXTENSION_ALREADY_REGISTERED, null);
        }
    }

    public Object getResourceForAugmentedGeoData(String string) {
        if (string != null && string.trim().length() > 0) {
            ResourceSpec resourceSpec = new ResourceSpec();
            resourceSpec.id = string;
            resourceSpec.type = "geo/json/data";
            resourceSpec.URIs = new String[]{string};
            return this.getResource(resourceSpec, null);
        }
        return null;
    }

    public Object getResource(MappedJSONObject mappedJSONObject, VisJSONSpec visJSONSpec) {
        if (mappedJSONObject == null) {
            return null;
        }
        JSONObject jSONObject = mappedJSONObject.toJSON();
        VisJSONUtil.checkReferenceExpanded(jSONObject);
        ResourceSpec resourceSpec = (ResourceSpec)mappedJSONObject;
        ResourceAttributes resourceAttributes = new ResourceAttributes(resourceSpec);
        String[] stringArray = resourceSpec.URIs;
        if (stringArray != null && stringArray.length > 0) {
            for (String string : stringArray) {
                try {
                    return this.getResourceData(string, resourceAttributes, visJSONSpec);
                }
                catch (EngineException engineException) {
                }
            }
            String string = "All the URIs for the resource are invalid.";
            throw new EngineException(string, ErrorCode.SPEC_INVALID_RESOURCE_URI, null);
        }
        throw new EngineException("No URI specified to load the resource " + resourceAttributes.getId() != null ? "'" + resourceAttributes.getId() + "'" : "", ErrorCode.SPEC_INVALID_RESOURCE_URI, null);
    }

    private Object getResourceData(String string, ResourceAttributes resourceAttributes, VisJSONSpec visJSONSpec) {
        Object object;
        String string2;
        String string3 = ResourceService.getAbsoluteURI(string);
        Object object2 = this.getDataFromResourceCache(string3, string2 = ResourceService.getURItype(string3));
        if (object2 != null) {
            return object2;
        }
        ResourceURIHandler resourceURIHandler = null;
        if (ResourceService.isEmbeddedType(string2)) {
            object = new EmbeddedDataURIHandler();
            ((EmbeddedDataURIHandler)object).setCurrentSpec(visJSONSpec);
            resourceURIHandler = object;
        } else {
            resourceURIHandler = this.getResourceURIHandler(string2);
        }
        if (resourceURIHandler != null) {
            ResourceFormatHandler resourceFormatHandler;
            object = null;
            if ("text".equals(resourceAttributes.getNativeType())) {
                object = resourceURIHandler.getTextResource(string3);
            } else if ("image".equals(resourceAttributes.getContentType())) {
                object = resourceURIHandler.getGraphicResource(string3);
                ((GraphicNativeResource)object).setImageName(resourceAttributes.getId());
            } else {
                object = resourceURIHandler.getBinaryResource(string3);
            }
            if (object != null && (resourceFormatHandler = this.getResourceFormatHandler(resourceAttributes.getFormatType())) != null) {
                resourceFormatHandler.setNativeResource((INativeResource)object);
                ResourceContentHandler resourceContentHandler = this.getResourceContentHandler(resourceAttributes.getContentType());
                resourceContentHandler.setFormatHandler(resourceFormatHandler);
                object2 = resourceContentHandler.getContent();
                this.putDataInResourceCache(string3, string2, object2, object.approximateSize());
                return object2;
            }
        }
        throw new EngineException("Unable to load resourcedata from URI" + string, ErrorCode.SPEC_INVALID_RESOURCE_URI, null);
    }

    private void putDataInResourceCache(String string, String string2, Object object, long l) {
        if (!ResourceService.isEmbeddedType(string2)) {
            this.rcache.put(string, object, l);
        }
    }

    private Object getDataFromResourceCache(String string, String string2) {
        if (!ResourceService.isEmbeddedType(string2)) {
            return this.rcache.get(string);
        }
        return null;
    }

    private static boolean isEmbeddedType(String string) {
        return "embedded".equals(string);
    }

    private static String getAbsoluteURI(String string) {
        String string2 = SpecUtil.getResourcePath();
        if (string2 == null || string2.trim().length() == 0 || !string.trim().startsWith(".") && !string.trim().startsWith("\\") && !string.trim().startsWith(FILE_SEPARATOR)) {
            return string;
        }
        if (string2.endsWith(FILE_SEPARATOR)) {
            String string3 = string;
            if (string.startsWith(FILE_SEPARATOR)) {
                string3 = string.substring(1, string.length());
            }
            return string2 + string3;
        }
        if (string.startsWith(FILE_SEPARATOR)) {
            return string2 + string;
        }
        return string2.trim() + FILE_SEPARATOR + string.trim();
    }

    public void clearResourceCache() {
        this.rcache.clear();
    }

    private static String getURItype(String string) {
        int n = string.indexOf(":");
        if (n > -1) {
            return string.substring(0, n);
        }
        return "file";
    }
}

