/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.resource;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.uriHandlers.AbstractURIHandler;
import com.ibm.vis.engine.internal.resource.INativeResource;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TextNativeResource
implements INativeResource {
    private static final String DEFAULT_TEXT_ENCODING = "utf-8";
    private String encoding = null;
    private byte[] data = null;
    private String type = null;
    private String stringData = null;

    public TextNativeResource(String string, String string2, byte[] byArray) {
        this.type = string;
        this.encoding = string2;
        this.data = byArray;
    }

    @Override
    public Object getData() {
        if (this.stringData == null && this.data != null) {
            this.encoding = this.encoding != null ? this.encoding : DEFAULT_TEXT_ENCODING;
            this.stringData = AbstractURIHandler.convertByteArrayToString(this.data, this.encoding);
        }
        return this.stringData;
    }

    public void setStringData(String string) {
        this.stringData = string;
    }

    @Override
    public long approximateSize() {
        return this.data == null ? 0L : (long)this.data.length;
    }
}

