/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.resource.content;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.resource.ResourceContentHandler;
import com.ibm.vis.engine.internal.resource.ResourceFormatHandler;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/resourceHandlingLayer")
public abstract class AbstractContentHandler
implements ResourceContentHandler {
    public static final String RESOURCE_TYPE_GEODATA = "geodata";
    public static final String RESOURCE_TYPE_IMAGE = "image";
    public static final String RESOURCE_TYPE_DATA = "data";
    public static final String RESOURCE_ENCODING_TEXT = "text";
    public static final String RESOURCE_ENCODING_BINARY = "binary";
    private String type;
    private String encoding;
    protected ResourceFormatHandler formatHandler;

    @Override
    public final Object getContent() {
        this.checkFormatHandler();
        return this.getResourceContent();
    }

    protected abstract Object getResourceContent();

    public final String getType() {
        return this.type;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final ResourceFormatHandler getFormatHandler() {
        return this.formatHandler;
    }

    protected final void setType(String string) {
        this.type = string;
    }

    protected final void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    public final void setFormatHandler(ResourceFormatHandler resourceFormatHandler) {
        this.formatHandler = resourceFormatHandler;
    }

    protected void checkFormatHandler() {
        if (this.formatHandler == null) {
            throw new EngineException("No ResourceFormatHandler set on the ResourceContentHandler instance", ErrorCode.ENGINE_RES_FMT_HANDLER_NOT_SET, null);
        }
    }
}

