/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.resource.format;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.dataHandler.DataProviderUtil;
import com.ibm.vis.engine.internal.resource.INativeResource;
import com.ibm.vis.engine.internal.resource.format.AbstractFormatHandler;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/resourceHandlingLayer")
public class CsvFormatHandler
extends AbstractFormatHandler {
    private String[][] csvData = null;
    private static final String hash = "#";
    private final char delimiter = (char)44;

    public CsvFormatHandler() {
        this.setFormatType("csv");
    }

    private void processCsv(String string) {
        int n;
        if (string == null) {
            this.csvData = null;
            return;
        }
        String[] stringArray = string.split("\n");
        String[][] stringArrayArray = new String[stringArray.length][];
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            if ((string2 = string2.trim()).equals("") || string2.length() == 0 || string2.startsWith(hash)) continue;
            String[] stringArray2 = DataProviderUtil.splitCsvLine(string2);
            if (n3 != 0 && n3 != stringArray2.length) {
                throw new EngineException("all rows on csv file do not have same number of columns", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
            }
            n3 = stringArray2.length;
            stringArrayArray[n2] = new String[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = stringArray2[i].trim();
                if (stringArray2[i].length() > 1 && stringArray2[i].charAt(0) == '\"' && stringArray2[i].charAt(stringArray2[i].length() - 1) == '\"') {
                    stringArray2[i] = stringArray2[i].substring(1, stringArray2[i].length() - 1);
                }
                stringArrayArray[n2][i] = stringArray2[i];
            }
            ++n2;
        }
        this.csvData = new String[n2][];
        for (n = 0; n < n2; ++n) {
            this.csvData[n] = new String[n3];
            for (int i = 0; i < n3; ++i) {
                this.csvData[n][i] = stringArrayArray[n][i];
            }
        }
    }

    @Override
    protected final Object getData() {
        return this.csvData;
    }

    @Override
    public void setNativeResource(INativeResource iNativeResource) {
        String string = (String)iNativeResource.getData();
        if (string != null && !BasicFactory.isString(string)) {
            throw new EngineException("CSVFormatHandler can handle only String input", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        String string2 = string;
        this.processCsv(string2);
    }
}

