/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.resource.format;

import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.resource.INativeResource;
import com.ibm.vis.engine.internal.resource.TextNativeResource;
import com.ibm.vis.engine.internal.resource.format.AbstractFormatHandler;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import java.io.IOException;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/resourceHandlingLayer")
public class JsonFormatHandler
extends AbstractFormatHandler {
    private JSONObject jObj = null;

    public JsonFormatHandler() {
        this.setFormatType("json");
    }

    private static JSONObject jsonFromString(Object object) {
        try {
            return BasicFactory.parse(object);
        }
        catch (IOException iOException) {
            throw new EngineException("Error parsing GeoJSON.", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
    }

    private static JSONObject jsonFromArray(byte[] byArray) {
        try {
            return BasicFactory.parse(byArray);
        }
        catch (Exception exception) {
            TextNativeResource textNativeResource = new TextNativeResource("json", "utf-8", byArray);
            return JsonFormatHandler.jsonFromString(textNativeResource.getData());
        }
    }

    @Override
    protected final Object getData() {
        return this.jObj;
    }

    @Override
    public void setNativeResource(INativeResource iNativeResource) {
        Object object = iNativeResource.getData();
        if (object == null) {
            this.jObj = null;
        } else if (BasicFactory.isString(object)) {
            this.jObj = JsonFormatHandler.jsonFromString(object);
        } else if (BasicFactory.isArray(object)) {
            this.jObj = JsonFormatHandler.jsonFromArray((byte[])object);
        } else {
            throw new EngineException("JSONFormatHandler cannot handle data format", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
    }
}

