/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.resource.uriHandlers;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.uriHandlers.AbstractURIHandler;
import com.ibm.vis.engine.internal.resource.INativeResource;
import com.ibm.vis.engine.internal.resource.TextNativeResource;
import com.ibm.vis.spec.internal.ResourceSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
@OnDemandLoad(value="com/ibm/vis/layers/resourceHandlingLayer")
public class EmbeddedDataURIHandler
extends AbstractURIHandler {
    private ResourceSpec[] resources;

    @Override
    protected String getProtocol() {
        return "embedded";
    }

    public void setCurrentSpec(VisJSONSpec visJSONSpec) {
        this.resources = visJSONSpec == null ? null : visJSONSpec.resource;
    }

    @Override
    protected INativeResource getResource(String string, String string2) {
        String string3 = this.resolveURIToEmbeddedData(string);
        if (string3 != null && string2.equals("text")) {
            TextNativeResource textNativeResource = new TextNativeResource(null, null, null);
            textNativeResource.setStringData(string3);
            return textNativeResource;
        }
        return null;
    }

    private String resolveURIToEmbeddedData(String string) {
        if (this.resources == null) {
            return null;
        }
        String string2 = EmbeddedDataURIHandler.extractIdFromUri(string);
        if (string2 != null) {
            for (ResourceSpec resourceSpec : this.resources) {
                if (!string2.equals(resourceSpec.id) || resourceSpec.embeddedData == null) continue;
                return resourceSpec.embeddedData;
            }
        }
        return null;
    }

    private static String extractIdFromUri(String string) {
        if (string == null || string.length() < 45) {
            return null;
        }
        String string2 = string.substring(29);
        int n = string2.indexOf(34);
        return string2.substring(0, n);
    }
}

