/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.scene;

import com.ibm.vis.engine.internal.Bounds;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.interaction.defender.ScrollUnitControllerAction;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.scene.SymbolBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.PolyGeom;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.internal.MergeStyleKey;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.SymbolShapeSpec;
import com.ibm.vis.spec.internal.SymbolSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2015\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class CustomGlyphBuilder {
    private static final String NONE = "none";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String BOTH = "both";
    private static final String PART = "part";
    private static final String TYPE = "type";
    private static final String BUILDER = "builder";
    private static final String SYMBOL_BUILDER = "SymbolBuilder";
    private final VisContext visContext;
    private final ScrollUnitControllerAction defenderHack = new ScrollUnitControllerAction();
    public final SymbolSpec spec;
    private final Dim extent;
    private final Bounds bounds;
    final int scaleDimensions;
    private final Map<MergeStyleKey, StyleSpec> cachedStyles = new HashMap<MergeStyleKey, StyleSpec>();

    public CustomGlyphBuilder(SymbolSpec symbolSpec, Dim dim, VisContext visContext) {
        this.visContext = visContext;
        this.spec = symbolSpec;
        this.extent = dim;
        this.bounds = new Bounds(this.spec.bounds, null);
        this.scaleDimensions = CustomGlyphBuilder.getScaleDimensionsValueFor(this.spec.scaleDimensions, 0);
    }

    private static int getScaleDimensionsValueFor(String string, int n) {
        if (NONE.equals(string)) {
            return 0;
        }
        if (X.equals(string)) {
            return 1;
        }
        if (Y.equals(string)) {
            return 2;
        }
        if (BOTH.equals(string)) {
            return 3;
        }
        return n;
    }

    public Shape makeCustomShape(double d, double d2, double d3, double d4, StyleSpec styleSpec) {
        Rect rect = this.bounds.getRectWithinParent(new Rect(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4));
        Shape[] shapeArray = this.createGlyphs(Shape.toRect(rect), this.spec.shape, styleSpec);
        Schema schema = new Schema(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), shapeArray, true);
        schema.setBoundsSpec(this.spec.bounds);
        if (shapeArray.length == 0) {
            return null;
        }
        this.setGlyphSizes(schema);
        if (shapeArray.length == 1) {
            shapeArray[0].setScaleDimensions(this.scaleDimensions);
        } else {
            schema.setScaleDimensions(this.scaleDimensions);
        }
        return schema;
    }

    private void setGlyphSizes(Schema schema) {
        Rect rect;
        Shape[] shapeArray = schema.getParts();
        if (shapeArray == null) {
            return;
        }
        Rect rect2 = rect = (Rect)schema.getGeom().copy();
        for (Shape shape : shapeArray) {
            Rect rect3 = Shape.toRect(shape.getBounds());
            if (shape.getInsets() != null) {
                rect3 = shape.getInsets().insetRect(rect3);
            }
            double d = 1.0;
            double d2 = 1.0;
            int n = shape.getScaleDimensions();
            shape.setScaleDimensions(3);
            String string = shape.getMeta(BUILDER);
            if (1002 == shape.getType() && !SYMBOL_BUILDER.equals(string)) {
                if (rect3.getWidth() <= 1.0 && rect3.getHeight() <= 1.0) {
                    rect3 = CustomGlyphBuilder.getPolyShapeBounds(rect2, shape);
                    d = rect3.getWidth();
                    d2 = rect3.getHeight();
                }
                shape.affine(d, rect3.getTopLeft().getX(), d2, rect3.getTopLeft().getY(), false);
            } else if (1002 == shape.getType() && !SYMBOL_BUILDER.equals(string)) {
                rect3 = CustomGlyphBuilder.getPolyShapeBounds(rect2, shape);
                d = rect3.getWidth();
                d2 = rect3.getHeight();
                shape.affine(d, rect3.getCenterX() - rect3.getWidth() / 2.0, d2, rect3.getCenterY() - rect3.getHeight() / 2.0, false);
            }
            this.defenderHack.affine(shape, d, rect.getX(), d2, rect.getY(), this.extent);
            shape.setScaleDimensions(n);
            shape.setMeta(BUILDER, null);
            if (!(shape instanceof Schema)) continue;
            this.setGlyphSizes((Schema)shape);
        }
    }

    private static Rect getPolyShapeBounds(Rect rect, Shape shape) {
        Rect rect2;
        if (shape.getContainingShape() == null || shape.getContainingShape() instanceof Schema) {
            rect2 = rect;
        } else {
            Bounds bounds = new Bounds(shape.getBoundsSpec(), null);
            rect2 = bounds.getRectWithinParent(shape.getContainingShape().getBounds());
        }
        return rect2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Shape makeSingleGlyphShape(SymbolShapeSpec symbolShapeSpec, Rect rect, Shape[] shapeArray, int n, StyleSpec styleSpec) {
        Shape shape;
        StyleSpec styleSpec2 = this.getMergedStyle(styleSpec, symbolShapeSpec.style);
        String string = symbolShapeSpec.path;
        if ("group".equals(symbolShapeSpec.type)) {
            if (shapeArray == null) {
                return null;
            }
            shape = new Schema(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), shapeArray, true);
        } else if ("path".equals(symbolShapeSpec.type)) {
            if (string == null) throw new SpecException("A shape of type path must have a 'path' parameter", ErrorCode.SPEC_INVALID_PARAMETERS, null);
            shape = CustomGlyphBuilder.makeGlyphPath(string, styleSpec2);
        } else {
            shape = SymbolBuilder.makeSymbol(symbolShapeSpec.type, rect.getCenterX(), rect.getCenterY(), rect.getWidth(), rect.getHeight(), styleSpec2, this.visContext);
            if (CustomGlyphBuilder.isPreAffinedShape(shape.getType())) {
                shape.setMeta(BUILDER, SYMBOL_BUILDER);
            }
            shape.setActualDim(null);
        }
        shape.setBoundsSpec(symbolShapeSpec.bounds);
        shape.setScaleDimensions(CustomGlyphBuilder.getScaleDimensionsValueFor(symbolShapeSpec.scaleDimensions, n));
        shape.setMeta(PART, symbolShapeSpec.part);
        shape.setMeta(TYPE, symbolShapeSpec.type);
        if (styleSpec2 == null) return shape;
        if (shape.isFilled()) {
            StyleBuilder.setFilled(shape, styleSpec2);
            return shape;
        } else {
            StyleBuilder.setUnfilled(shape, styleSpec2, null);
        }
        return shape;
    }

    protected static boolean isPreAffinedShape(int n) {
        return 1002 == n || 1003 == n;
    }

    private StyleSpec getMergedStyle(StyleSpec styleSpec, StyleSpec styleSpec2) {
        MergeStyleKey mergeStyleKey = new MergeStyleKey(styleSpec, styleSpec2);
        StyleSpec styleSpec3 = this.cachedStyles.get(mergeStyleKey);
        if (styleSpec3 == null) {
            styleSpec3 = StyleBuilder.mergeStylesForSymbols(styleSpec, styleSpec2);
            this.cachedStyles.put(mergeStyleKey, styleSpec3);
        }
        return styleSpec3;
    }

    static Rect makeSingleGlyphShapeBounds(Rect rect, StyleSpec styleSpec, BoundsSpec boundsSpec, Dim dim) {
        Rect rect2 = rect;
        if (boundsSpec != null) {
            Bounds bounds = new Bounds(boundsSpec, null);
            rect2 = bounds.getRectWithinParent(rect.getBounds());
            assert (rect2 != null);
        } else if (styleSpec != null) {
            double d = rect2.getX();
            double d2 = rect2.getY();
            double d3 = rect2.getWidth();
            double d4 = rect2.getHeight();
            if (styleSpec.size != null) {
                double d5 = Math.max(rect.getWidth(), rect.getHeight());
                double d6 = Math.max(dim.getWidth(), dim.getHeight());
                Double d7 = UnitConverter.convertLength(styleSpec.size, d5, d6);
                if (d7 == null) {
                    throw new SpecException("size could not be parsed.", ErrorCode.SPEC_INVALID_LENGTH, styleSpec.size.toString());
                }
                d4 = d3 = d7.doubleValue();
            }
            if (styleSpec.width != null) {
                Double d8 = UnitConverter.convertLength(styleSpec.width, rect.getWidth(), dim.getWidth());
                if (d8 == null) {
                    throw new SpecException("width could not be parsed.", ErrorCode.SPEC_INVALID_LENGTH, styleSpec.width.toString());
                }
                d3 = d8;
            }
            if (styleSpec.height != null) {
                Double d9 = UnitConverter.convertLength(styleSpec.height, rect.getHeight(), dim.getHeight());
                if (d9 == null) {
                    throw new SpecException("height could not be parsed.", ErrorCode.SPEC_INVALID_LENGTH, styleSpec.height.toString());
                }
                d4 = d9;
            }
            rect2 = new Rect(d, d2, d3, d4);
        }
        return rect2;
    }

    private static Shape makeGlyphPath(String string, StyleSpec styleSpec) {
        PolyGeom polyGeom = PolyGeom.makePolyGeom(string);
        Path path = new Path(polyGeom.getX(), polyGeom.getY(), polyGeom.isClosed(), polyGeom.getTypes());
        path.setSnap(StyleBuilder.getSnap(styleSpec));
        return path;
    }

    protected final Shape[] createGlyphs(Rect rect, SymbolShapeSpec[] symbolShapeSpecArray, StyleSpec styleSpec) {
        if (symbolShapeSpecArray == null) {
            return null;
        }
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        for (SymbolShapeSpec symbolShapeSpec : symbolShapeSpecArray) {
            Rect rect2 = CustomGlyphBuilder.makeSingleGlyphShapeBounds(rect, symbolShapeSpec.style, symbolShapeSpec.bounds, this.extent);
            Insets insets = null;
            if (symbolShapeSpec.style != null) {
                insets = Insets.makeForStylePadding(symbolShapeSpec.style.padding, rect2.getExtent(), this.extent);
                rect2 = insets.insetRect(rect2);
            }
            Shape[] shapeArray = this.createGlyphs(rect2, symbolShapeSpec.shape, styleSpec);
            Shape shape = this.makeSingleGlyphShape(symbolShapeSpec, rect2, shapeArray, 3, styleSpec);
            shape.setInsets(insets);
            arrayList.add(shape);
            if (symbolShapeSpec.shape == null || shape.getType() == 1010) continue;
            for (Shape shape2 : shapeArray) {
                shape2.setContainingShape(shape);
                arrayList.add(shape2);
            }
        }
        return arrayList.toArray(new Shape[arrayList.size()]);
    }
}

