/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.scene;

import com.ibm.vis.engine.internal.grammar.label.FontMetric;
import com.ibm.vis.engine.internal.grammar.label.NativeFontMetric;
import com.ibm.vis.engine.internal.grammar.label.PrecomputedFontMetric;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.FontMetricType;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.scenetree.provisional.FontInfo;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Font
implements FontInfo {
    private String family;
    private boolean bold;
    private String style;
    private double size;
    private double metricsSize;
    private final boolean modified;
    private FontMetric metrics;
    public static final String PIXEL_UNIT_IDENTIFIER = "px";
    public static final String ELLIPSIS = "\u2026";
    public static final String HASH = "#";
    public static final String BOLD = "bold";
    public static final String NORMAL = "normal";
    public static final String REGULAR = "regular";
    public static final String ITALIC = "italic";
    private boolean _usesFractionalMetrics;
    private FontMetricType fontMetricType;
    private Double minimumSize = 0.0;

    protected Font(String string, double d, boolean bl, String string2, boolean bl2, boolean bl3, FontMetricType fontMetricType) {
        this.family = string;
        this._usesFractionalMetrics = bl3;
        this.setSize(Math.max(0.0, MathUtil.r3(d).doubleValue()));
        this.bold = bl;
        this.modified = bl2;
        this.style = string2;
        this.fontMetricType = fontMetricType;
    }

    private void setSize(double d) {
        this.size = d;
        this.metricsSize = this.usesFractionalMetrics() ? this.size : (double)((int)Math.floor(this.size + 0.5));
    }

    @Override
    public final double getSize() {
        return this.size;
    }

    @Override
    public final String getFamily() {
        return this.family;
    }

    public final boolean getBold() {
        return this.bold;
    }

    @Override
    public final String getStyle() {
        return this.style;
    }

    public final int getAmountThatFits(String string, double d) {
        FontMetric fontMetric = this.getMetric();
        return fontMetric.getAmountThatFits(string, this.metricsSize, this.bold, d);
    }

    @Override
    public double getAscent() {
        FontMetric fontMetric = this.getMetric();
        return fontMetric.getAscent(this.metricsSize);
    }

    public final double getDescent() {
        return this.getHeight() - this.getAscent();
    }

    public final double getHeight() {
        FontMetric fontMetric = this.getMetric();
        return fontMetric.getHeight(this.metricsSize);
    }

    public final double getWidth(Text text) {
        return this.getWidthFromString(text.getText());
    }

    public final double getWidthFromTextContent(TextContent textContent) {
        return this.getWidthFromString(textContent.getText());
    }

    public final double getWidthFromString(String string) {
        FontMetric fontMetric = this.getMetric();
        return fontMetric.getWidth(string, this.metricsSize, this.bold);
    }

    public final double measureString(String string) {
        return this.getMetric().getWidth(string, this.metricsSize, this.bold);
    }

    public final String getMetricsId() {
        return this.family + "/" + this.metricsSize + "/" + (this.bold ? "b" : "n");
    }

    public final boolean usesFractionalMetrics() {
        return this._usesFractionalMetrics;
    }

    public final double getEllipsisSize() {
        return this.getMetric().getWidth(ELLIPSIS, this.metricsSize, this.bold);
    }

    public final double getHashSize() {
        return this.getMetric().getWidth(HASH, this.metricsSize, this.bold);
    }

    public final FontMetric getMetric() {
        if (this.metrics == null) {
            if (this.fontMetricType == FontMetricType.PRECOMPUTED) {
                String[] stringArray;
                String string = this.family.toLowerCase();
                for (String string2 : stringArray = string.split(",")) {
                    string2 = string2.trim();
                    this.metrics = PrecomputedFontMetric.get(string2);
                    if (this.metrics != null) break;
                }
                if (this.metrics == null) {
                    throw new IllegalArgumentException("requested font " + this.family + " not supported by PRECOMPUTED metrics.");
                }
            } else if (this.fontMetricType == FontMetricType.NATIVE) {
                this.metrics = NativeFontMetric.get(this);
            }
        }
        return this.metrics;
    }

    public final Font modifySize(double d) {
        double d2 = Math.max(d, this.minimumSize);
        Font font = new Font(this.getFamily(), d2, this.getBold(), this.getStyle(), true, this.usesFractionalMetrics(), this.getMetricType());
        font.setMinimumSize(this.getMinimumSize());
        return font;
    }

    @Override
    public final String getWeight() {
        return this.bold ? BOLD : null;
    }

    public final FontMetricType getMetricType() {
        return this.fontMetricType;
    }

    public final Double getMinimumSize() {
        return this.minimumSize;
    }

    public final void setMinimumSize(Double d) {
        if (d == null) {
            return;
        }
        this.minimumSize = d;
    }
}

