/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.scene;

import com.ibm.vis.engine.internal.grammar.label.FontMetric;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.PlatformDefaults;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.spec.internal.FontSpec;

public class FontHelper {
    private static final double DEFAULT_FONT_SIZE = 12.0;
    private static final String DEFAULT_FONT_WEIGHT = "bold";
    private static final String DEFAULT_FONT_FAMILY = "Arial,SansSerif,sans-serif";

    private static double getAdjustedFontSize(Double d, double d2) {
        if (d != null && d > d2) {
            return d;
        }
        return d2;
    }

    public static double getDefaultFontSize(Double d) {
        return FontHelper.getAdjustedFontSize(d, 12.0);
    }

    public static Font makeForSize(Double d, Double d2, boolean bl) {
        double d3 = d == null ? FontHelper.getDefaultFontSize(d2) : d;
        d3 = FontHelper.getAdjustedFontSize(d2, d3);
        return FontHelper.makeDefaultFont(d3, d2, bl);
    }

    public static Font makeFromSpecDeprecated(FontSpec fontSpec, Double d) {
        return FontHelper.makeFromSpec(fontSpec, d, PlatformDefaults.usesFractionalMetrics);
    }

    public static Font makeFromSpec(FontSpec fontSpec, Double d, boolean bl) {
        if (fontSpec == null) {
            return FontHelper.makeDefaultFont(FontHelper.getDefaultFontSize(d), d, bl);
        }
        return FontHelper.makeFontFromSpec(fontSpec, d, bl);
    }

    public static Font makeDefaultFont(double d, Double d2, boolean bl) {
        Font font = new Font(DEFAULT_FONT_FAMILY, d, false, null, true, bl, PlatformDefaults.fontMetricType);
        font.setMinimumSize(d2);
        return font;
    }

    private static Font makeFontFromSpec(FontSpec fontSpec, Double d, boolean bl) {
        Object object = fontSpec.getCachedObject();
        if (object != null) {
            return (Font)object;
        }
        String string = fontSpec.family;
        boolean bl2 = DEFAULT_FONT_WEIGHT.equals(fontSpec.weight);
        Double d2 = null;
        double d3 = FontHelper.getDefaultFontSize(d);
        if (fontSpec.size != null) {
            d2 = UnitConverter.convertLength(fontSpec.size, d3, d3);
        }
        if (d2 == null) {
            d2 = d3;
        }
        d2 = FontHelper.getAdjustedFontSize(d, d2);
        Font font = new Font(string, d2, bl2, fontSpec.style, true, bl, PlatformDefaults.fontMetricType);
        font.setMinimumSize(d);
        Font font2 = FontHelper.getFontWithMetrics(string, bl2, d2, fontSpec.style, font, d);
        fontSpec.setCachedObject(font2);
        return font2;
    }

    private static Font getFontWithMetrics(String string, boolean bl, double d, String string2, Font font, Double d2) {
        FontMetric fontMetric = font.getMetric();
        String string3 = fontMetric.getActualFamily();
        if (!string3.toLowerCase().equals(string.toLowerCase())) {
            font = new Font(string3, d, bl, string2, true, font.usesFractionalMetrics(), font.getMetricType());
        }
        font.setMinimumSize(d2);
        return font;
    }
}

