/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.scene;

import com.ibm.vis.engine.internal.ImageStyle;
import com.ibm.vis.engine.internal.globalization.NumericShapingInfo;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.MultiPartText;
import com.ibm.vis.engine.internal.struct.Path;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.ShapeLine;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.spec.internal.StrokeSpec;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ItemBuilder {
    private static final String FILL_TRANSPARENT = "transparent";

    public static ShapeLine makeLine(double d, double d2, double d3, double d4, StyleSpec styleSpec) {
        ShapeLine shapeLine = new ShapeLine(new double[]{d, d3}, new double[]{d2, d4}, false);
        if (styleSpec == null) {
            StyleBuilder.setDefaultStrokeStyle(shapeLine);
        } else {
            StyleBuilder.setUnfilled(shapeLine, styleSpec, null);
        }
        shapeLine.setSnap(StyleBuilder.getSnap(styleSpec));
        return shapeLine;
    }

    public static PolyShape makeLineForPoints(double[] dArray, double[] dArray2, StyleSpec styleSpec) {
        PolyShape polyShape;
        if (dArray.length == 2 && dArray2.length == 2) {
            polyShape = new ShapeLine(dArray, dArray2, false);
        } else {
            int n = dArray.length;
            char[] cArray = new char[n];
            if (n > 0) {
                cArray[0] = 77;
                for (int i = 1; i < n; ++i) {
                    cArray[i] = 76;
                }
            }
            polyShape = new Path(dArray, dArray2, false, cArray);
        }
        if (styleSpec == null) {
            StyleBuilder.setDefaultStrokeStyle(polyShape);
        } else {
            StyleBuilder.setUnfilled(polyShape, styleSpec, null);
        }
        polyShape.setSnap(StyleBuilder.getSnap(styleSpec));
        return polyShape;
    }

    public static Shape makePoly(double[] dArray, double[] dArray2, StyleSpec styleSpec) {
        ShapePoly shapePoly = new ShapePoly(dArray, dArray2, true, null);
        if (styleSpec != null) {
            StyleBuilder.setFilled(shapePoly, styleSpec);
            shapePoly.setSnap(StyleBuilder.getSnap(styleSpec));
        }
        return shapePoly;
    }

    public static Shape makeRectangle(double d, double d2, double d3, double d4, StyleSpec styleSpec) {
        boolean bl = StyleBuilder.isCornerRadiusFixed(styleSpec);
        double d5 = StyleBuilder.getRectangleCornerRadius(styleSpec, d3, d4, bl);
        Shape shape = null;
        shape = d5 > 0.0 ? ShapeFactory2.CreateRoundedRect(d, d2, d3, d4, d5, bl) : ShapeFactory2.CreateRect(d, d2, d3, d4);
        if (styleSpec != null) {
            shape.setDefaultStyle(styleSpec);
        }
        return shape;
    }

    public static Text makeText(TextContent textContent, double d, double d2, String string, String string2, Font font, StyleSpec styleSpec, StyleSpec styleSpec2, Dim dim, boolean bl, String string3, NumericShapingInfo numericShapingInfo, boolean bl2) {
        if (textContent == null) {
            return null;
        }
        boolean bl3 = textContent.hasImages() || textContent.hasPartStyles() || ItemBuilder.isMultiLineTextContent(font, textContent, dim);
        Text text = bl3 ? MultiPartText.createMultiPartTextWithShapedValue(textContent, d, d2, string, string2, font, styleSpec, styleSpec2, string3, dim, bl, bl2) : Text.createTextWithUnshapedValue(textContent.getText(), d, d2, string, string2, font, styleSpec, styleSpec2, string3, numericShapingInfo, dim, bl2);
        if (text != null && text.getNumLines() == 0) {
            return null;
        }
        if (text != null) {
            text.setSnap(StyleBuilder.getSnap(styleSpec));
        }
        return text;
    }

    public static boolean isMultiLineTextContent(Font font, TextContent textContent, Dim dim) {
        if (dim != null && (dim.getWidth() <= 0.0 || dim.getHeight() <= 0.0) || textContent == null || textContent.isEmptyString()) {
            return false;
        }
        if (textContent.isMultiLine()) {
            return true;
        }
        return dim != null && font.getWidthFromTextContent(textContent) > dim.getWidth() && 2.0 * font.getHeight() <= dim.getHeight();
    }

    public static boolean isMultiLineText(Font font, Text text, Dim dim) {
        if (dim != null && (dim.getWidth() <= 0.0 || dim.getHeight() <= 0.0) || text == null) {
            return false;
        }
        if (text.getText().indexOf("\n") >= 0) {
            return true;
        }
        return dim != null && font.getWidth(text) > dim.getWidth() && 2.0 * font.getHeight() <= dim.getHeight();
    }

    public static SceneNode createOutlineShape(Rect rect, StyleSpec styleSpec, String string) {
        assert (styleSpec != null);
        Object object = styleSpec.fill;
        styleSpec.fill = FILL_TRANSPARENT;
        Rect rect2 = new Rect(0.0, 0.0, rect.getWidth(), rect.getHeight());
        SceneNode sceneNode = ItemBuilder.createBackgroundShape(rect2, styleSpec, string);
        styleSpec.fill = object;
        return sceneNode;
    }

    public static SceneNode createFillShape(Rect rect, StyleSpec styleSpec, String string) {
        assert (styleSpec != null);
        StrokeSpec strokeSpec = styleSpec.stroke;
        Object object = styleSpec.outline;
        Rect rect2 = new Rect(0.0, 0.0, rect.getWidth(), rect.getHeight());
        styleSpec.stroke = null;
        styleSpec.outline = null;
        SceneNode sceneNode = ItemBuilder.createBackgroundShape(rect2, styleSpec, string);
        styleSpec.stroke = strokeSpec;
        styleSpec.outline = object;
        return sceneNode;
    }

    public static SceneNode createBackgroundShape(Rect rect, StyleSpec styleSpec, String string) {
        Shape shape = ItemBuilder.makeRectangle(0.0, 0.0, rect.getWidth(), rect.getHeight(), styleSpec);
        shape.setID(string);
        ImageStyle.addIconToBackground(shape);
        SceneNodeImpl sceneNodeImpl = shape.createSceneNode();
        Point point = rect.getTopLeft();
        sceneNodeImpl.translate(point.getX(), point.getY());
        return sceneNodeImpl;
    }
}

